#include <stdio.h>
#include "arch.h"
#include "user.h"
#define YES  1
#define NO  -1

extern int arch_level;
extern int break_on;
extern int single_step;
extern int stop_instruction;
extern int stats, cycles1, cycles2, nwfetches, nwstores;
extern int traceregs[24];
extern SCRATCHPAD spr[16];
extern SCRATCHPAD oreg[7];
extern int rdstate, wrstate;

void initialize(expert)
  int expert;
/*
   initializes the user-interaction variables (see externs) and
   loads both memories.  Also sets the two pcs to zero
                                                                */
{
  char ch;
  int j;

  set_mic_constants();
  spr[PC] = 0;    /* pc */
  oreg[MPC] = 0;   /* mpc */
  for(j=0;j<24;++j)
    traceregs[j] = NO;
  break_on = NO;
  single_step = NO;
  stop_instruction = NO;
  stats = NO;
  cycles1 = 0;
  cycles2 = 0;
  nwfetches = 0;
  nwstores = 0;
  rdstate = 0;  wrstate = 0;
  if(!expert)
    { arch_level = MICRO;
      proc_load(1);
      arch_level = MACRO;
      proc_load(1);
      prompt("need help?");
      ch = getc(stdin); 
      if(ch == 'Y' || ch == 'y')
           {fflush(stdin);
    	    dohelp();
           }
      else
          {ungetc(ch,stdin);
           fflush(stdin);
          }
     }
  arch_level = MACRO;
  return;
} 
