

/* fairly general "front-end" for Linda workers, POSYBL implementation 

   usage:  

      POSYBLDriver nodefile worker_name number_of_workers integer_args

   the nodefile must be specified via a full path name (use of ~/ OK)

   this front end will initiate of execution number_of_workers copies of
   the program worker_name, passing on the integer arguments to them

   to accomplish the latter, this front end will produce a tuple with
   tag "number of arguments", followed by tuples for each argument,
   with tags: "argument" and the argument number (first being number
   0) 

   this front end will also output tuples with tags "whoami" (carrying
   the node number) and "number of workers", for the workers to pick
   up

*/

main(argc, argv)
   int argc; char **argv;

{  int Node,NWorkers,NIntArg,I;  char WorkerName[100],NodeFile[100];

   NWorkers = atoi(argv[3]);

   /* specifies the group number and the startup file */
   init(0,argv[1]);
  
   /* start up a worker at each node */
   strcpy(WorkerName,"#2/");
   strcat(WorkerName,argv[2]);
   for (Node = 0; Node < NWorkers; Node++)  { 
      /* eval_l() function starts the worker via rsh; functions
         like lstring(), lint() convert to tuple fields */
      eval_l(WorkerName,0);
      /* out() adds a tuple to the tuple space, in this case
         consisting of a string and an integer; here we are
	 setting things up so that each worker can get its
	 own id */
      out(lstring("whoami"),lint(Node));
   }

   /* pass along information to the workers */
   out(lstring("number of workers"),lint(NWorkers));
   out(lstring("number of arguments"),lint(argc-4));
   if (argc > 4)  {
      for (I = 0; I < argc-4; I++)
         out(lstring("argument"),lint(I),lint(atoi(argv[4+I])));
   }

   /* must wait for workers to exit */
   for (Node = 0; Node < NWorkers; Node++)
      in(lstring("front end may exit"));

   /* clean up the tuple space */
   in(lstring("number of workers"),lint(NWorkers));
   in(lstring("number of arguments"),lint(argc-4));
   for (I = 0; I < argc-4; I++)
      in(lstring("argument"),lint(I),lint(atoi(argv[4+I])));
}
