#include <stdio.h>

/* 
 * global variables
 */

static int mwidth;
static double upper_x, incrx;
static int max_iter, wwidth;
static int depth;


/*
 * worker operation which calculates the number of iterations
 * required to make |Zn| >= 2
 */
void calc_row(in, out)
	double *in;
	unsigned char *out;
 {
	int ix, i;
	double x, wx, wy, oldwx;
	double y;
	unsigned char* dp;

	y = *(double*) in;
	dp = (unsigned char*) out;
	x = upper_x;
	if (depth == 1)
		bzero(dp, mwidth);
	for (ix = 0; ix < wwidth; ++ix, x += incrx) {
		wx = x; wy = y;
		for (i = 0; i < max_iter; ++i) {
			oldwx = wx;
			wx = wx * wx - wy * wy + x;
			wy = 2 * oldwx * wy + y;
			if ((wx * wx + wy * wy) > 4) break;
		}
		if (depth > 1)
			dp[ix] = i;
		else
			if (i == max_iter) dp[ix/8] |= (1 << (7-(ix % 8)));
			/*if (i == max_iter) dp[ix/8] |= (1 << (7 - (ix % 8)));*/
	}
}


/*
 * definitions of context operation
 */

void set_x( arg)
double *arg ;
{
	upper_x = *(double*) arg;
}

void set_incrx(arg) 
double *arg;
{
	incrx = *(double*) arg;
}

void set_iter( arg) 
int *arg;
{
	max_iter = *(int*) arg;
}

void set_depth(arg) 
int *arg;
{
	depth = *(int*) arg;
}

void set_wwidth(arg)
int *arg;
 {
	wwidth = *(int*) arg;
}

void set_mwidth( arg) 
int *arg;
{
	mwidth = *(int*) arg;
}


