.TH POSYBL 1L "9 March 1991"
.SH NAME
posybl \- library routines for using the POSYBL (a free Linda implementation for Unix Networks) 
.SH SYNOPSIS AND DESCRIPTION
.LP
These routines implement the Linda model of paralleling programming
and allow C programmers to issue tuple space operations
to the Tuple Managers. 
.LP
.ft B
.nf
.sp .5
init(rungroup, nodefile)
int rungroup;
char *nodefile;
.fi
.ft R
.IP
Specifies that this process belongs to the 
.I rungroup 
POSYBL Program and that is going to load the node list
from the file
.I nodefile.
In case, 
.I nodefile
is NULL the routine searches for the file
~/.nodefile
and if not found for ./.nodefile.
If this routine is not called, the process rungroup is supposed to be
0 and the default files are loaded.
.LP
.ft B
.nf
.sp .5
out(tuple description)
.fi
.ft R
.IP
Write a tuple to the tuple space.
The tuple description is given by the use of the field description 
functions.
.LP
.ft B
.nf
.sp .5
in(template description)
rd(template description)
.fi
.ft R
.IP
Request a tuple that matches the template from the tuple space.
With in(), the tuple is deleted from the tuple space.
With rd(), it remains.
The template description is given by the use of the field description 
functions. You must remember that the first field of a template is
should always be an actual since it is used as a key for storing the
tuples in a hash table.
.LP
.ft B
.nf
.sp .5
eval_l(arg0, arg1,...,argn, NULL),
char *arg0,...,*argn;
eval_v(argv)
char **argv;
eval_nl(node, arg0,...,argn, NULL)
char *node, *arg0,...,*argn;
eval_nv(node, argv)
char *node;
char **argv;
.fi
.ft R
.IP
A 'rsh' invocation of an executable. It's doubtful, if you can
call this function eval(). The first two forms invoke the
executable in the least loaded node, if the nodes support
get_rusage() calls or the one with the highest preference value
otherwise. In the last two, the node must be specified by the user.
You should remember that the programs started with this way can 
print in the terminal but they cannot wait for input from the terminal.
All input to them should either from the arguments to these calls
or through the tuple space (the initial process should ask for input
and then would send it to the one that needs it).
.LP
.ft B
.nf
.sp .5
l<type>(var);
<type> var;
ql<type>(varptr);
<type> *varptr;
ln<type>(array, length);
<type> *array;
int length;
ln<type>(arrayptr, lengthptr);
<type> **arrayptr;
int *lengthptr;
.fi
.ft R
.IP
Field description functions. They are used to describe the fields
in a tuple access call. 
The 
.I <type> 
can be one of 
.I char, 
.I short, 
.I int, 
.I float, 
.I double 
and 
.I string.
The form 
.I l<type>
specifies that a field is a scalar actual field.
The argument 
.I var
to these routines is a variable (or constant) of the appropriate
.I <type>
.
The form
.I ql<type>
specifies that a field is a scalar formal field. These routines
are used to describe the formal fields, only, of a template, since
formal fields are not allowed in tuples.
The argument 
.I varptr
to these routines is the address of a variable 
of the corresponding type and
in which the tuple's data will be copied. If you are not interested
in the data, you should pass the NULL pointer as argument.
The form
.I ln<type> 
specifies that a field is a vector actual field.
The argument 
.I array
to these routines is a pointer to a data area that contains 
.I length
elements. We must note that the
.I <string>
scalar type doesn't have a corresponding vector type.
The form
.I qln<type> 
specifies that a field is a vector formal field.
The argument 
.I arrayptr
is the address of a pointer to the corresponding type and the argument
.I lengthptr
is the address of an int, in which the number of elements of
the array will be copied. If you are not interested
in the data and/or their length, you should pass the NULL pointer 
as argument.
The address in
.I arrayptr
is in a static area that will be overwritten after another call
to in(), rd() or out().
In order, to pass user defined structures a simple way is the 
following:
.LP
.nf
.RS
.DT
.ft B

struct ex {
	int iv;
	float fv;
	char *st;
};

#define lex(a) lint(a.iv),lfloat(a.fv),lstring(a.st)
#define qlex(a) qlint(&((a)->iv)),qlfloat(&((a)->fv)),qlstring(&(a)->st)

struct example tst;
out(lint(10), lex(tst));
in(lint(10), qlex(&tst));
.ft R
.RE
.fi
.LP
.ft B
.nf
.sp .5
copychars(dest, src, len)
char *dest;
char *src;
int len;
copyshorts(dest, src, len)
short *dest;
short *src;
int len;
copyints(dest, src, len)
int *dest;
int *src;
int len;
copyfloats(dest, src, len)
float *dest;
float *src;
int len;
copydoubles(dest, src, len)
double *dest;
double *src;
int len;
.fi
.ft R
.IP
Analogous to memcpy() function. 
Copy 
.I len
elements from 
.I src
to 
.I dest.
In fact, copychars() is a 
direct call to memcpy(). But, copyints() is generally
faster than memcpy() and I find them more convenient than
memcpy().
.LP
.ft B
.nf
.sp .5
timer_start();
timer_split(str);
char *str;
print_times();
.fi
.ft R
.IP
These routines are intended for gathering timing 
information about your program. The routine timer_start() resets
the system. The routine timer_split() keeps a note of the time
it is called and attaches str to it as a label. The routine
print_times() prints the notes it has kept by the time it is 
called. Time information is kept in elapsed time. up to 32 time
notes can be kept.
.SH FILES
 ~/.nodefile,
 ./.nodefile
.SH SEE ALSO
.BR NodeFile(1L),
.BR startup(1L),
.BR system(1L),
.BR tmanager(1L)
.SH BUGS (Some call them features)
Numerous, I guess. I just haven't find them yet.
.SH AUTHOR
Ioannis Schoinas, sxoinas@csd.uch.gr
.SH ACKNOWLEDGEMENTS
I would like to thank everybody that helped me in writing this program
and especially I. Kavaklis for offering his ideas, some pieces of code,
demo programs, and for being the first subject to test this system.
.SH NOTE
Linda, is a trademark of SCA, Inc.
