#ifndef lint
static char     sccsid[] = "@(#)hmatch.c";
static char     Creator[] = "C 1991 G. Sxoinas csi.forth.gr \n";
static char     Mail[] = "sxoinas@ariadne.bitnet or sxoinas@csi.forth.gr";
#endif
/*
 * This file is part of the POSYBL (PrOgramming SYstem for distriButed
 * appLications, a free Linda implementation for Unix Networks) and contains
 * the match functions for the hashing routines.
 * 
 * There are no restrictions on this code; however, if you make any changes, I
 * request that you document them so that I do not get credit or blame for your
 * modifications.
 * 
 * Written by Ioannis Schoinas (sxoinas@csd.uch.gr or sxoinas@csi.forth.gr),
 * Computer Science Department, University of Crete, Heraclion, Crete, Greece.
 * 
 * Note: Linda is a trademark of SCA, Inc.
 * 
 */
#include    "linda_defs.h"
#include    "hsearch.h"

extern char    *skip_field();

int
EntryMatch(ent1, ent2)		/* Two pointers are equal */
  register ENTRY *ent1, *ent2;
{
  return (ent1 == ent2);
}

int
MessageMatch(ent1, ent2)	/* A message is the same. Used for non Local
				 * Templates */
  register ENTRY *ent1, *ent2;
{
  if ((ent1->rest->pid == ent2->rest->pid) &&
      (ent1->rest->node.s_addr == ent2->rest->node.s_addr) &&
      (ent1->databytes == ent2->databytes) &&
      (ent1->keybytes == ent2->keybytes))
    return
      (memcmp(ent1->buffer, ent2->buffer, ent1->databytes + ent1->keybytes) == 0);
  else
    return (FALSE);
}

static int
EqualData(f1, f2)		/* The data of a tuple and a template aggree.
				 * Used by the main match routine that matches
				 * tuples and templates */
  register char  *f1, *f2;
{
  register int    t1 = *(int *) f1;
  register int    len1, len2;

  f1 += sizeof(int);
  f2 += sizeof(int);

  switch (t1)
  {
  case CHAR:
    return (*f1 == *f2);
  case SHORT:
    return (*(short *) f1 == *(short *) f2);
  case INT:
    return (*(int *) f1 == *(int *) f2);
  case FLOAT:
    return (*(float *) f1 == *(float *) f2);
  case DOUBLE:
    return (*(double *) f1 == *(double *) f2);
  case CHAR_STRING:
    return (strcmp(f1, f2) == 0);
  case ARRAY_OF_CHAR:
    len1 = *(int *) f1;
    len2 = *(int *) f2;
    if (len1 != len2)
      return (FALSE);
    f1 += sizeof(int);
    f2 += sizeof(int);
    return (memcmp(f1, f2, len1 * sizeof(char)) == 0);
  case ARRAY_OF_SHORT:
    len1 = *(int *) f1;
    len2 = *(int *) f2;
    if (len1 != len2)
      return (FALSE);
    f1 += sizeof(int);
    f2 += sizeof(int);
    return (memcmp(f1, f2, len1 * sizeof(short)) == 0);
  case ARRAY_OF_INT:
  case ARRAY_OF_FLOAT:
    len1 = *(int *) f1;
    len2 = *(int *) f2;
    if (len1 != len2)
      return (FALSE);
    f1 += sizeof(int);
    f2 += sizeof(int);
    return (memcmp(f1, f2, len1 * sizeof(int)) == 0);
  case ARRAY_OF_DOUBLE:
    len1 = *(int *) f1;
    len2 = *(int *) f2;
    if (len1 != len2)
      return (FALSE);
    f1 += sizeof(int);
    f2 += sizeof(int);
    return (memcmp(f1, f2, len1 * sizeof(double)) == 0);
  default:
    return (FALSE);
  }
}

int
TemplateMatch(Tuple, Template)	/* The main match routine */
  ENTRY          *Tuple, *Template;
{
  register int    i;
  register int    nfields;
  int             ted;
  register char  *teptr, *tuptr;

  if (Tuple->keybytes != Template->keybytes)
    return (FALSE);
  if (memcmp(Tuple->buffer, Template->buffer, Template->keybytes) != 0)
    return (FALSE);
  nfields = *((int *) Template->buffer);
  if (nfields == 1)
    return (TRUE);
  teptr = Template->buffer + Template->keybytes;
  tuptr = Tuple->buffer + Tuple->keybytes;
  for (i = 0; i < nfields - 1; i++)
  {
    ted = *((int *) (teptr));
    if (!isformal(ted))
    {
      if (!EqualData(tuptr, teptr))
	return (FALSE);
    }
    tuptr = skip_field(tuptr);
    teptr = skip_field(teptr);
  }
  return (TRUE);
}

int
TupleMatch(Template, Tuple)	/* Reverse matching(have the tuple look for a
				 * template) */
  ENTRY          *Tuple, *Template;
{
  return (TemplateMatch(Tuple, Template));
}

int
UserMatch(ent1, ent2)		/* Match routine for the Users table */
  ENTRY          *ent1, *ent2;
{
  return (((int *) (ent1->buffer))[0] == ((int *) (ent2->buffer))[0] &&
	  ((int *) (ent1->buffer))[1] == ((int *) (ent2->buffer))[1]);
}
