#ifndef lint
static char     sccsid[] = "@(#)hsearch.c";
static char     Creator[] = "C 1991 G. Sxoinas csi.forth.gr \n";
static char     Mail[] = "sxoinas@ariadne.bitnet or sxoinas@csi.forth.gr";
#endif
/*
 * This file is part of the POSYBL (PrOgramming SYstem for distriButed
 * appLications, a free Linda implementation for Unix Networks) and contains
 * the hash routines used by the Tuple Manager. It is a modified version of the
 * System V hsearch routines.
 * 
 * There are no restrictions on this code; however, if you make any changes, I
 * request that you document them so that I do not get credit or blame for your
 * modifications.
 * 
 * Written by Ioannis Schoinas (sxoinas@csd.uch.gr or sxoinas@csi.forth.gr),
 * Computer Science Department, University of Crete, Heraclion, Crete, Greece.
 * 
 * These routines were based on a implementation of System V hash routines that I
 * found from the net, a while ago. The author was Arnold Robbins, SICS,
 * Georgia Institute of Technology.
 * 
 * Note: Linda is a trademark of SCA, Inc.
 * 
 */

#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>

#include "linda_defs.h"
#include "hsearch.h"

static unsigned short primetab[] = {1, 3, 5, 7,
  11, 23, 31, 41, 53, 73, 101, 127, 139, 173, 211, 337, 401,
  503, 1009, 1511, 2003, 2503, 3001, 3511, 4001, 4507, 5003, 5501, 6007,
  6521, 7001, 8009, 9001, 10007, 11003, 12007, 13001, 14009, 15013, 16001,
  17011, 18013, 19001, 20011, 21001, 22003, 23003, 24001, 25013, 26003,
  27011, 28001, 29009, 30011, 31013, 32003, 33287, 34019, 35023, 36241,
  38231, 39019, 40111, 42019, 44041, 46099, 48221, 51001, 54083, 58237,
  60013, 65521
};

/* idestroy --- destroy a single element on a chain */

static void
idestroy(elem)
  register ELEMENT *elem;
{

  if (elem != NULL)
  {
    idestroy(elem->next);
    free(elem->item.buffer);
    if (elem->item.rest != NULL)
    {
      if (elem->item.rest->msg != NULL)
      {
	/* Deal with pending requests (local msg's) */
	Rpc_Error(elem->item.rest->msg, RPC_DISCONNECT);
	free(elem->item.rest->msg);
      }
      if (elem->item.rest->event != NULL)
      {
	/*
	 * Deal with pending events (template purges & sends)
	 */
	Rpc_EventDelete(elem->item.rest->event);
      }
      free(elem->item.rest);
    }
    free(elem);
  }
}

/* hdestroy --- nuke the existing hash table */

void
my_hdestroy(Tptr)
  register TABLE_OBJECT *Tptr;
{
  register unsigned int i;

  if (Tptr != NULL)
  {
    if (Tptr->Table != NULL)
    {
      /* free all the chains */
      for (i = 0; i < Tptr->Size; i++)
	idestroy(Tptr->Table[i]);

      /* now the table itself */
      free((char *) Tptr->Table);
    }
    free(Tptr);
  }
}


/* hcreate --- create a hash table at least num big */

TABLE_OBJECT   *
my_hcreate(num)
  register int    num;
{
  register int    i, j;
  register TABLE_OBJECT *tmp;

  /*
   * find first prime number >= num, and use it for table size
   */

  j = sizeof(primetab) / sizeof(primetab[0]);
  for (i = 0; i < j; i++)
    if (primetab[i] >= num)
      break;

  if (i < j)			/* num bigger than any */
    num = primetab[i];		/* prime we have, use it   */

  tmp = (TABLE_OBJECT *) malloc(sizeof(TABLE_OBJECT));
  tmp->Size = num;
  tmp->Table = (ELEMENT **) calloc(num, sizeof(ELEMENT *));
  return (tmp);
}

/* hsearch --- lookup or enter an item in the hash table */

ENTRY          *
my_hsearch(Tptr, entry, action, match)
  register TABLE_OBJECT *Tptr;
  register ENTRY *entry;
  register ACTION action;
  int             (*match) ();
{
  register int    Num_elem;
  register ELEMENT **Table;
  register ELEMENT *ep = NULL;
  register ELEMENT *ep2 = NULL;
  register ENTRY *ent = NULL;
  register int    index;

  if (Tptr == NULL)
    return (NULL);

  Table = Tptr->Table;
  if (Table == NULL)
    return (NULL);

  Num_elem = Tptr->Size;
  index = hashvalue(Num_elem, entry->buffer, entry->keybytes);
  if (index < 0)
  {
    fprintf(stderr, "hsearch: Something is corrupted\n");
    exit(2);
  }
  if (Table[index] == NULL)	/* nothing there */
    switch (action)
    {
    case FIND:
    case REMOVE:
      return NULL;
    case ENTER:
      ep = Table[index] = (ELEMENT *) malloc(sizeof(ELEMENT));
      ep->item = *entry;
      ep->next = NULL;
      return (&(ep->item));
    default:
      fprintf(stderr, "Hsearch: Invalid action\n");
      return NULL;
    }
  else
    switch (action)
    {
    case ENTER:
      ep = (ELEMENT *) malloc(sizeof(ELEMENT));
      ep->item = *entry;
      ep->next = Table[index];
      Table[index] = ep;
      return (&(ep->item));
    case FIND:
      for (ep = Table[index]; ep != NULL; ep = ep->next)
      {
	if (match(&(ep->item), entry))
	  return (&(ep->item));
      }
      return (NULL);
    case REMOVE:
      for (ep = ep2 = Table[index]; ep != NULL; ep = ep->next)
      {
	if (match(&(ep->item), entry))
	{
	  if (ep != ep2)
	    ep2->next = ep->next;
	  else
	    Table[index] = ep->next;
	  ent = (ENTRY *) malloc(sizeof(ENTRY));
	  *ent = ep->item;
	  free(ep);
	  return (ent);
	}
	ep2 = ep;
      }
      return (NULL);
    default:
      fprintf(stderr, "Hsearch: Invalid action\n");
      return NULL;
    }
}

/* hashvalue --- do the hashing algorithm */

/*
 * algorithm is sum of string elements, plus string length mod table size.
 */

static
int
hashvalue(Num_elem, text, bytes)
  register int    Num_elem;
  register unsigned char *text;
  register int    bytes;
{
  register long unsigned int sum = 0;
  register int    i;

  for (i = 0; i < bytes; i++, text++)
    sum += *text;
  sum += i;

  return (sum % Num_elem);
}
