#ifndef lint
static char     sccsid[] = "@(#)startup.c";
static char     Creator[] = "C 1991 G. Sxoinas csi.forth.gr \n";
static char     Mail[] = "sxoinas@ariadne.bitnet or sxoinas@csi.forth.gr";
#endif
/*
 * This file is part of the POSYBL (PrOgramming SYstem for distriButed
 * appLications, a free Linda implementation for Unix Networks) and contains
 * the a utility program with which you can start remote processes, such as the
 * Tmanager to all the nodes specified by Tuple Managers.
 * 
 * There are no restrictions on this code; however, if you make any changes, I
 * request that you document them so that I do not get credit or blame for your
 * modifications.
 * 
 * Written by Ioannis Schoinas (sxoinas@csd.uch.gr or sxoinas@csi.forth.gr),
 * Computer Science Department, University of Crete, Heraclion, Crete, Greece.
 * 
 * Note: Linda is a trademark of SCA, Inc.
 * 
 */
#include <stdio.h>
#include <sys/file.h>

#include "linda_defs.h"

void
Usage(progname)
  char           *progname;
{
  fprintf(stderr, "Usage: %s [-f <nodefile>] <program> <argv[1]>...\n", progname);
  exit(1);
}

main(argc, argv)
  int             argc;
  char          **argv;
{
  register int    i, j, start;
  char           *command[64];
  NODEINFO        NodesInfoBuffer[32];
  int             NodesNumber;

  if (argc < 2)
    Usage(argv[0]);
  if (strcmp(argv[1], "-f") == 0)
  {
    if (argc < 4)
      Usage(argv[0]);
    LoadNodes(argv[2], NodesInfoBuffer, &NodesNumber);
    start = 3;
  }
  else
  {
    LoadNodes(NULL, NodesInfoBuffer, &NodesNumber);
    start = 1;
  }
  command[1] = "-n";
  for (i = 0; i < NodesNumber; i++)
  {
    command[0] = NodesInfoBuffer[i].name;
    for (j = start; j < argc; j++)
      command[j - start + 2] = (char *) FixName(command[0], argv[j],
						NodesInfoBuffer, NodesNumber);
    command[j - start + 2] = NULL;
    printf("Sending to %s\n", command[0]);
    if (vfork() == 0)
      execvp("rsh", command);
    else
      for (j = start; j < argc; j++)
	free(command[j - start + 2]);
  }
}
