/*
 *
 *	File: fastloop.cl
 *
 *	This is a C-Linda performance measurement program.  It iter-
 * atively outs and ins a tuple.  The loop count is passed as an ar-
 * gument to the program. The total loop execution time is displaye-
 * d at the end.
 */

/*
 * Initially found in a distribution of C-Linda Simulator for Sun-4, by SCA,
 * Inc.
 *
 * Modified for POSYBL by Giannis Schoinas.
 */

void
Usage(prog)
 char           *prog;
{
 printf("Usage: %s [-r rungroup] [-f nodefile] <loops>\n", prog);
 exit(1);
}

main(argc, argv)
 int             argc;
 char          **argv;
{
 register long   total_loops, RunGroup = 0;
 register char  *nodefile = (char *)0, c;
 extern int      optind;
 extern char    *optarg;

 if (argc != 2 && argc != 4 && argc != 6)
 {
  Usage(argv[0]);
 }

 while ((c = getopt(argc, argv, "r:f:")) != -1)
 {
  switch (c)
  {
  case 'r':
   RunGroup = atoi(optarg);
   break;
  case 'f':
   nodefile = optarg;
   break;
  case '?':
   Usage(argv[0]);
   break;
  }
 }

 init(RunGroup, nodefile);
 total_loops = atoi(argv[argc - 1]);

 printf("fastloop -- loops: %ld\n", total_loops);

 start_timer();

 while (total_loops--)
 {
  out(lstring("foo"));
  in(lstring("foo"));
 }

 timer_split("done.");
 print_times();
}
