.TH SYSTEM 1L "1 March 1991"
.SH NAME
system \- Issue 'system' commands to the Tuple Managers
.SH SYNOPSIS
.B system
[
.B \-n
.I netfile
]
[
.B \-r 
.I rungroup
]
.I subcommand
.SH DESCRIPTION
.B system
is used to issue a 'system' 
.I subcommand
, to the Tuple Managers.
The 
.I subcommand 
argument can be one of 
.TP
.B stats
Get tuple space statistics from the Tuple Managers.
.TP
.B reset
Destroy the Tuple Space, that corresponds to the rungroup
of the user that issued the command. Tuple Space statistics 
are returned.
.TP
.B exit
Orders the Tuple Managers to exit. It works only when the uid
of the caller is the same as the uid under which the Tuple
Manager runs.
.PP
The 
.I netfile
is a file that contains in each line the name of the network and
the address of that network in the format xx.xx.xx.xx.
An entry can be commented out if you precede the network's
name with a !.
.SH OPTIONS
.TP
.BI \-n " netfile" 
The networks list is located in the file named 
.I netfile
.
.TP
.BI \-r " rungroup"
Specifies the 
.I rungroup
of the POSYBL program that we are interested in.
.SH EXAMPLES
.IP
example% system -n mynets -r 111 reset 
.SH FILES
 ~/.netfile,
 ./.netfile
.SH SEE ALSO
.BR NodeFile(1L),
.BR startup(1L),
.BR tmanager(1L),
.BR posybl(1L),
.SH BUGS (Some call them features)
The network file should contain the addresses of the networks
on which the issue command should be issued. But since we cannot
broadcast from a node of one network to another network what should
contain is the adresses of all the nodes on which we want to execute
the command.
.SH AUTHOR
Ioannis Schoinas, sxoinas@csd.uch.gr
.SH ACKNOWLEDGEMENTS
I would like to thank everybody that helped me in writing this program
and especially I. Kavaklis for offering his ideas, some pieces of code,
demo programs, and for being the first subject to test this system.
