/*
 * This file is part of the POSYBL (PrOgramming SYstem for distriButed
 * appLications, a free Linda implementation for Unix Networks) and contains
 * the various definitions used by the hash routines and the Tuple Managers.
 * 
 * There are no restrictions on this code; however, if you make any changes, I
 * request that you document them so that I do not get credit or blame for your
 * modifications.
 * 
 * Written by Ioannis Schoinas (sxoinas@csd.uch.gr or sxoinas@csi.forth.gr),
 * Computer Science Department, University of Crete, Heraclion, Crete, Greece.
 * 
 * Note: Linda is a trademark of SCA, Inc.
 * 
 */

typedef struct
{
  int             pid;
  int             uid, rungroup;
  struct in_addr  node;
  Tmanager_Proc   proc;
  struct table_object *table;
  Rpc_Event       event;
  Rpc_Message     msg;
}               EXTENSION;	/* Extension struct for templates */

typedef struct
{
  char           *buffer;
  int             keybytes;
  int             databytes;
  EXTENSION      *rest;
}               ENTRY;

typedef enum
{
  FIND,
  ENTER,
  REMOVE
}               ACTION;

typedef struct element
{
  ENTRY           item;
  struct element *next;
}               ELEMENT;

typedef struct table_object
{
  ELEMENT       **Table;
  int             Size;
}               TABLE_OBJECT;

extern void     my_hdestroy();
extern TABLE_OBJECT *my_hcreate();
extern ENTRY   *my_hsearch();
