%{
#include "c.h"
#define NODEPTR_TYPE Node
#define OP_LABEL(p) ((p)->op)
#define LEFT_CHILD(p) ((p)->kids[0])
#define RIGHT_CHILD(p) ((p)->kids[1])
#define STATE_LABEL(p) ((p)->x.state)
static void address     ARGS((Symbol, Symbol, int));
static void blkfetch    ARGS((int, int, int, int));
static void blkloop     ARGS((int, int, int, int, int, int[]));
static void blkstore    ARGS((int, int, int, int));
static void defaddress  ARGS((Symbol));
static void defconst    ARGS((int, Value));
static void defstring   ARGS((int, char *));
static void defsymbol   ARGS((Symbol));
static void doarg       ARGS((Node));
static void emit2       ARGS((Node));
static void export      ARGS((Symbol));
static void clobber     ARGS((Node));
static void function    ARGS((Symbol, Symbol [], Symbol [], int));
static void global      ARGS((Symbol));
static void import      ARGS((Symbol));
static void local       ARGS((Symbol));
static void progbeg     ARGS((int, char **));
static void progend     ARGS((void));
static void segment     ARGS((int));
static void space       ARGS((int));
static void target      ARGS((Node));
static int imm ARGS((Node));
static void rename ARGS((void));
static void defsymbol2 ARGS((Symbol));
static void global2 ARGS((Symbol));
static void segment2 ARGS((int));

static Symbol greg[32];
static Symbol *oreg = &greg[10], *ireg = &greg[26];
static Symbol freg[32], freg2[32];

static int retstruct;

static int cseg;

%}
%start stmt
%term ADDD=306 ADDF=305 ADDI=309 ADDP=311 ADDU=310
%term ADDRFP=279
%term ADDRGP=263
%term ADDRLP=295
%term ARGB=41 ARGD=34 ARGF=33 ARGI=37 ARGP=39
%term ASGNB=57 ASGNC=51 ASGND=50 ASGNF=49 ASGNI=53 ASGNP=55 ASGNS=52
%term BANDU=390
%term BCOMU=406
%term BORU=422
%term BXORU=438
%term CALLB=217 CALLD=210 CALLF=209 CALLI=213 CALLV=216
%term CNSTC=19 CNSTD=18 CNSTF=17 CNSTI=21 CNSTP=23 CNSTS=20 CNSTU=22
%term CVCI=85 CVCU=86
%term CVDF=97 CVDI=101
%term CVFD=114
%term CVIC=131 CVID=130 CVIS=132 CVIU=134
%term CVPU=150
%term CVSI=165 CVSU=166
%term CVUC=179 CVUI=181 CVUP=183 CVUS=180
%term DIVD=450 DIVF=449 DIVI=453 DIVU=454
%term EQD=482 EQF=481 EQI=485
%term GED=498 GEF=497 GEI=501 GEU=502
%term GTD=514 GTF=513 GTI=517 GTU=518
%term INDIRB=73 INDIRC=67 INDIRD=66 INDIRF=65 INDIRI=69 INDIRP=71 INDIRS=68
%term JUMPV=584
%term LABELV=600
%term LED=530 LEF=529 LEI=533 LEU=534
%term LOADB=233 LOADC=227 LOADD=226 LOADF=225 LOADI=229 LOADP=231 LOADS=228 LOADU=230
%term LSHI=341 LSHU=342
%term LTD=546 LTF=545 LTI=549 LTU=550
%term MODI=357 MODU=358
%term MULD=466 MULF=465 MULI=469 MULU=470
%term NED=562 NEF=561 NEI=565
%term NEGD=194 NEGF=193 NEGI=197
%term RETD=242 RETF=241 RETI=245
%term RSHI=373 RSHU=374
%term SUBD=322 SUBF=321 SUBI=325 SUBP=327 SUBU=326
%term VREGP=615
%%
reg:  INDIRC(VREGP)     "\t\t; read register\n"
reg:  INDIRD(VREGP)     "\t\t; read register\n"
reg:  INDIRF(VREGP)     "\t\t; read register\n"
reg:  INDIRI(VREGP)     "\t\t; read repgister\n"
reg:  INDIRP(VREGP)     "\t\t; read register\n"
reg:  INDIRS(VREGP)     "\t\t; read register\n"
stmt: ASGNC(VREGP,reg)  "\t\t; write register\n"
stmt: ASGND(VREGP,reg)  "\t\t; write register\n"
stmt: ASGNF(VREGP,reg)  "\t\t; write register\n"
stmt: ASGNI(VREGP,reg)  "\t\t; write register\n"
stmt: ASGNP(VREGP,reg)  "\t\t; write register\n"
stmt: ASGNS(VREGP,reg)  "\t\t; write register\n"
con: CNSTC  "%a"
con: CNSTI  "%a"
con: CNSTP  "%a"
con: CNSTS  "%a"
con: CNSTU  "%a"
stmt: reg  ""
reg: CVIU(reg)  "%0"  notarget(a)
reg: CVPU(reg)  "%0"  notarget(a)
reg: CVUI(reg)  "%0"  notarget(a)
reg: CVUP(reg)  "%0"  notarget(a)
reg: ADDRGP  "X00add r0, %a,%c\n"  1
stk: ADDRFP  "%a"                  1
stk: ADDRLP  "%a"                  1
reg:   stk   "add r30,%0,%c\n"  1
base: ADDI(reg,con)  "%0+%1"
base: ADDP(reg,con)  "%0+%1"
base: ADDU(reg,con)  "%0+%1"
base: reg    "%0"
base: con  "%0"
base: stk            "add r30,%0,%c\n" 1
addr: base           "%0"
addr: ADDI(reg,reg)   "add %0, %1, %c\n"
addr: ADDU(reg,reg)   "add %0, %1, %c\n"
addr: stk            "add r30,%0,%c\n" 1
addr: ADDP(reg, reg) "add %0, %1, %c\n"
reg:  INDIRC(addr)     "ldsb [%0],%c\n;ERR: no characters\n"  1
reg:  INDIRS(addr)     "ldsh [%0],%c\n;ERR: no shorts\n"  1
reg:  INDIRI(addr)     "ld %0,0,%c\n"    1
reg:  INDIRP(addr)     "ld %0,0,%c\n"    1
reg:  INDIRF(addr)     "ld [%0],f%c\n"   1
stmt: ASGNC(addr,reg)  "stb %1,[%0]\n;ERR: no characters\n"   1
stmt: ASGNS(addr,reg)  "sth %1,[%0]\n;ERR: no shorts\n"   1
stmt: ASGNI(addr,reg)  "st %1,0,%0\n"    1
stmt: ASGNP(addr,reg)  "st %1,0,%0\n"    1
stmt: ASGNF(addr,reg)  "st f%1,%0\n;ERR: no floats\n"   1
addrl: ADDRLP            "r30+%a"          imm(a)

reg:   INDIRD(addrl)     "ldd [%0],f%c\n;ERR: no floats\n"  1
stmt:  ASGND(addrl,reg)  "std f%1,[%0]\n;ERR: no floats\n"  1
spill:  ADDRLP          "%a" !imm(a)

stmt: ASGNC(spill,reg)  "add r0, %0,r1\nstb %1,[r30+r1]\n;ERR: no chars\n"
stmt: ASGNS(spill,reg)  "add r0, %0,r1\nsth %1,[r30+r1]\n;ERR: no shorts\n"
stmt: ASGNI(spill,reg)  "add r0, %0,r1\nadd r1, r30, r1\nst %1,0,r1\n"
stmt: ASGNP(spill,reg)  "add r0, %0,r1\nadd r1, r30, r1\nst %1,0,r1\n"
stmt: ASGNF(spill,reg)  "add r0, %0,r1\nst f%1,[r30+r1]\n;ERR: no floats\n"
stmt: ASGND(spill,reg)  "add r0, %0,r1\nstd f%1,[r30+r1]\n;ERR: no floats\n"
reg: CVCI(INDIRC(addr))  "ldsb [%0],%c\n;ERR:  no chars\n"  1
reg: CVSI(INDIRS(addr))  "ldsh [%0],%c\n;ERR:  no shorts\n"  1
reg: CVCU(INDIRC(addr))  "ldub [%0],%c\n;ERR:  no chars\n"  1
reg: CVSU(INDIRS(addr))  "lduh [%0],%c\n;ERR:  no shorts\n"  1
reg: CVIC(reg)  "add %0,0,%c\n;ERR: no chars\n"  move(a)
reg: CVIS(reg)  "add %0,0,%c\n;ERR: no shorts\n"  move(a)
reg: CVIU(reg)  "add %0,0,%c\n"  move(a)
reg: CVPU(reg)  "add %0,0,%c\n"  move(a)
reg: CVUC(reg)  "add %0,0,%c\n"  move(a)
reg: CVUI(reg)  "add %0,0,%c\n"  move(a)
reg: CVUP(reg)  "add %0,0,%c\n"  move(a)
reg: CVUS(reg)  "add %0,0,%c\n;ERR: no shorts\n"  move(a)
reg: CVIC(reg)  "%0"  notarget(a)
reg: CVIS(reg)  "%0"  notarget(a)
reg: CVUC(reg)  "%0"  notarget(a)
reg: CVUS(reg)  "%0"  notarget(a)
reg: LOADC(reg)  "add %0,0,%c\n;ERR: no chars\n"  move(a)
reg: LOADI(reg)  "add %0,0,%c\n"  move(a)
reg: LOADP(reg)  "add %0,0,%c\n"  move(a)
reg: LOADS(reg)  "add %0,0,%c\n;ERR: no shorts\n"  move(a)
reg: LOADU(reg)  "add %0,0,%c\n"  move(a)
reg: CNSTC  "\t\t; reg\n"  range(a, 0, 0)
reg: CNSTI  "\t\t; reg\n"  range(a, 0, 0)
reg: CNSTP  "\t\t; reg\n"  range(a, 0, 0)
reg: CNSTS  "\t\t; reg\n"  range(a, 0, 0)
reg: CNSTU  "\t\t; reg\n"  range(a, 0, 0)
reg: con  "add r0, %0,%c\n"  1
rc: con  "%0"
rc: reg    "%0"
reg: ADDI(reg,rc)   "add %0,%1,%c\n"  1
reg: ADDP(reg,rc)   "add %0,%1,%c\n"  1
reg: ADDU(reg,rc)   "add %0,%1,%c\n"  1
reg: BANDU(reg,rc)  "and %0,%1,%c\n"  1
reg: BORU(reg,rc)   "or %0,%1,%c\n"   1
reg: BXORU(reg,rc)  "xor %0,%1,%c\n"  1
reg: SUBI(reg,rc)   "sub %0,%1,%c\n"  1
reg: SUBP(reg,rc)   "sub %0,%1,%c\n"  1
reg: SUBU(reg,rc)   "sub %0,%1,%c\n"  1
rc5: CNSTI  "%a"    range(a, 0, 31)
rc5: reg    "%0"
reg: LSHI(reg,rc5)  "sll %0,%1,%c\n"  1
reg: LSHU(reg,rc5)  "sll %0,%1,%c\n"  1
reg: RSHI(reg,rc5)  "sra %0,%1,%c\n"  1
reg: RSHU(reg,rc5)  "srl %0,%1,%c\n"  1
reg: BANDU(reg,BCOMU(rc))  "andn %%%0,%1,%%%c\n"  1
reg: BORU(reg,BCOMU(rc))   "orn %%%0,%1,%%%c\n"   1
reg: BXORU(reg,BCOMU(rc))  "xorn %%%0,%1,%%%c\n"  1
reg: NEGI(reg)   "sub r0,%0,%c\n"  1
reg: BCOMU(reg)  "bcomp %0,0,%c\n"  1
reg: CVCI(reg)  "sll %0,24,%c\nsra %c,24,%c\n;ERR: characters\n"  2
reg: CVSI(reg)  "sll %0,16,%c\nsra %c,16,%c\n;ERR: shorts\n"  2
reg: CVCU(reg)  "and %0,0xff,%c\n;ERR: characters\n"                   1
reg: CVSU(reg)  "add r0, 0xffff,r1\nand %0,r1,%c\n;ERR: shorts\n"  2
addrg: ADDRGP        "%a"
stmt:  JUMPV(addrg)  "jmp none, %0\n"   2
stmt:  JUMPV(addr)   "jmp none, %0\n"  2
stmt:  LABELV        "%a:\n"
stmt: EQI(reg,rc)  "sub %0,%1,r0\njmp eq, %a\n"    2
stmt: GEI(reg,rc)  "sub %0,%1,r0\njmp ge %a\n"   2
stmt: GEU(reg,rc)  "sub %0,%1,r0\njmp ge %a\n"  2
stmt: GTI(reg,rc)  "sub %0,%1,r0\njmp gt %a\n"    2
stmt: GTU(reg,rc)  "sub %0,%1,r0\njmp gt %a\n"   2
stmt: LEI(reg,rc)  "sub %0,%1,r0\njmp le %a\n"   2
stmt: LEU(reg,rc)  "sub %0,%1,r0\njmp le %a\n"  2
stmt: LTI(reg,rc)  "sub %0,%1,r0\njmp lt %a\n"    2
stmt: LTU(reg,rc)  "sub %0,%1,r0\njmp lt %a\n"   2
stmt: NEI(reg,rc)  "sub %0,%1,r0\njmp ne %a\n"   2
call: ADDRGP           "%a"
call: addr             "%0"
reg:  CALLD(call)      "call r15, %0\n"                1
reg:  CALLF(call)      "call r15, %0\n"                1
reg:  CALLI(call)      "call r15, %0\n"                1
stmt: CALLV(call)      "call r15, %0\n"                1
stmt: CALLB(call,reg)  "st %1,[r14+16]\ncall r15, %0\n"  2
stmt: RETD(reg)  "ret r31\n"  1
stmt: RETF(reg)  "ret r31\n"  1
stmt: RETI(reg)  "ret r31\n"  1
stmt: ARGI(reg)  "mul %c,4,r1\nadd r14, r1, r1\nst %0,17,r1\n"  3
stmt: ARGP(reg)  "mul %c,4,r1\nadd r14, r1, r1\nst %0,17,r1\n"  3
stmt: ARGD(reg)  "# ARGD\n"  1
stmt: ARGF(reg)  "# ARGF\n"  1

reg: DIVI(reg,reg)  "div  %0,%1,%c\n"  1
reg: DIVU(reg,reg)  "div %0,%1,%c\n"  1
reg: MODI(reg,reg)  "mod  %0,%1,%c\n"  1
reg: MODU(reg,reg)  "mod  %0,%1,%c\n"  1
reg: MULI(reg,reg)  "mul  %0,%1,%c\n"  1
reg: MULU(reg,reg)  "mul  %0,%1,%c\n"  1

reg: ADDD(reg,reg)  "fadd f%0,f%1,f%c\n"  1
reg: ADDF(reg,reg)  "fadd f%0,f%1,f%c\n"  1
reg: DIVD(reg,reg)  "fdiv f%0,f%1,f%c\n"  1
reg: DIVF(reg,reg)  "fdiv f%0,f%1,f%c\n"  1
reg: MULD(reg,reg)  "fmul f%0,f%1,f%c\n"  1
reg: MULF(reg,reg)  "fmul f%0,f%1,f%c\n"  1
reg: SUBD(reg,reg)  "fsub f%0,f%1,f%c\n"  1
reg: SUBF(reg,reg)  "fsub f%0,f%1,f%c\n"  1
reg: NEGF(reg)   "fsub f0,f%0,f%c\n"  1
reg: LOADF(reg)  "fadd f%0,0,f%c\n"  move(a) 

reg: CVDF(reg)   "fadd f%0,0,f%c\n;ERR: no floats\n"  move(a)
reg: CVFD(reg)   "fadd f%0,0,f%c\n;ERR: no floats\n"  move(a)
reg: CVDI(reg)   "cftoi f%0,%c\n;ERR: no floats\n"  1
reg: CVID(reg)   "citof %0,f%c\n;ERR: no floats\n"  1

rel: EQD(reg,reg)  "fsub f%0,f%1,f0\njmp eq,"
rel: EQF(reg,reg)  "fsub f%0,f%1,f0\njmp eq,"
rel: GED(reg,reg)  "fsub f%0,f%1,f0\njmp ge,"
rel: GEF(reg,reg)  "fsub f%0,f%1,f0\njmp ge,"
rel: GTD(reg,reg)  "fsub f%0,f%1,f0\njmp gt,"
rel: GTF(reg,reg)  "fsub f%0,f%1,f0\njmp gt,"
rel: LED(reg,reg)  "fsub f%0,f%1,f0\njmp le,"
rel: LEF(reg,reg)  "fsub f%0,f%1,f0\njmp le,"
rel: LTD(reg,reg)  "fsub f%0,f%1,f0\njmp lt,"
rel: LTF(reg,reg)  "fsub f%0,f%1,f0\njmp lt,"
rel: NED(reg,reg)  "fsub f%0,f%1,f0\njmp ne,"
rel: NEF(reg,reg)  "fsub f%0,f%1,f0\njmp ne,"

stmt: rel  "%0 %a\n"  3
reg:  LOADD(reg)  "# LOADD\n"  2

reg:  NEGD(reg)  "# NEGD\n"  2

stmt:  ASGNB(reg,INDIRB(reg))  "# ASGNB\n"

%%

#define MULSIM 1

static void progend(){}
static void progbeg(argc, argv) int argc; char *argv[]; {
	int i;

	{
		union {
			char c;
			int i;
		} u;
		u.i = 0;
		u.c = 1;
		swap = (u.i == 1) != IR->little_endian;
	}
	parseflags(argc, argv);
				/* change to make all reg names be rXX .kdr*/
	for (i = 0; i < 32; i++) {
		greg[i] = mkreg(stringf("r%d", i), i, 1, IREG);
	}
	for (i = 0; i < 32; i++)
		freg[i]  = mkreg("%d", i, 1, FREG);
	for (i = 0; i < 31; i += 2)
		freg2[i] = mkreg("%d", i, 3, FREG);
	rmap[C] = rmap[S] = rmap[P] = rmap[B] = rmap[U] = rmap[I] =
		mkwildcard(greg);
	rmap[F] = mkwildcard(freg);
	rmap[D] = mkwildcard(freg2);
#if MULSIM
				/* mulsim register mappings
				   globals are 0-9 (10 regs)
				   outs are 10-15 (6 regs)
				   locals are 16-25 (10 regs)
				   ins are 26-31 (6 regs)	   .kdr*/
			/* register reservations:
			   g0-g9 : 0-9 : not preserved across calls
			/  o0    : 10   : return value will be here
	destroyed by  -|   o4    : 14  : stack pointer
	child		\  o5    : 15  : return address for child
			   i0    : 26  : place return value here
			   i4    : 30  : frame pointer
			   i5    : 31  : address to return to      .kdr*/

			/* if    il          l os    og          g .kdr*/
			/* 5p    09          0 5p    09          0 .kdr*/
			/* 0011 1111 1111 1111 0011 1000 0000 0000 .kdr*/
			/*  3           2            1           0 .kdr*/
			/* 1098 7654 3210 9876 5432 1098 7654 3210 .kdr*/
	tmask[IREG] = 0x3fff3800;
			/* if    il          l os    og          g .kdr*/
			/* 5p    09          0 5p    09          0 .kdr*/
			/* 0011 1111 1111 0000 0000 0000 0000 0000 .kdr*/
			/*  3           2            1           0 .kdr*/
			/* 1098 7654 3210 9876 5432 1098 7654 3210 .kdr*/
	vmask[IREG] = 0x3ff00000;
#else
				/* sparc register mappings
				   globals are 0-7 (8 regs)
				   outs are 8-15 (8 regs)
				   locals are 16-23 (8 regs)
				   ins are 24-31 (8 regs)	   .kdr*/
			/* register reservations:
  			   g0-g7 : 0-8 : not preserved across calls
			/  o0    : 9   : return value will be here
         destroyed by -|   o6    : 14  : stack pointer
	        child   \  o7    : 15  : return address for child
			   i0    : 24  : place return value here
			   i6    : 30  : frame pointer
			   i7    : 31  : address to return to      .kdr*/

			/* if   i  i l  l l  l os o o  o g  g g  g .kdr*/
			/* 7p   3  0 7  4 3  0 7p 4 3  0 7  4 3  0 .kdr*/
			/* 0011 1111 1111 1111 0011 1110 0000 0000 .kdr*/
			/*  3           2            1           0 .kdr*/
			/* 1098 7654 3210 9876 5432 1098 7654 3210 .kdr*/
	tmask[IREG] = 0x3fff3e00;
			/* if   i  i l  l l  l os o o  o g  g g  g .kdr*/
			/* 7p   3  0 7  4 3  0 7p 4 3  0 7  4 3  0 .kdr*/
			/* 0011 1111 1111 0000 0000 0000 0000 0000 .kdr*/
			/*  3           2            1           0 .kdr*/
			/* 1098 7654 3210 9876 5432 1098 7654 3210 .kdr*/
	vmask[IREG] = 0x3ff00000;
#endif
	tmask[FREG]  = ~(unsigned)0;
	vmask[FREG]  = 0;
}
static void target(p) Node p; {
	assert(p);
	switch (p->op) {
	case CNSTC: case CNSTI: case CNSTS: case CNSTU: case CNSTP:
		if (range(p, 0, 0) == 0) {
			setreg(p, greg[0]);
			p->x.registered = 1;
		}
		break;
	case CALLD: setreg(p, freg2[0]);     break;
	case CALLF: setreg(p, freg[0]);      break;
	case CALLI:
	case CALLV: setreg(p, oreg[0]);      break;
	case RETD:  rtarget(p, 0, freg2[0]); break;
	case RETF:  rtarget(p, 0, freg[0]);  break;
	case RETI:
		rtarget(p, 0, ireg[0]);
		p->kids[0]->x.registered = 1;
		break;
	case ARGI: case ARGP:
		if (p->syms[RX]->u.c.v.i < 6) {
			rtarget(p, 0, oreg[p->syms[RX]->u.c.v.i]);
			p->op = LOAD+optype(p->op);
			setreg(p, oreg[p->syms[RX]->u.c.v.i]);
		}
		break;
        case DIVI: case MODI: case MULI:
        case DIVU: case MODU: case MULU:
                break;
	}
}
static void clobber(p) Node p; {
	assert(p);
	switch (p->op) {
	case CALLB: case CALLD: case CALLF: case CALLI:
		spill(~(unsigned)3, FREG, p);
		break;
	case CALLV:
		spill(oreg[0]->x.regnode->mask, IREG, p);
		spill(~(unsigned)3, FREG, p);
		break;
	case ARGF:
		if (p->syms[2]->u.c.v.i <= 6)
			spill((1<<(p->syms[2]->u.c.v.i + 8)), IREG, p);
		break;
	case ARGD:
		if (p->syms[2]->u.c.v.i <= 5)
			spill((3<<(p->syms[2]->u.c.v.i + 8))&0xff00, IREG, p);
		break;
        case DIVI: case MODI: case MULI:
        case DIVU: case MODU: case MULU:
                break;
	}
}
static int imm(p) Node p; {
   return 0;
}
static void doarg(p) Node p; {
	assert(p && p->syms[0] && p->op != ARG+B);
	p->syms[RX] = intconst(mkactual(4,
		p->syms[0]->u.c.v.i)/4);
}
static void emit2(p) Node p; {
   switch (p->op) {
    case ARGF: {
       int n = p->syms[RX]->u.c.v.i;
       print("st f%d,[r14+4*%d+68]\n;ERR: no floats\n",
	     getregnum(p->x.kids[0]), n);
       if (n <= 5) {
			   /* the 23 adjusts for using r instead of o .kdr*/
#if 0
	  print("ld [r14+4*%d+68],r%d\n", n, n+23);
#endif
	  print("add r0, %d, r1\nmul r1, 4, r1\nadd r1, r14, r1\nld r1, 68,r%d\n", n, n+23);
       }
       break;
    }
    case ARGD: {
       int n = p->syms[RX]->u.c.v.i;
       int src = getregnum(p->x.kids[0]);
       print("st f%d,[r14+4*%d+68]\n;ERR: no floats/doubles\n", src, n);
       print("st f%d,[r14+4*%d+68]\n", src+1, n+1);
       if (n <= 5)
	 print("ld [r14+4*%d+68],o%d\n", n, n);
       if (n <= 4)
	 print("ld [r14+4*%d+68],o%d\n", n+1, n+1);
       break;
    }
    case LOADD: {
       /* 	   fprintf(stderr,"NO FLOATS\n"); */
       int dst = getregnum(p);
       int src = getregnum(p->x.kids[0]);
       print(";ERR: no floats\n");
       print("fadd f%d,0,f%d; ", src,   dst);
       print("fadd f%d,0,f%d\n", src+1, dst+1);
       break;
    }
    case NEGD: {
       /*	   fprintf(stderr,"NO FLOATS\n");*/
       int dst = getregnum(p);
       int src = getregnum(p->x.kids[0]);
       print("ERR: no floats\n");
       print("fnegs f%d,f%d; ", src,   dst);
       print("fadd f%d,0,f%d\n", src+1, dst+1);
       break;
    }
    case ASGNB: {
       /*	   fprintf(stderr,"NO STRUCTS\n"); */
       static int tmpregs[] = { 1, 2, 3 };
       print("ERR: no structs\n");
       dalign = salign = p->syms[1]->u.c.v.i;
       blkcopy(getregnum(p->x.kids[0]), 0,
	       getregnum(p->x.kids[1]), 0,
	       p->syms[0]->u.c.v.i, tmpregs);
       break;
    }
   }
}
static void local(p) Symbol p; {
	if (retstruct) {
				/* no prob. no struct support .kdr*/
		p->x.name = stringd(4*16);
		p->x.offset = 4*16;
		retstruct = 0;
		return;
	}
	if (isscalar(p->type) && !p->addressed && !isfloat(p->type))
		p->sclass = REGISTER;
	if (glevel && glevel != 3) p->sclass = AUTO;	/* glevel!=3 is for Norman's debugger */
	if (askregvar(p, rmap[ttob(p->type)]) == 0)
		mkauto(p);
}
static void function(f, caller, callee, ncalls)
     Symbol f, callee[], caller[]; int ncalls; 
{
   int  autos = 0, i, reg, varargs;

   for (i = 0; callee[i]; i++)
     ;
   varargs = variadic(f->type)
     || i > 0 && strcmp(callee[i-1]->name,
			"__builtin_va_alist") == 0;
   usedmask[0] = usedmask[1] = 0;
   freemask[0] = freemask[1] = ~(unsigned)0;
   for (i = 0; i < 8; i++)
     ireg[i]->x.regnode->vbl = NULL;
   offset = 17;
				/* maybe this should be 4 w/norms window
				   partitioning? yeah, sure, it was 6 .kdr*/
   maxargoffset = 4;
   reg = 0;
   for (i = 0; callee[i]; i++) {
      Symbol p = callee[i], q = caller[i];
				/* changed n to 1 == size of 'word' .kdr*/
      int size = roundup(q->type->size, 1);
      assert(q);
      if (isfloat(p->type) || reg >= 6) {
	 p->x.offset = q->x.offset = offset;
	 p->x.name = q->x.name = stringd(offset);
	 p->sclass = q->sclass = AUTO;
	 autos++;
      }
      else if (p->addressed || varargs)
	{
	   p->x.offset = offset;
	   p->x.name = stringd(p->x.offset);
	   p->sclass = AUTO;
	   q->sclass = REGISTER;
	   askregvar(q, ireg[reg]);
	   assert(q->x.regnode);
	   autos++;
	}
      else if (glevel && glevel != 3) {
	 p->x.offset = offset;
	 p->x.name = stringd(p->x.offset);
	 p->sclass = AUTO;
	 q->sclass = REGISTER;
	 askregvar(q, ireg[reg]);
	 assert(q->x.regnode);
	 autos++;
      }
      else {
	 p->sclass = q->sclass = REGISTER;
	 askregvar(p, ireg[reg]);
	 assert(p->x.regnode);
	 q->x.name = p->x.name;
      }
      offset += size;
      reg += isstruct(p->type) ? 1 : size;
   }
   assert(caller[i] == 0);
   offset = maxoffset = 0;
   retstruct = isstruct(freturn(f->type));
				/* not allowed to return structs .kdr*/
   assert(retstruct == 0);
   gencode(caller, callee);
				/* lost the 4 cause words are 1 .kdr*/
   framesize = maxoffset + maxargoffset + (16+1);
   assert(!varargs || autos);
				/* ommitted all the leaf function 
				   optimizations .kdr*/
				/* change boiler plate for functions .kdr*/
   print("%s:\n", f->x.name);
				/* init the stack pointer register if the 
				   funciton is main, else do the save .kdr*/
   if (! strcmp(f->name,"main")) {
     print("; a little boilerplate\n");
     print("add r0, &_stackp, r30\n");
     print("add r30, %d, r14\n", -framesize);
     print("; end o'bolierplate\n");
  }
   else {
     print("; save reads its src ops from previous window so\n");
     print(";      this instruction is equivalent to 'add r30, x, r14\n");
     print("save r14,%d,r14\n", -framesize);
  }
				/* varargs are not allowed .kdr*/
   assert( !varargs);
   offset = 4*(16 + 1);
   reg = 0;
   for (i = 0; caller[i]; i++) {
      Symbol p = caller[i];
      if (isdouble(p->type) && reg <= 4) {
	 print("st r%d,[r30+%d]\n",
	       ireg[reg++]->x.regnode->number, offset);
	 print("st r%d,[r30+%d]\n",
	       ireg[reg++]->x.regnode->number, offset + 4);
      } else if (isfloat(p->type) && reg <= 5)
	print("st r%d,[r30+%d]\n",
	      ireg[reg++]->x.regnode->number, offset);
      else
	reg++;
      offset += roundup(p->type->size, 4);
   }
   emitcode();
				/* need to have a halt instruction at the
				   end of main  .kdr*/
   if (! strcmp(f->name,"main"))	print("halt\n");
   else {
      print("ret r31\n",framesize);
   }
   print(";end_function_%s\n;\n;\n",f->name);

/*   print ("halt\n.end\n"); */
}
#define exch(x, y, t) (((t) = x), ((x) = (y)), ((y) = (t)))

static void rename() {
	int i;

	for (i = 0; i < 8; i++) {
		char *ptmp;
		int itmp;
		if (ireg[i]->x.regnode->vbl)
			ireg[i]->x.regnode->vbl->x.name = oreg[i]->x.name;
		exch(ireg[i]->x.name, oreg[i]->x.name, ptmp);
		exch(ireg[i]->x.regnode->number,
			oreg[i]->x.regnode->number, itmp);
	}
}
static void defconst(ty, v) int ty; Value v; {
	switch (ty) {
	case C: print(".byte %d\n",   v.uc); return;
	case S: print(".half %d\n",   v.ss); return;
	case I: print("%d\n",   v.i ); return;
	case U: print("%d\n",   v.i ); return;
	case P: print(".word 0x%x\n", v.p ); return;
	case F:
		print("0x%x\n", *(unsigned *)&v.f);
		return;
case D: {
	unsigned *p = (unsigned *)&v.d;
	print(".word 0x%x\n.word 0x%x\n", p[swap], p[!swap]);
	return;
	}
	}
	assert(0);
}

static void defaddress(p) Symbol p; {
	print("%s\n", p->x.name);
}

static void defstring(n, str) int n; char *str; {
	char *s;

	for (s = str; s < str + n; s++)
		print(".ERR characters not supported %d\n", (*s)&0377);
}

static void address(q, p, n) Symbol q, p; int n; {
	q->x.offset = p->x.offset + n;
	if (p->scope == GLOBAL || p->sclass == STATIC || p->sclass == EXTERN)
#if 1
				/* the string NEED_ADD will be taken out
				   bye the post-rcc/pre-mas perl scripts .kdr*/
	  q->x.name = stringf("%s__NEED_ADD__%d", p->x.name, n);
#else
				/* this produces the '&_SYM+off' .kdr*/
	  q->x.name = stringf("%s%s%d", p->x.name, n >= 0 ? "+" : "", n);
#endif
	else
		q->x.name = stringd(q->x.offset);
}
static void export(p) Symbol p; {
				/* Mas probably doesn't support sep comp .kdr*/
#if SEP_COMP_SUPPORTED
	print(".global %s\n", p->x.name);
#endif
}
static void import(p) Symbol p; {}

static void defsymbol(p) Symbol p; 
{
   if (p->scope >= LOCAL && p->sclass == STATIC)
     p->x.name = stringf("%d", genlabel(1));
   else
     assert(p->scope != CONSTANTS || isint(p->type) || isptr(p->type)),
     p->x.name = p->name;
   if (p->scope >= LABELS)
				/* generate symbolic labels  .kdr*/
     p->x.name = stringf(p->generated ? "L%s" : "&_%s", p->x.name);
}
static void segment(n) int n; {
	cseg = n;
	switch (n) {
	case CODE: print(".text\n"); break;
	case BSS:  print(".data\n");  break;
	case DATA: print(".data\n"); break;
	case LIT:  print(".text\n"); break;
	}
}
static void space(n) int n; {
	if (cseg != BSS)
		print(".skip %d\n", n);
}
static void global(p) Symbol p; {
	assert(p->u.seg);
	if (p->u.seg == BSS
				/* global symbols are printed here .kdr*/
	&& (p->sclass == STATIC || Aflag >= 2))
		print("%s %d\n", p->x.name, p->type->size);
	else if (p->u.seg == BSS)
		print("%s %d\n",  p->x.name, p->type->size);
	else
		print("%s:\n", p->x.name);
}
static void blkfetch(k, off, reg, tmp)
int k, off, reg, tmp; {
	assert(k == 1 || k == 2 || k == 4);
	assert(salign >= k);
	if (k == 1)
		print("ldub [r%d+%d],r%d\n", reg, off, tmp);
	else if (k == 2)
		print("lduh [r%d+%d],r%d\n", reg, off, tmp);
	else
		print("ld r%d, %d ,r%d\n",   reg, off, tmp);
}
static void blkstore(k, off, reg, tmp)
int k, off, reg, tmp; {
	assert(k == 1 || k == 2 || k == 4);
	assert(dalign >= k);
	if (k == 1)
		print("stb r%d,[r%d+%d]\n", tmp, reg, off);
	else if (k == 2)
		print("sth r%d,[r%d+%d]\n", tmp, reg, off);
	else
		print("st r%d,%d,r%d\n",  tmp, off, reg);
}
static void blkloop(dreg, doff, sreg, soff, size, tmps)
int dreg, doff, sreg, soff, size, tmps[]; {
	if ((size&~7) < 4096) {
		print("add r%d,%d,r%d\n", sreg, size&~7, sreg);
		print("add r%d,%d,r%d\n", dreg, size&~7, tmps[2]);
	} else {
		print("add r0, %d,r%d\n", size&~7, tmps[2]);
		print("add r%d,r%d,r%d\n", sreg, tmps[2], sreg);
		print("add r%d,r%d,r%d\n", dreg, tmps[2], tmps[2]);
	}
	blkcopy(tmps[2], doff, sreg, soff, size&7, tmps);
	print("1: dec 8,r%d\n", tmps[2]);
	blkcopy(tmps[2], doff, sreg, soff - 8, 8, tmps);
	print("sub r%d,r%d,r0\n", tmps[2], dreg);
	print("jmp gt, 1b\n");
	print("dec 8,r%d\n", sreg);
}
static void defsymbol2(p) Symbol p; {
	if (p->scope >= LOCAL && p->sclass == STATIC)
		p->x.name = stringf(".%d", genlabel(1));
	else
		assert(p->scope != CONSTANTS || isint(p->type) || isptr(p->type)),
		p->x.name = p->name;
	if (p->scope >= LABELS)
		p->x.name = stringf(p->generated ? ".L%s" : "%s",
			p->x.name);
}

static void global2(p) Symbol p; {
	assert(p->u.seg);
	if (p->sclass != STATIC && !p->generated)
		print(".type %s,#%s\n", p->x.name,
			isfunc(p->type) ? "function" : "object");
	if (p->u.seg == BSS && p->sclass == STATIC)
		print("%s\n%s,%d,%d\n", p->x.name, p->x.name,
			p->type->size, p->type->align);
	else if (p->u.seg == BSS && Aflag >= 2)
		print("%s:.skip %d\n", p->type->align, p->x.name,
			p->type->size);
	else if (p->u.seg == BSS)
		print("%s,%d,%d\n", p->x.name, p->type->size, p->type->align);
	else
		print("%s:\n", p->type->align, p->x.name);
}

static void segment2(n) int n; {
	cseg = n;
	switch (n) {
	case CODE: print(".text\n");   break;
	case BSS:  print(".data\n");    break;
	case DATA: print(".data\n");   break;
	case LIT:  print(".rodata\n"); break;
	}
}

				/* mulsim compiler only supports integers
				   and they are of size 1 .kdr*/
				/* for any typemetrics that I changed the
				   original values are given in the parens
				   in the comments .kdr*/
Interface mulsimlinuxIR = {
	1, 1, 0,  /* char */
	1, 1, 0,  /* (2,2,0) short */
	1, 1, 0,  /* (4,4,0) int */
	4, 4, 1,  /* float */
	8, 8, 1,  /* double */
	1, 1, 0,  /* (4,4,0) T *  ; it's a pointer */
	0, 1, 0,  /* struct */
	0,  /* little_endian */
	0,  /* mulops_calls */
	1,  /* wants_callb */
	0,  /* wants_argb */
	1,  /* left_to_right */
	0,  /* wants_dag */
	address,
	blockbeg,
	blockend,
	defaddress,
	defconst,
	defstring,
	defsymbol,
	emit,
	export,
	function,
	gen,
	global,
	import,
	local,
	progbeg,
	progend,
	segment,
	space,
	0, 0, 0, 0, 0, 0, 0,
	{
		1,  /* max_unaligned_load */
		blkfetch, blkstore, blkloop,
		_label,
		_rule,
		_nts,
		_kids,
		_opname,
		_arity,
		_string,
		_templates,
		_isinstruction,
		_ntname,
		emit2,
		doarg,
		target,
		clobber,

	}
};
