     1	%{
     2	#define INTTMP 0x0100ff00
     3	#define INTVAR 0x40ff0000
     4	#define FLTTMP 0x000f0ff0
     5	#define FLTVAR 0xfff00000
       
     6	#define INTRET 0x00000004
     7	#define FLTRET 0x00000003
       
     8	#define readsreg(p) \
     9		(generic((p)->op)==INDIR && (p)->kids[0]->op==VREG+P)
    10	#define setsrc(d) ((d) && (d)->x.regnode && \
    11		(d)->x.regnode->set == src->x.regnode->set && \
    12		(d)->x.regnode->mask&src->x.regnode->mask)
       
    13	#define relink(a, b) ((b)->x.prev = (a), (a)->x.next = (b))
       
    14	#include "c.h"
    15	#define NODEPTR_TYPE Node
    16	#define OP_LABEL(p) ((p)->op)
    17	#define LEFT_CHILD(p) ((p)->kids[0])
    18	#define RIGHT_CHILD(p) ((p)->kids[1])
    19	#define STATE_LABEL(p) ((p)->x.state)
    20	static void address     ARGS((Symbol, Symbol, int));
    21	static void blkfetch    ARGS((int, int, int, int));
    22	static void blkloop     ARGS((int, int, int, int, int, int[]));
    23	static void blkstore    ARGS((int, int, int, int));
    24	static void defaddress  ARGS((Symbol));
    25	static void defconst    ARGS((int, Value));
    26	static void defstring   ARGS((int, char *));
    27	static void defsymbol   ARGS((Symbol));
    28	static void doarg       ARGS((Node));
    29	static void emit2       ARGS((Node));
    30	static void export      ARGS((Symbol));
    31	static void clobber     ARGS((Node));
    32	static void function    ARGS((Symbol, Symbol [], Symbol [], int));
    33	static void global      ARGS((Symbol));
    34	static void import      ARGS((Symbol));
    35	static void local       ARGS((Symbol));
    36	static void progbeg     ARGS((int, char **));
    37	static void progend     ARGS((void));
    38	static void segment     ARGS((int));
    39	static void space       ARGS((int));
    40	static void target      ARGS((Node));
    41	extern int      atoi            ARGS((char *));
    42	static int      bitcount        ARGS((unsigned));
    43	static Symbol   argreg          ARGS((int, int, int, int));
       
    44	static Symbol ireg[32], freg2[32], d6;
    45	static int tmpregs[] = {3, 9, 10};
    46	static Symbol blkreg;
       
    47	static int gnum = 8;
    48	static int pic;
       
    49	static int cseg;
    50	%}
    51	%start stmt
    52	%term ADDD=306 ADDF=305 ADDI=309 ADDP=311 ADDU=310
    53	%term ADDRFP=279
    54	%term ADDRGP=263
    55	%term ADDRLP=295
    56	%term ARGB=41 ARGD=34 ARGF=33 ARGI=37 ARGP=39
    57	%term ASGNB=57 ASGNC=51 ASGND=50 ASGNF=49 ASGNI=53 ASGNP=55 ASGNS=52
    58	%term BANDU=390
    59	%term BCOMU=406
    60	%term BORU=422
    61	%term BXORU=438
    62	%term CALLB=217 CALLD=210 CALLF=209 CALLI=213 CALLV=216
    63	%term CNSTC=19 CNSTD=18 CNSTF=17 CNSTI=21 CNSTP=23 CNSTS=20 CNSTU=22
    64	%term CVCI=85 CVCU=86
    65	%term CVDF=97 CVDI=101
    66	%term CVFD=114
    67	%term CVIC=131 CVID=130 CVIS=132 CVIU=134
    68	%term CVPU=150
    69	%term CVSI=165 CVSU=166
    70	%term CVUC=179 CVUI=181 CVUP=183 CVUS=180
    71	%term DIVD=450 DIVF=449 DIVI=453 DIVU=454
    72	%term EQD=482 EQF=481 EQI=485
    73	%term GED=498 GEF=497 GEI=501 GEU=502
    74	%term GTD=514 GTF=513 GTI=517 GTU=518
    75	%term INDIRB=73 INDIRC=67 INDIRD=66 INDIRF=65 INDIRI=69 INDIRP=71 INDIRS=68
    76	%term JUMPV=584
    77	%term LABELV=600
    78	%term LED=530 LEF=529 LEI=533 LEU=534
    79	%term LOADB=233 LOADC=227 LOADD=226 LOADF=225 LOADI=229 LOADP=231 LOADS=228 LOADU=230
    80	%term LSHI=341 LSHU=342
    81	%term LTD=546 LTF=545 LTI=549 LTU=550
    82	%term MODI=357 MODU=358
    83	%term MULD=466 MULF=465 MULI=469 MULU=470
    84	%term NED=562 NEF=561 NEI=565
    85	%term NEGD=194 NEGF=193 NEGI=197
    86	%term RETD=242 RETF=241 RETI=245
    87	%term RSHI=373 RSHU=374
    88	%term SUBD=322 SUBF=321 SUBI=325 SUBP=327 SUBU=326
    89	%term VREGP=615
    90	%%
    91	reg:  INDIRC(VREGP)     "# read register\n"
    92	reg:  INDIRD(VREGP)     "# read register\n"
    93	reg:  INDIRF(VREGP)     "# read register\n"
    94	reg:  INDIRI(VREGP)     "# read register\n"
    95	reg:  INDIRP(VREGP)     "# read register\n"
    96	reg:  INDIRS(VREGP)     "# read register\n"
    97	stmt: ASGNC(VREGP,reg)  "# write register\n"
    98	stmt: ASGND(VREGP,reg)  "# write register\n"
    99	stmt: ASGNF(VREGP,reg)  "# write register\n"
   100	stmt: ASGNI(VREGP,reg)  "# write register\n"
   101	stmt: ASGNP(VREGP,reg)  "# write register\n"
   102	stmt: ASGNS(VREGP,reg)  "# write register\n"
   103	con: CNSTC  "%a"
   104	con: CNSTI  "%a"
   105	con: CNSTP  "%a"
   106	con: CNSTS  "%a"
   107	con: CNSTU  "%a"
   108	stmt: reg  ""
   109	reg: CVIU(reg)  "%0"  notarget(a)
   110	reg: CVPU(reg)  "%0"  notarget(a)
   111	reg: CVUI(reg)  "%0"  notarget(a)
   112	reg: CVUP(reg)  "%0"  notarget(a)
   113	acon: con     "%0"
   114	acon: ADDRGP  "%a"
   115	addr: ADDI(reg,acon)  "%1($%0)"
   116	addr: ADDU(reg,acon)  "%1($%0)"
   117	addr: ADDP(reg,acon)  "%1($%0)"
   118	addr: acon  "%0"
   119	addr: reg   "($%0)"
   120	addr: ADDRFP  "%a+%F($sp)"
   121	addr: ADDRLP  "%a+%F($sp)"
   122	reg: addr  "la $%c,%0\n"  1
   123	reg: CNSTC  "# reg\n"  range(a, 0, 0)
   124	reg: CNSTS  "# reg\n"  range(a, 0, 0)
   125	reg: CNSTI  "# reg\n"  range(a, 0, 0)
   126	reg: CNSTU  "# reg\n"  range(a, 0, 0)
   127	reg: CNSTP  "# reg\n"  range(a, 0, 0)
   128	stmt: ASGNC(addr,reg)  "sb $%1,%0\n"  1
   129	stmt: ASGNS(addr,reg)  "sh $%1,%0\n"  1
   130	stmt: ASGNI(addr,reg)  "sw $%1,%0\n"  1
   131	stmt: ASGNP(addr,reg)  "sw $%1,%0\n"  1
   132	reg:  INDIRC(addr)     "lb $%c,%0\n"  1
   133	reg:  INDIRS(addr)     "lh $%c,%0\n"  1
   134	reg:  INDIRI(addr)     "lw $%c,%0\n"  1
   135	reg:  INDIRP(addr)     "lw $%c,%0\n"  1
   136	reg: CVCI(INDIRC(addr))  "lb $%c,%0\n"  1
   137	reg: CVSI(INDIRS(addr))  "lh $%c,%0\n"  1
   138	reg: CVCU(INDIRC(addr))  "lbu $%c,%0\n" 1
   139	reg: CVSU(INDIRS(addr))  "lhu $%c,%0\n" 1
   140	reg:  INDIRD(addr)     "l.d $f%c,%0\n"  1
   141	reg:  INDIRF(addr)     "l.s $f%c,%0\n"  1
   142	stmt: ASGND(addr,reg)  "s.d $f%1,%0\n"  1
   143	stmt: ASGNF(addr,reg)  "s.s $f%1,%0\n"  1
   144	reg: DIVI(reg,reg)  "div $%c,$%0,$%1\n"   1
   145	reg: DIVU(reg,reg)  "divu $%c,$%0,$%1\n"  1
   146	reg: MODI(reg,reg)  "rem $%c,$%0,$%1\n"   1
   147	reg: MODU(reg,reg)  "remu $%c,$%0,$%1\n"  1
   148	reg: MULI(reg,reg)  "mul $%c,$%0,$%1\n"   1
   149	reg: MULU(reg,reg)  "mul $%c,$%0,$%1\n"   1
   150	rc:  con            "%0"
   151	rc:  reg            "$%0"
       
   152	reg: ADDI(reg,rc)   "addu $%c,$%0,%1\n"  1
   153	reg: ADDP(reg,rc)   "addu $%c,$%0,%1\n"  1
   154	reg: ADDU(reg,rc)   "addu $%c,$%0,%1\n"  1
   155	reg: BANDU(reg,rc)  "and $%c,$%0,%1\n"   1
   156	reg: BORU(reg,rc)   "or $%c,$%0,%1\n"    1
   157	reg: BXORU(reg,rc)  "xor $%c,$%0,%1\n"   1
   158	reg: SUBI(reg,rc)   "subu $%c,$%0,%1\n"  1
   159	reg: SUBP(reg,rc)   "subu $%c,$%0,%1\n"  1
   160	reg: SUBU(reg,rc)   "subu $%c,$%0,%1\n"  1
   161	rc5: CNSTI          "%a"                range(a,0,31)
   162	rc5: reg            "$%0"
       
   163	reg: LSHI(reg,rc5)  "sll $%c,$%0,%1\n"  1
   164	reg: LSHU(reg,rc5)  "sll $%c,$%0,%1\n"  1
   165	reg: RSHI(reg,rc5)  "sra $%c,$%0,%1\n"  1
   166	reg: RSHU(reg,rc5)  "srl $%c,$%0,%1\n"  1
   167	reg: BCOMU(reg)  "not $%c,$%0\n"   1
   168	reg: NEGI(reg)   "negu $%c,$%0\n"  1
   169	reg: LOADC(reg)  "move $%c,$%0\n"  move(a)
   170	reg: LOADS(reg)  "move $%c,$%0\n"  move(a)
   171	reg: LOADI(reg)  "move $%c,$%0\n"  move(a)
   172	reg: LOADP(reg)  "move $%c,$%0\n"  move(a)
   173	reg: LOADU(reg)  "move $%c,$%0\n"  move(a)
   174	reg: ADDD(reg,reg)  "add.d $f%c,$f%0,$f%1\n"  1
   175	reg: ADDF(reg,reg)  "add.s $f%c,$f%0,$f%1\n"  1
   176	reg: DIVD(reg,reg)  "div.d $f%c,$f%0,$f%1\n"  1
   177	reg: DIVF(reg,reg)  "div.s $f%c,$f%0,$f%1\n"  1
   178	reg: MULD(reg,reg)  "mul.d $f%c,$f%0,$f%1\n"  1
   179	reg: MULF(reg,reg)  "mul.s $f%c,$f%0,$f%1\n"  1
   180	reg: SUBD(reg,reg)  "sub.d $f%c,$f%0,$f%1\n"  1
   181	reg: SUBF(reg,reg)  "sub.s $f%c,$f%0,$f%1\n"  1
   182	reg: LOADD(reg)     "mov.d $f%c,$f%0\n"       move(a)
   183	reg: LOADF(reg)     "mov.s $f%c,$f%0\n"       move(a)
   184	reg: NEGD(reg)      "neg.d $f%c,$f%0\n"       1
   185	reg: NEGF(reg)      "neg.s $f%c,$f%0\n"       1
   186	reg: CVCI(reg)  "sll $%c,$%0,24; sra $%c,$%c,24\n"  2
   187	reg: CVSI(reg)  "sll $%c,$%0,16; sra $%c,$%c,16\n"  2
   188	reg: CVCU(reg)  "and $%c,$%0,0xff\n"                1
   189	reg: CVSU(reg)  "and $%c,$%0,0xffff\n"              1
   190	reg: CVIC(reg)  "%0"  notarget(a)
   191	reg: CVIS(reg)  "%0"  notarget(a)
   192	reg: CVUC(reg)  "%0"  notarget(a)
   193	reg: CVUS(reg)  "%0"  notarget(a)
   194	reg: CVIC(reg)  "move $%c,$%0\n"  move(a)
   195	reg: CVIS(reg)  "move $%c,$%0\n"  move(a)
   196	reg: CVIU(reg)  "move $%c,$%0\n"  move(a)
   197	reg: CVPU(reg)  "move $%c,$%0\n"  move(a)
   198	reg: CVUC(reg)  "move $%c,$%0\n"  move(a)
   199	reg: CVUI(reg)  "move $%c,$%0\n"  move(a)
   200	reg: CVUP(reg)  "move $%c,$%0\n"  move(a)
   201	reg: CVUS(reg)  "move $%c,$%0\n"  move(a)
   202	reg: CVDF(reg)  "cvt.s.d $f%c,$f%0\n"  1
   203	reg: CVFD(reg)  "cvt.d.s $f%c,$f%0\n"  1
   204	reg: CVID(reg)  "mtc1 $%0,$f%c; cvt.d.w $f%c,$f%c\n"  2
   205	reg: CVDI(reg)  "trunc.w.d $f2,$f%0,$%c; mfc1 $%c,$f2\n"  2
   206	stmt: LABELV  "%a:\n"
   207	stmt: JUMPV(acon)  "b %0\n"   1
   208	stmt: JUMPV(reg)   ".cpadd $%0\nj $%0\n"  !pic
   209	stmt: JUMPV(reg)   "j $%0\n"  pic
   210	stmt: EQI(reg,reg)  "beq $%0,$%1,%a\n"   1
   211	stmt: GEI(reg,reg)  "bge $%0,$%1,%a\n"   1
   212	stmt: GEU(reg,reg)  "bgeu $%0,$%1,%a\n"  1
   213	stmt: GTI(reg,reg)  "bgt $%0,$%1,%a\n"   1
   214	stmt: GTU(reg,reg)  "bgtu $%0,$%1,%a\n"  1
   215	stmt: LEI(reg,reg)  "ble $%0,$%1,%a\n"   1
   216	stmt: LEU(reg,reg)  "bleu $%0,$%1,%a\n"  1
   217	stmt: LTI(reg,reg)  "blt $%0,$%1,%a\n"   1
   218	stmt: LTU(reg,reg)  "bltu $%0,$%1,%a\n"  1
   219	stmt: NEI(reg,reg)  "bne $%0,$%1,%a\n"   1
   220	stmt: EQD(reg,reg)  "c.eq.d $f%0,$f%1; bc1t %a\n"  2
   221	stmt: EQF(reg,reg)  "c.eq.s $f%0,$f%1; bc1t %a\n"  2
   222	stmt: LED(reg,reg)  "c.le.d $f%0,$f%1; bc1t %a\n"  2
   223	stmt: LEF(reg,reg)  "c.le.s $f%0,$f%1; bc1t %a\n"  2
   224	stmt: LTD(reg,reg)  "c.lt.d $f%0,$f%1; bc1t %a\n"  2
   225	stmt: LTF(reg,reg)  "c.lt.s $f%0,$f%1; bc1t %a\n"  2
   226	stmt: GED(reg,reg)  "c.lt.d $f%0,$f%1; bc1f %a\n"  2
   227	stmt: GEF(reg,reg)  "c.lt.s $f%0,$f%1; bc1f %a\n"  2
   228	stmt: GTD(reg,reg)  "c.le.d $f%0,$f%1; bc1f %a\n"  2
   229	stmt: GTF(reg,reg)  "c.le.s $f%0,$f%1; bc1f %a\n"  2
   230	stmt: NED(reg,reg)  "c.eq.d $f%0,$f%1; bc1f %a\n"  2
   231	stmt: NEF(reg,reg)  "c.eq.s $f%0,$f%1; bc1f %a\n"  2
   232	ar:   ADDRGP     "%a"
       
   233	reg:  CALLD(ar)  "jal %0\n"  1
   234	reg:  CALLF(ar)  "jal %0\n"  1
   235	reg:  CALLI(ar)  "jal %0\n"  1
   236	stmt: CALLV(ar)  "jal %0\n"  1
   237	ar: reg    "$%0"
   238	ar: CNSTP  "%a"   range(a, 0, 0x0fffffff)
   239	stmt: RETD(reg)  "# ret\n"  1
   240	stmt: RETF(reg)  "# ret\n"  1
   241	stmt: RETI(reg)  "# ret\n"  1
   242	stmt: ARGD(reg)  "# arg\n"  1
   243	stmt: ARGF(reg)  "# arg\n"  1
   244	stmt: ARGI(reg)  "# arg\n"  1
   245	stmt: ARGP(reg)  "# arg\n"  1
       
   246	stmt: ARGB(INDIRB(reg))       "# argb %0\n"      1
   247	stmt: ASGNB(reg,INDIRB(reg))  "# asgnb %0 %1\n"  1
   248	%%
   249	static void progend(){}
   250	static void progbeg(argc, argv) int argc; char *argv[]; {
   251		int i;
       
   252		{
   253			union {
   254				char c;
   255				int i;
   256			} u;
   257			u.i = 0;
   258			u.c = 1;
   259			swap = (u.i == 1) != IR->little_endian;
   260		}
   261		print(".set reorder\n");
   262		pic = !IR->little_endian;
   263		parseflags(argc, argv);
   264		for (i = 0; i < argc; i++)
   265			if (strncmp(argv[i], "-G", 2) == 0)
   266				gnum = atoi(argv[i] + 2);
   267			else if (strcmp(argv[i], "-pic=1") == 0
   268			||       strcmp(argv[i], "-pic=0") == 0)
   269				pic = argv[i][5]-'0';
   270		for (i = 0; i < 31; i += 2)
   271			freg2[i] = mkreg("%d", i, 3, FREG);
   272		for (i = 0; i < 32; i++)
   273			ireg[i]  = mkreg("%d", i, 1, IREG);
   274		ireg[29]->x.name = "sp";
   275		d6 = mkreg("6", 6, 3, IREG);
   276		rmap[C] = rmap[S] = rmap[P] = rmap[B] = rmap[U] = rmap[I] =
   277			mkwildcard(ireg);
   278		rmap[F] = rmap[D] = mkwildcard(freg2);
   279		tmask[IREG] = INTTMP; tmask[FREG] = FLTTMP;
   280		vmask[IREG] = INTVAR; vmask[FREG] = FLTVAR;
   281		blkreg = mkreg("8", 8, 7, IREG);
   282	}
   283	static void target(p) Node p; {
   284		assert(p);
   285		switch (p->op) {
   286		case CNSTC: case CNSTI: case CNSTS: case CNSTU: case CNSTP:
   287			if (range(p, 0, 0) == 0) {
   288				setreg(p, ireg[0]);
   289				p->x.registered = 1;
   290			}
   291			break;
   292		case CALLV:             rtarget(p, 0, ireg[25]); break;
   293		case CALLD: case CALLF: rtarget(p, 0, ireg[25]);
   294		                        setreg(p, freg2[0]);     break;
   295		case CALLI:             rtarget(p, 0, ireg[25]);
   296		                        setreg(p, ireg[2]);      break;
   297		case RETD: case RETF:   rtarget(p, 0, freg2[0]); break;
   298		case RETI:              rtarget(p, 0, ireg[2]);  break;
   299		case ARGD: case ARGF: case ARGI: case ARGP: {
   300			static int ty0;
   301			int ty = optype(p->op);
   302			Symbol q;
       
   303			q = argreg(p->x.argno, p->syms[2]->u.c.v.i, ty, ty0);
   304			if (p->x.argno == 0)
   305				ty0 = ty;
   306			if (q &&
   307			!((ty == F || ty == D) && q->x.regnode->set == IREG))
   308				rtarget(p, 0, q);
   309			break;
   310			}
   311		case ASGNB: rtarget(p->kids[1], 0, blkreg); break;
   312		case ARGB:  rtarget(p->kids[0], 0, blkreg); break;
   313		}
   314	}
   315	static void clobber(p) Node p; {
   316		assert(p);
   317		switch (p->op) {
   318		case CALLD: case CALLF:
   319			spill(INTTMP | INTRET, IREG, p);
   320			spill(FLTTMP,          FREG, p);
   321			break;
   322		case CALLI:
   323			spill(INTTMP,          IREG, p);
   324			spill(FLTTMP | FLTRET, FREG, p);
   325			break;
   326		case CALLV:
   327			spill(INTTMP | INTRET, IREG, p);
   328			spill(FLTTMP | FLTRET, FREG, p);
   329			break;
   330		}
   331	}
   332	static void emit2(p) Node p; {
   333		int dst, n, src, ty;
   334		static int ty0;
   335		Symbol q;
       
   336		switch (p->op) {
   337		case ARGD: case ARGF: case ARGI: case ARGP:
   338			ty = optype(p->op);
   339			if (p->x.argno == 0)
   340				ty0 = ty;
   341			q = argreg(p->x.argno, p->syms[2]->u.c.v.i, ty, ty0);
   342			src = getregnum(p->x.kids[0]);
   343			if (q == NULL && ty == F)
   344				print("s.s $f%d,%d($sp)\n", src, p->syms[2]->u.c.v.i);
   345			else if (q == NULL && ty == D)
   346				print("s.d $f%d,%d($sp)\n", src, p->syms[2]->u.c.v.i);
   347			else if (q == NULL)
   348				print("sw $%d,%d($sp)\n", src, p->syms[2]->u.c.v.i);
   349			else if (ty == F && q->x.regnode->set == IREG)
   350				print("mfc1 $%d,$f%d\n", q->x.regnode->number, src);
   351			else if (ty == D && q->x.regnode->set == IREG)
   352				print("mfc1.d $%d,$f%d\n", q->x.regnode->number, src);
   353			break;
   354		case ASGNB:
   355			dalign = salign = p->syms[1]->u.c.v.i;
   356			blkcopy(getregnum(p->x.kids[0]), 0,
   357				getregnum(p->x.kids[1]), 0,
   358				p->syms[0]->u.c.v.i, tmpregs);
   359			break;
   360		case ARGB:
   361			dalign = 4;
   362			salign = p->syms[1]->u.c.v.i;
   363			blkcopy(29, p->syms[2]->u.c.v.i,
   364				getregnum(p->x.kids[0]), 0,
   365				p->syms[0]->u.c.v.i, tmpregs);
   366			n   = p->syms[2]->u.c.v.i + p->syms[0]->u.c.v.i;
   367			dst = p->syms[2]->u.c.v.i;
   368			for ( ; dst <= 12 && dst < n; dst += 4)
   369				print("lw $%d,%d($sp)\n", (dst/4)+4, dst);
   370			break;
   371		}
   372	}
   373	static Symbol argreg(argno, offset, ty, ty0)
   374	int argno, offset, ty, ty0; {
   375		assert((offset&3) == 0);
   376		if (offset > 12)
   377			return NULL;
   378		else if (argno == 0 && (ty == F || ty == D))
   379			return freg2[12];
   380		else if (argno == 1 && (ty == F || ty == D)
   381		&& (ty0 == F || ty0 == D))
   382			return freg2[14];
   383		else if (argno == 1 && ty == D)
   384			return d6;  /* Pair! */
   385		else
   386			return ireg[(offset/4) + 4];
   387	}
   388	static void doarg(p) Node p; {
   389		static int argno;
   390		int size;
       
   391		if (argoffset == 0)
   392			argno = 0;
   393		p->x.argno = argno++;
   394		size = p->syms[1]->u.c.v.i < 4 ? 4 : p->syms[1]->u.c.v.i;
   395		p->syms[2] = intconst(mkactual(size,
   396			p->syms[0]->u.c.v.i));
   397	}
   398	static void local(p) Symbol p; {
   399		if (askregvar(p, rmap[ttob(p->type)]) == 0)
   400			mkauto(p);
   401	}
   402	static void function(f, caller, callee, ncalls)
   403	Symbol f, callee[], caller[]; int ncalls; {
   404		int i, saved, sizefsave, sizeisave, varargs;
   405		Symbol r, argregs[4];
       
   406		usedmask[0] = usedmask[1] = 0;
   407		freemask[0] = freemask[1] = ~(unsigned)0;
   408		offset = maxoffset = maxargoffset = 0;
   409		for (i = 0; callee[i]; i++)
   410			;
   411		varargs = variadic(f->type)
   412			|| i > 0 && strcmp(callee[i-1]->name, "va_alist") == 0;
   413		for (i = 0; callee[i]; i++) {
   414			Symbol p = callee[i];
   415			Symbol q = caller[i];
   416			assert(q);
   417			offset = roundup(offset, q->type->align);
   418			p->x.offset = q->x.offset = offset;
   419			p->x.name = q->x.name = stringd(offset);
   420			r = argreg(i, offset, ttob(q->type), ttob(caller[0]->type));
   421			if (i < 4)
   422				argregs[i] = r;
   423			offset = roundup(offset + q->type->size, 4);
   424			if (varargs)
   425				p->sclass = AUTO;
   426			else if (r && ncalls == 0 &&
   427				 !isstruct(q->type) && !p->addressed &&
   428				 !(isfloat(q->type) && r->x.regnode->set == IREG)
   429	) {
   430				p->sclass = q->sclass = REGISTER;
   431				askregvar(p, r);
   432				assert(p->x.regnode && p->x.regnode->vbl == p);
   433				q->x = p->x;
   434				q->type = p->type;
   435			}
   436			else if (askregvar(p, rmap[ttob(p->type)])
   437				 && r != NULL
   438				 && (isint(p->type) || p->type == q->type)) {
   439				assert(q->sclass != REGISTER);
   440				p->sclass = q->sclass = REGISTER;
   441				q->type = p->type;
   442			}
   443		}
   444		assert(!caller[i]);
   445		offset = 0;
   446		gencode(caller, callee);
   447		if (ncalls)
   448			usedmask[IREG] |= ((unsigned)1)<<31;
   449		usedmask[IREG] &= 0xc0ff0000;
   450		usedmask[FREG] &= 0xfff00000;
   451		if (pic && ncalls)
   452			usedmask[IREG] |= 1<<25;
   453		maxargoffset = roundup(maxargoffset, 4);
   454		if (ncalls && maxargoffset < 16)
   455			maxargoffset = 16;
   456		sizefsave = 4*bitcount(usedmask[FREG]);
   457		sizeisave = 4*bitcount(usedmask[IREG]);
   458		framesize = roundup(maxargoffset + sizefsave
   459			+ sizeisave + maxoffset, 8);
   460		segment(CODE);
   461		print(".align 2\n");
   462		print(".ent %s\n", f->x.name);
   463		print("%s:\n", f->x.name);
   464		i = maxargoffset + sizefsave - framesize;
   465		print(".frame $sp,%d,$31\n", framesize);
   466		if (pic)
   467			print(".set noreorder\n.cpload $25\n.set reorder\n");
   468		if (framesize > 0)
   469			print("addu $sp,$sp,%d\n", -framesize);
   470		if (usedmask[FREG])
   471			print(".fmask 0x%x,%d\n", usedmask[FREG], i - 8);
   472		if (usedmask[IREG])
   473			print(".mask 0x%x,%d\n",  usedmask[IREG],
   474				i + sizeisave - 4);
   475		saved = maxargoffset;
   476		for (i = 20; i <= 30; i += 2)
   477			if (usedmask[FREG]&(3<<i)) {
   478				print("s.d $f%d,%d($sp)\n", i, saved);
   479				saved += 8;
   480			}
   481		for (i = 16; i <= 31; i++)
   482			if (usedmask[IREG]&(1<<i)) {
   483				if (i == 25)
   484					print(".cprestore %d\n", saved);
   485				else
   486					print("sw $%d,%d($sp)\n", i, saved);
   487				saved += 4;
   488			}
   489		for (i = 0; i < 4 && callee[i]; i++) {
   490			r = argregs[i];
   491			if (r && r->x.regnode != callee[i]->x.regnode) {
   492				Symbol out = callee[i];
   493				Symbol in  = caller[i];
   494				int rn = r->x.regnode->number;
   495				int rs = r->x.regnode->set;
   496				int tyin = ttob(in->type);
       
   497				assert(out && in && r && r->x.regnode);
   498				assert(out->sclass != REGISTER || out->x.regnode);
   499				if (out->sclass == REGISTER
   500				&& (isint(out->type) || out->type == in->type)) {
   501					int outn = out->x.regnode->number;
   502					if (rs == FREG && tyin == D)
   503						print("mov.d $f%d,$f%d\n", outn, rn);
   504					else if (rs == FREG && tyin == F)
   505						print("mov.s $f%d,$f%d\n", outn, rn);
   506					else if (rs == IREG && tyin == D)
   507						print("mtc1.d $%d,$f%d\n", rn,   outn);
   508					else if (rs == IREG && tyin == F)
   509						print("mtc1 $%d,$f%d\n",   rn,   outn);
   510					else
   511						print("move $%d,$%d\n",    outn, rn);
   512				} else {
   513					int off = in->x.offset + framesize;
   514					if (rs == FREG && tyin == D)
   515						print("s.d $f%d,%d($sp)\n", rn, off);
   516					else if (rs == FREG && tyin == F)
   517						print("s.s $f%d,%d($sp)\n", rn, off);
   518					else {
   519						int i, n = (in->type->size + 3)/4;
   520						for (i = rn; i < rn+n && i <= 7; i++)
   521							print("sw $%d,%d($sp)\n", i, off + (i-rn)*4);
   522					}
   523				}
   524			}
   525		}
   526		if (varargs && callee[i-1]) {
   527			i = callee[i-1]->x.offset + callee[i-1]->type->size;
   528			for (i = roundup(i, 4)/4; i <= 3; i++)
   529				print("sw $%d,%d($sp)\n", i + 4, framesize + 4*i);
   530			}
   531		emitcode();
   532		saved = maxargoffset;
   533		for (i = 20; i <= 30; i += 2)
   534			if (usedmask[FREG]&(3<<i)) {
   535				print("l.d $f%d,%d($sp)\n", i, saved);
   536				saved += 8;
   537			}
   538		for (i = 16; i <= 31; i++)
   539			if (usedmask[IREG]&(1<<i)) {
   540				print("lw $%d,%d($sp)\n", i, saved);
   541				saved += 4;
   542			}
   543		if (framesize > 0)
   544			print("addu $sp,$sp,%d\n", framesize);
   545		print("j $31\n");
   546		print(".end %s\n", f->x.name);
   547	}
   548	static void defconst(ty, v) int ty; Value v; {
   549		switch (ty) {
   550		case C: print(".byte %d\n",   v.uc); return;
   551		case S: print(".half %d\n",   v.ss); return;
   552		case I: print(".word 0x%x\n", v.i);  return;
   553		case U: print(".word 0x%x\n", v.u);  return;
   554		case P: print(".word 0x%x\n", v.p); return;
   555		case F: print(".word 0x%x\n", *(unsigned *)&v.f); return;
   556		case D: {
   557			unsigned *p = (unsigned *)&v.d;
   558			print(".word 0x%x\n.word 0x%x\n", p[swap], p[!swap]);
   559			return;
   560			}
   561		}
   562		assert(0);
   563	}
   564	static void defaddress(p) Symbol p; {
   565		if (pic && p->scope == LABELS)
   566			print(".gpword %s\n", p->x.name);
   567		else
   568			print(".word %s\n", p->x.name);
   569	}
   570	static void defstring(n, str) int n; char *str; {
   571		char *s;
       
   572		for (s = str; s < str + n; s++)
   573			print(".byte %d\n", (*s)&0377);
   574	}
   575	static void export(p) Symbol p; {
   576		print(".globl %s\n", p->x.name);
   577	}
   578	static void import(p) Symbol p; {
   579		if (!isfunc(p->type))
   580			print(".extern %s %d\n", p->name, p->type->size);
   581	}
   582	static void defsymbol(p) Symbol p; {
   583		if (p->scope >= LOCAL && p->sclass == STATIC)
   584			p->x.name = stringf("L.%d", genlabel(1));
   585		else if (p->generated)
   586			p->x.name = stringf("L.%s", p->name);
   587		else
   588			assert(p->scope != CONSTANTS || isint(p->type) || isptr(p->type)),
   589			p->x.name = p->name;
   590	}
   591	static void address(q, p, n) Symbol q, p; int n; {
   592		q->x.offset = p->x.offset + n;
   593		if (p->scope == GLOBAL
   594		|| p->sclass == STATIC || p->sclass == EXTERN)
   595			q->x.name = stringf("%s%s%d", p->x.name,
   596				n >= 0 ? "+" : "", n);
   597		else
   598			q->x.name = stringd(q->x.offset);
   599	}
   600	static void global(p) Symbol p; {
   601		if (p->u.seg == BSS) {
   602			if (p->sclass == STATIC || Aflag >= 2)
   603				print(".lcomm %s,%d\n", p->x.name, p->type->size);
   604			else
   605				print( ".comm %s,%d\n", p->x.name, p->type->size);
   606		} else {
   607			if (p->u.seg == DATA
   608			&& (p->type->size == 0 || p->type->size > gnum))
   609				print(".data\n");
   610			else if (p->u.seg == DATA)
   611				print(".sdata\n");
   612			print(".align %c\n", ".01.2...3"[p->type->align]);
   613			print("%s:\n", p->x.name);
   614		}
   615	}
   616	static void segment(n) int n; {
   617		cseg = n;
   618		switch (n) {
   619		case CODE: print(".text\n");  break;
   620		case LIT:  print(".rdata\n"); break;
   621		}
   622	}
   623	static void space(n) int n; {
   624		if (cseg != BSS)
   625			print(".space %d\n", n);
   626	}
   627	static void blkloop(dreg, doff, sreg, soff, size, tmps)
   628	int dreg, doff, sreg, soff, size, tmps[]; {
   629		int lab = genlabel(1);
       
   630		print("addu $%d,$%d,%d\n", sreg, sreg, size&~7);
   631		print("addu $%d,$%d,%d\n", tmps[2], dreg, size&~7);
   632		blkcopy(tmps[2], doff, sreg, soff, size&7, tmps);
   633		print("L.%d:\n", lab);
   634		print("addu $%d,$%d,%d\n", sreg, sreg, -8);
   635		print("addu $%d,$%d,%d\n", tmps[2], tmps[2], -8);
   636		blkcopy(tmps[2], doff, sreg, soff, 8, tmps);
   637		print("bltu $%d,$%d,L.%d\n", dreg, tmps[2], lab);
   638	}
   639	static void blkfetch(size, off, reg, tmp)
   640	int size, off, reg, tmp; {
   641		assert(size == 1 || size == 2 || size == 4);
   642		if (size == 1)
   643			print("lbu $%d,%d($%d)\n",  tmp, off, reg);
   644		else if (salign >= size && size == 2)
   645			print("lhu $%d,%d($%d)\n",  tmp, off, reg);
   646		else if (salign >= size)
   647			print("lw $%d,%d($%d)\n",   tmp, off, reg);
   648		else if (size == 2)
   649			print("ulhu $%d,%d($%d)\n", tmp, off, reg);
   650		else
   651			print("ulw $%d,%d($%d)\n",  tmp, off, reg);
   652	}
   653	static void blkstore(size, off, reg, tmp)
   654	int size, off, reg, tmp; {
   655		if (size == 1)
   656			print("sb $%d,%d($%d)\n",  tmp, off, reg);
   657		else if (dalign >= size && size == 2)
   658			print("sh $%d,%d($%d)\n",  tmp, off, reg);
   659		else if (dalign >= size)
   660			print("sw $%d,%d($%d)\n",  tmp, off, reg);
   661		else if (size == 2)
   662			print("ush $%d,%d($%d)\n", tmp, off, reg);
   663		else
   664			print("usw $%d,%d($%d)\n", tmp, off, reg);
   665	}
   666	static void stabinit ARGS((char *, int, char *[]));
   667	static void stabline ARGS((Coordinate *));
   668	static void stabsym ARGS((Symbol));
       
   669	static char *currentfile;
       
   670	static int bitcount(mask) unsigned mask; {
   671		unsigned i, n = 0;
       
   672		for (i = 1; i; i <<= 1)
   673			if (mask&i)
   674				n++;
   675		return n;
   676	}
       
   677	/* stabinit - initialize stab output */
   678	static void stabinit(file, argc, argv) int argc; char *file, *argv[]; {
   679		if (file) {
   680			print(".file 2,\"%s\"\n", file);
   681			currentfile = file;
   682		}
   683	}
       
   684	/* stabline - emit stab entry for source coordinate *cp */
   685	static void stabline(cp) Coordinate *cp; {
   686		if (cp->file && cp->file != currentfile) {
   687			print(".file 2,\"%s\"\n", cp->file);
   688			currentfile = cp->file;
   689		}
   690		print(".loc 2,%d\n", cp->y);
   691	}
       
   692	/* stabsym - output a stab entry for symbol p */
   693	static void stabsym(p) Symbol p; {
   694		if (p == cfunc && IR->stabline)
   695			(*IR->stabline)(&p->src);
   696	}
   697	Interface mipsebIR = {
   698		1, 1, 0,  /* char */
   699		2, 2, 0,  /* short */
   700		4, 4, 0,  /* int */
   701		4, 4, 1,  /* float */
   702		8, 8, 1,  /* double */
   703		4, 4, 0,  /* T * */
   704		0, 1, 0,  /* struct */
   705		0,	/* little_endian */
   706		0,  /* mulops_calls */
   707		0,  /* wants_callb */
   708		1,  /* wants_argb */
   709		1,  /* left_to_right */
   710		0,  /* wants_dag */
   711	address,
   712	blockbeg,
   713	blockend,
   714	defaddress,
   715	defconst,
   716	defstring,
   717	defsymbol,
   718	emit,
   719	export,
   720	function,
   721	gen,
   722	global,
   723	import,
   724	local,
   725	progbeg,
   726	progend,
   727	segment,
   728	space,
   729		0, 0, 0, stabinit, stabline, stabsym, 0,
   730		{
   731			4,	/* max_unaligned_load */
   732			blkfetch, blkstore, blkloop,
   733			_label,
   734			_rule,
   735			_nts,
   736			_kids,
   737			_opname,
   738			_arity,
   739			_string,
   740			_templates,
   741			_isinstruction,
   742			_ntname,
   743			emit2,
   744			doarg,
   745			target,
   746			clobber,
       
   747		}
   748	}, mipselIR = {
   749		1, 1, 0,  /* char */
   750		2, 2, 0,  /* short */
   751		4, 4, 0,  /* int */
   752		4, 4, 1,  /* float */
   753		8, 8, 1,  /* double */
   754		4, 4, 0,  /* T * */
   755		0, 1, 0,  /* struct */
   756		1,	/* little_endian */
   757		0,  /* mulops_calls */
   758		0,  /* wants_callb */
   759		1,  /* wants_argb */
   760		1,  /* left_to_right */
   761		0,  /* wants_dag */
   762	address,
   763	blockbeg,
   764	blockend,
   765	defaddress,
   766	defconst,
   767	defstring,
   768	defsymbol,
   769	emit,
   770	export,
   771	function,
   772	gen,
   773	global,
   774	import,
   775	local,
   776	progbeg,
   777	progend,
   778	segment,
   779	space,
   780		0, 0, 0, stabinit, stabline, stabsym, 0,
   781		{
   782			4,	/* max_unaligned_load */
   783			blkfetch, blkstore, blkloop,
   784			_label,
   785			_rule,
   786			_nts,
   787			_kids,
   788			_opname,
   789			_arity,
   790			_string,
   791			_templates,
   792			_isinstruction,
   793			_ntname,
   794			emit2,
   795			doarg,
   796			target,
   797			clobber,
       
   798		}
   799	};
