/* 
 * $Id: C-ident.h,v 1.10 2000/06/29 23:20:12 m-hirano Exp $
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* storage classes */

#ifndef __IDENT_H__
#define __IDENT_H__

typedef enum storage_class {
    SNULL = 0,	/* undefined */
    AUTO,	/* auto variable,1 */
    PARAM,	/* paramter,2 */
    EXTERN,	/* extern variable,3 */
    EXTDEF,	/* external defition,4 */
    STATIC,	/* static variable,5 */
    REGISTER,	/* register variable,6 */
    LABEL,	/* label,7 */
    ULABEL,	/* undefined label, (temporary),8 */
    TAGNAME,	/* tag name for struct/union/enum,9 */
    MOE,	/* member of enum,10 */
    TYPEDEF_NAME,	/* typedef name,11 */
    STORAGE_CLASS_END
} STORAGE_CLASS;

#define N_STORAGE_CLASS ((int)STORAGE_CLASS_END)

extern char *storage_class_names[];

#define STORAGE_CLASS_NAMES \
{ \
  "*",\
  "auto",\
  "param",\
  "extern",\
  "extern_def",\
  "static",\
  "register",\
  "label",\
  "_label",\
  "tagname",\
  "moe",\
  "typedef_name",\
}

typedef struct ident_descriptor {
    struct ident_descriptor *ip_next;	/* next ID */
    SYMBOL name;			/* key(symbol) */
    STORAGE_CLASS class;		/* storage class */
    char label_is_defined;
    char bit_field_len;
    char error_flag;			/* error has occured */
    char hide_flag;			/* hide some variable */
    struct type_descriptor *type;	/* type */
    expv base;			/* base address expression value */
} *ID;

#define ID_NEXT(ip)		((ip)->ip_next)
#define ID_SYM(ip)		((ip)->name)
#define ID_NAME(ip)		SYM_NAME((ip)->name)
#define ID_TYPE(ip)		((ip)->type)
#define ID_CLASS(ip)		((ip)->class)
#define ID_BASE(ip)		((ip)->base)
#define ID_CASE_EXPV(ip)	((ip)->base)	/* case statement */
#define ID_LABEL_IS_DEFINED(ip)		((ip)->label_is_defined)
#define ID_BIT_FIELD_LEN(ip)	((ip)->bit_field_len)
#define ID_ERROR(ip)		((ip)->error_flag)
#define ID_HIDE(ip) 		((ip)->hide_flag)

#endif
