static char rcsid[] = "$Id: C-mem.c,v 1.6 2000/07/06 16:18:47 m-hirano Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* structure element allocation */

#include "C-front.h"

#define XMALLOC(t,size)	((t)xmalloc(size))

/* allocate new ID struct and init as arg(sp) */
ID      new_ident_desc(sp)
    SYMBOL  sp;
{
    ID      id;

    id = XMALLOC(ID, sizeof(*id));
    ID_SYM(id) = sp;
    return (id);
}

/* allocate new TYPE struct and init as arg(code) */
TYPE_DESC new_type_desc(code)
    enum expr_code code;
{
    TYPE_DESC tp;

    tp = XMALLOC(TYPE_DESC, sizeof(*tp));
    TYPE_DESC_CODE(tp) = code;
    return (tp);
}

/* construct expression */
expv    expv_cons(code, tp, left, right)
    enum expr_code code;
    TYPE_DESC tp;
    expv    left, right;
{
    expv    v;
    struct list_node *l, *r;

    v = XMALLOC(expv, sizeof(*v));
    l = XMALLOC(struct list_node *, sizeof(struct list_node));
    EXPV_CODE(v) = code;
    EXPV_TYPE(v) = tp;
    EXPV_LIST(v) = l;
    l->l_item = left;
    if (right) {
	r = XMALLOC(struct list_node *, sizeof(struct list_node));
	r->l_item = right;
	l->l_next = r;
    }
    return (v);
}

/*
 * FOR: IDENT STRING_CONSTANT LONG_CONSTANT LABEL_CONSTANT
 */

/* allocate new expv and init as args(general:symbol,var,etc.) */
expv    expv_sym_term(code, tp, name)
    enum expr_code code;
    TYPE_DESC tp;
    SYMBOL  name;
{
    expv    v;

    v = XMALLOC(expv, sizeof(*v));
    EXPV_CODE(v) = code;
    EXPV_TYPE(v) = tp;
    EXPV_NAME(v) = name;
    return (v);
}

/* allocate new expv and init as args(int) */
expv    expv_int_term(code, tp, i)
    enum expr_code code;
    TYPE_DESC tp;
    int     i;
{
    expv    v;

    v = XMALLOC(expv, sizeof(*v));
    EXPV_CODE(v) = code;
    EXPV_TYPE(v) = tp;
    EXPV_GEN(v) = (void *)i;
    return (v);
}

/* allocate new expv and init as args(long) */
expv    expv_long_term(code, tp, i)
    enum expr_code code;
    TYPE_DESC tp;
    long     i;
{
    expv    v;

    v = XMALLOC(expv, sizeof(*v));
    EXPV_CODE(v) = code;
    EXPV_TYPE(v) = tp;
    EXPV_GEN(v) = (void *)i;
    return (v);
}

expv	expv_any_term(code, p)
     enum expr_code code;
     void *p;
{
    expv v;
    v = XMALLOC(expv,sizeof(*v));
    EXPV_CODE(v) = code;
    EXPV_TYPE(v) = NULL;
    EXPV_GEN(v) = p;
    return(v);
}

/* allocate new expv and init as args(string) */
expv    expv_str_term(tp, str)
    TYPE_DESC tp;
    char   *str;
{
    expv    v;

    v = XMALLOC(expv, sizeof(*v));
    EXPV_CODE(v) = STRING_CONSTANT;
    EXPV_TYPE(v) = tp;
    EXPV_STR(v) = str;
    return (v);
}

/* allocate new expv and init as args(double) */
expv    expv_float_term(tp, d)
    TYPE_DESC tp;
    double  d;
{
    expv    v;

    v = XMALLOC(expv, sizeof(*v));
    EXPV_CODE(v) = FLOAT_CONSTANT;
    EXPV_TYPE(v) = tp;
    EXPV_FLOAT_VALUE(v) = d;
    return (v);
}

/* allocate new expv and init as args(longlong) */
expv    expv_longlong_term(tp, ll)
    TYPE_DESC tp;
    longlong ll;
{
    expv    v;

    v = XMALLOC(expv, sizeof(*v));
    EXPV_CODE(v) = LONGLONG_CONSTANT;
    EXPV_TYPE(v) = tp;
    EXPV_LLINT_VALUE(v) = ll;
    return (v);
}

/* allocate new expv and init as the same expv arg, v */
expv    expv_retype(tp, v)
    TYPE_DESC tp;
    expv    v;
{
    expv    vv;

    vv = XMALLOC(expv, sizeof(*vv));
    bcopy(v, vv, sizeof(*v));
    EXPV_TYPE(vv) = tp;
    return (vv);
}
