/* 
 * $Id: C-ogr-pragma.h,v 1.6 2001/12/07 10:52:26 m-hirano Exp $
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */

#ifndef __C_OGR_PRAGMA_H__
#define __C_OGR_PRAGMA_H__

#include "C-ogr-hash.h"

extern expr pg_tok_val;

typedef enum {
    ogBT_UNKNOWN = 0,
    ogBT_CHAR,
    ogBT_UCHAR,
    ogBT_SHORTINT,
    ogBT_USHORTINT,
    ogBT_INT,
    ogBT_UINT,
    ogBT_LONGINT,
    ogBT_ULONGINT,
#ifdef HAS_LONGLONG
    ogBT_LONGLONGINT,
    ogBT_ULONGLONGINT,
#endif /* HAS_LONGLONG */
    ogBT_FLOAT,
    ogBT_DOUBLE,
#ifdef HAS_LONGDOUBLE
    ogBT_LONGDOUBLE,
#endif /* HAS_LONGDOUBLE */
    ogBT_VOID
} ogr_basic_type_t;


typedef enum {
    ogRT_UNKNOWN = 0,
    ogRT_SCALAR,
    ogRT_POINTER
} ogr_ref_type_t;


typedef enum {
    ogMD_UNKNOWN = 0,
    ogMD_IN,
    ogMD_OUT,
    ogMD_INOUT,
    ogMD_WORK
} ogr_mode_type_t;


typedef enum {
    ogTkn_unknown = 0,	/* must be the first one. */

    ogTkn_IN,
    ogTkn_OUT,
    ogTkn_INOUT,
    ogTkn_WORK,

    ogTkn_mode_in,
    ogTkn_mode_out,
    ogTkn_mode_inout,
    ogTkn_mode_work,

    ogTkn_char,
    ogTkn_int,
    ogTkn_float,
    ogTkn_double,

    ogTkn_signed,
    ogTkn_unsigned,

    ogTkn_short,
    ogTkn_long,

    ogTkn_void		/* must be the last one. */
} ogr_type_token_t;


typedef struct {
    char *token;
    ogr_type_token_t tokenType;
} ogr_token_t;


typedef struct paramInfoRec {
    struct paramInfoRec *next;	/* uni-direction list */
    char *paramname;		/* parameter name, heap alloc'd */
    ogr_mode_type_t mode;	/* parameter mode */
    ogr_basic_type_t btype;	/* basic type */
    ogr_ref_type_t pOs;		/* pointer or scalar */
    int dim;			/* dimension */
} ogr_param_info;


typedef struct {
    char *stubname;			/* id of the stub, heap alloc'd */
    char *stubdecl;			/* 'define_func' pragma string itself,
					   heap alloc'd */
    char *comment;			/* A comment string for the stub,
					   heap alloc'd */
    int state;				/* OR'd bellows */
#define OGR_STUB_NONE		0x0	/* initial state */
#define OGR_STUB_DECLARED	0x1	/* declared by 'define_func' */
#define OGR_STUB_GENERATED	0x2	/* generated by 'gen_stub' */
#define OGR_STUB_DEFINED	0x4	/* bounded to a function body by 
					   'start_func_body' and
					   'end_func_body' */

    char *module;			/* module name, heap alloc'd */
    char *require;			/* require options, heap alloc'd */
    char *callname;			/* "module/stubname", heap alloc'd */
    int external;			/* 1 means that the stub is generated
					   outside of this souece file */

    ogr_param_info *params;		/* parameter info chain,
					   heap alloc'd */

    ogr_param_info *extVar;		/* external variables info chain,
					   heap alloc'd */

    ogr_param_info *retVar;		/* for a return value,
					   heap alloc'd */

    char *funcbody;			/* stub function body, heap alloc'd */
} ogr_stub_info;

#ifndef OGR_CHK_SYMNAME
#define OGR_CHK_SYMNAME		"__ogr_enable"
#endif /* OGR_CHK_SYMNAME */

#endif /* __C_OGR_PRAGMA_H__ */
