/* 
 * $Id: Cxx-parser.y,v 1.4 2002/04/03 12:50:21 m-hirano Exp $
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* currently, conflicts:  32 shift/reduce, 6 reduce/reduce */
/* 
 * C++ grammer
 */

%token CONSTANT 	/* constant: integer,string,char,float,whatever.. */
%token IDENTIFIER 	/* identifier */
%token TYPENAME		/* type name identifier */
%token TYPEDEF

/* reserved words, etc */
/* type and storage class keywords */
%token TYPE CLASS TYPE_QUALIFIER

/* keywords */
%token STRUCT SIZEOF ENUM UNION 
%token WHILE RETURN GOTO IF ELSE SWITCH BREAK CONTINUE DO FOR
%token CASE DEFAULT 
%token ELLIPSIS

/* C++ keywords */
%token KW_CLASS
%token KW_NEW
%token KW_DELETE
%token KW_VIRTUAL
%token KW_FRIEND
%token KW_OVERLOAD
%token KW_OPERATOR
%token KW_THIS
%token KW_INLINE
%token KW_PUBLIC
%token KW_PRIVATE
%token KW_PROTECTED
%token COL2
%token EXTERN_C
%token EXTERN_CXX

/* syntax tokens for #pragma */
%token PRAGMA_DECL	/* parama, for decl */
%token PRAGMA_EXEC	/* parama, for exec */
%token PRAGMA_PREFIX	/* pragma, which affects the next statement */
%token PRAGMA_POSTFIX

/* At last count, there were 6 shift/reduce, 6 reduce/reduce */

%nonassoc IF
%nonassoc ELSE

/* precedence rules */
%left ','
%right '='
%right '?' ':'
%left OROR		/* logical OR operation */
%left ANDAND		/* logical AND operation */
%left '|'		/* bitwise OR operation */
%left '^'		/* bitwise EX-OR operation */
%left '&'		/* bitwise AND operation */
%left EQEQ NOTEQ	/* '==' '!=' */
%left LE		/* relational expression */
%left LT		/* relational expression */
%left GE		/* relational expression */
%left GT		/* relational expression */
%left LSHIFT RSHIFT	/* shift '<<' '>>' operation */
%left '+' '-'		/* add and minus */ 
%left '*' '/' '%'	/* mul and div , mod */
%right '!' '~'		/* unary operation */
%right UNARY PLUSPLUS MINUSMINUS
%left UNARY_HIGH_PRIORITY
%left '[' '(' STREF '.'

%{
#include "C-front.h"

static int 	read_number _ANSI_ARGS_((int ch));
static int 	read_identifier _ANSI_ARGS_((char ch));
static int 	read_string_constant _ANSI_ARGS_((int mark));
static int 	read_char_constant _ANSI_ARGS_((int mark));
static int	is_TYPENAME_IDENT _ANSI_ARGS_((SYMBOL  sp));

static char *	search_keyword_by_token _ANSI_ARGS_((int t));

static int 	lex_getc _ANSI_ARGS_((void));
static void 	yyerror _ANSI_ARGS_((char *s));
static int 	yylex _ANSI_ARGS_((void));
static int	yylex0 _ANSI_ARGS_((void)); /* for debug */

static int	is_func_decl_expr _ANSI_ARGS_((expr x));
static void	save_statement_list _ANSI_ARGS_((void));
static void	put_statement_list _ANSI_ARGS_((expr x));
static expr	restore_statement_list _ANSI_ARGS_((void));
static void	mark_type_name _ANSI_ARGS_((expr decl_list, enum expr_code code));
static void	mark_type_ident _ANSI_ARGS_((expr ident));

typedef union {
    expr val;
    lineno_info *lineno;
} yyStackType;

#define YYSTYPE yyStackType

%}

/* define types */
%type <lineno> ENUM STRUCT UNION IF WHILE DO FOR SWITCH BREAK CONTINUE RETURN
%type <lineno> GOTO CASE DEFAULT 
%type <lineno>  '=' '+' '-' '*' '/' '%' '?' LSHIFT RSHIFT 
%type <lineno> EQEQ NOTEQ LT GT LE GE ANDAND OROR
%type <lineno> '{' begin_compound_statement
%type <lineno> '&' '|' '^'  '!' '~' PLUSPLUS MINUSMINUS SIZEOF
%type <lineno> KW_CLASS KW_NEW KW_DELETE

%type <val> function_definition declaration declarator compound_statement
%type <val> function_declarator
%type <val> declaration_list init_declarator_list init_declarator 
%type <val> decl_specifier CLASS TYPE TYPENAME type_specifier 
%type <val> type_specifier_no_qual TYPE_QUALIFIER type_qualifier_list
%type <val> struct_or_union_dcl
%type <val> struct_decl_list struct_declaration tag_name
%type <val> enum_dcl enumerator_list enumerator
%type <val> identifier_list parameter_list parameter type_name abstract_declarator
%type <val> initializer initializer_list 
%type <val> statement label
%type <val> expr expr_or_null expr_list binary_expr unary_expr
%type <val> assign_expr postfix_expr primary_expr
%type <val> IDENTIFIER CONSTANT 
%type <val> PRAGMA_DECL PRAGMA_EXEC PRAGMA_PREFIX PRAGMA_POSTFIX

%type <val> type_name1 abstract_declarator1
%type <val> base_class_opt base_class_list base_class_spec 
%type <val> operators

%start program

%%

/* program toplevel */

program:
	/* empty */
  	| external_definition_list
	;

external_definition_list: 
	external_definition 
	| external_definition_list external_definition 
	;

external_definition:		
	declaration		/* data declaration */
	{ compile_external_declaration($1); }
	| function_definition	/* function definition */
	{ compile_function($1); }
	| EXTERN_C '{' { extern_C_begin(); } external_definition_list
	  '}' { extern_C_end(); }
	| EXTERN_C '{' '}'
	| EXTERN_CXX '{' { extern_C_begin(); } external_definition_list
	  '}' { extern_C_end(); } /* xxx */
	| EXTERN_CXX '{' '}'
	| ';'
	| error
	;

function_definition :
	function_declarator compound_statement
	{ $$ = list4(FUNCTION_DEFINITION, NULL, $1, NULL, $2); }
	| decl_specifier function_declarator compound_statement
	{ $$ = list4(FUNCTION_DEFINITION, $1, $2, NULL, $3); }
	| function_declarator declaration_list compound_statement
	{ $$ = list4(FUNCTION_DEFINITION, NULL, $1, $2, $3); }
	| decl_specifier function_declarator declaration_list
	  compound_statement
	{ $$ = list4(FUNCTION_DEFINITION, $1, $2, $3, $4); }
	| function_declarator ';'
	{ $$ = list4(FUNCTION_DEFINITION, NULL, $1, NULL, NULL); }
	;

function_declarator:	/* check if it can be function declaration */
	declarator
	{ $$ = $1;
	/*  if( !is_func_decl_expr($1) )
	      YYERROR; *//* must be check!! xxx */
	}
	| TYPENAME '(' ')' /* constructor */
	{ $$ = NULL; } /* xxx */
	| TYPENAME '(' parameter_list ')'
	{ $$ = NULL; }/* xxx */
	| '~' TYPENAME '(' ')'
	{ $$ = NULL; }/* xxx */
	| '~' TYPENAME '(' parameter_list ')'
	{ $$ = NULL; }/* xxx */
	| TYPENAME COL2 TYPENAME '(' ')' /* constructor */
	{ $$ = NULL; }/* xxx */
	| TYPENAME COL2 TYPENAME '(' parameter_list ')'
	{ $$ = NULL; }/* xxx */
	| TYPENAME COL2 '~' TYPENAME '(' ')'
	{ $$ = NULL; }/* xxx */
	| TYPENAME COL2 '~' TYPENAME '(' parameter_list ')'
	{ $$ = NULL; }/* xxx */
	;

/* 
 * Declaration
 */
declaration_list:
	declaration
	{ $$ = list1(LIST,$1); }
	| declaration_list declaration
	{ $$ = list_put_last($1,$2); }
	;

declaration:
	decl_specifier	';'
	{ $$ = list2(LIST, $1, NULL); }
	| decl_specifier init_declarator_list ';'
	{ mark_type_name($2, IDENT);
	  $$ = list2(LIST, $1, $2); }
	| TYPEDEF type_specifier init_declarator_list ';'
	{ mark_type_name($3, TYPENAME_IDENT);
	  $$=list2(TYPEDEF_DECL, $2, $3); }
	| TYPEDEF type_specifier TYPENAME ';'
	{ /* mark_type_name($3, TYPENAME_IDENT); */ /* xxx, scope */
	  $$=list2(TYPEDEF_DECL, $2, $3); }
	| error '}'
	{ $$ = NULL; }
	| PRAGMA_DECL		/* for decl pragma */
	;

decl_specifier:
	type_specifier
	{ $$ = list2(LIST, NULL, $1); }
	| CLASS
	{ $$ = list2(LIST, $1, NULL); }
	| CLASS type_specifier
	{ $$ = list2(LIST, $1, $2); }
	| type_specifier CLASS
	{ $$ = list2(LIST, $2, $1); }
	| TYPE CLASS type_specifier
	{ expr ex = list2(LIST, $1, $3);
	  $$ = list2(LIST, $2, ex); }
	| type_specifier CLASS TYPE
	{ expr ex = list2(LIST, $1, $3);
	  $$ = list2(LIST, $2, ex); }
	;

type_specifier:
	type_specifier_no_qual
	| TYPE_QUALIFIER type_specifier
	{ $$ = list2(LIST, $1, $2); }
	| type_specifier TYPE_QUALIFIER
	{ $$ = list2(LIST, $2, $1); }
	|  TYPE_QUALIFIER	/* null? */
	{ $$ = list1(LIST, $1); }
	;

type_specifier_no_qual:
	TYPE
	| TYPE TYPE
	{ $$ = list2(LIST, $1, $2); }
	| TYPE TYPE TYPE	/* ex. unsigned long int */
	{ expr ex = list2(LIST, $2, $3);
	  $$ = list2(LIST, $1, ex); }
	| TYPE TYPE TYPE TYPE	/* ex. unsigned long long int */
	{ expr ex  = list2(LIST, $3, $4);
	  expr ex2 = list2(LIST, $2, ex);
	  $$ = list2(LIST, $1, ex2); }
	| struct_or_union_dcl
	| enum_dcl
  	| TYPENAME
	;

type_qualifier_list:
	TYPE_QUALIFIER
	{ $$ = list1(LIST, $1); }
	| type_qualifier_list TYPE_QUALIFIER
	{ $$ = list_put_last($1, $2); }
	;

init_declarator_list:
	init_declarator		%prec ','
	{ $$ = list1(LIST, $1); }
	| init_declarator_list	',' init_declarator
	{ $$ = list_put_last($1, $3); }
	;

init_declarator:
	declarator
	| declarator '=' initializer
	{ $$ = list2(LIST, $1, $3); }
	;

declarator:
	IDENTIFIER
/*        | TYPENAME
	{ EXPR_CODE($1) = IDENT;
	  $$ = $1; } */
	| TYPENAME COL2 IDENTIFIER
	{  $$ = $3; }
	| KW_OPERATOR operators
	{  $$ = NULL; } /* XXX */
	| declarator '(' ')'
	{ $$ = list2(FUNCTION_DECL, $1, NULL); }
	| declarator '(' identifier_list ')'
	{ $$ = list2(FUNCTION_DECL, $1, $3); }
	| declarator '(' parameter_list ')'
	{ $$ = list2(FUNCTION_PROTO_DECL, $1, $3); }
	| declarator '(' ')' TYPE_QUALIFIER
	{ $$ = list2(FUNCTION_DECL, $1, NULL); } /* xxx */
	| declarator '(' parameter_list ')' TYPE_QUALIFIER
	{ $$ = list2(FUNCTION_PROTO_DECL, $1, $3); } /* xxx */
	| '(' declarator ')'
	{ $$ = $2; }
	| declarator '['expr_or_null ']'
	{ $$ = list2(ARRAY_DECL, $1, $3); }
	| '*' declarator
	{ $$ = list1(POINTER_DECL, $2); }
	| '*' type_qualifier_list declarator
	{ expr ex = list2(LIST, $3, $2);
	  $$ = list1(POINTER_DECL, ex); }
	| '&' declarator    /* C++ reference type */
	{ $$ = list1(REF_DECL, $2); } /* xxx */
	| '&' type_qualifier_list declarator /* C++ reference type */
	{ expr ex = list2(LIST, $3, $2); 
	  $$ = list1(REF_DECL, ex); }
	| IDENTIFIER ':' expr
	{ $$ = list2(BIT_FIELD_DECL,$1,$3); }
	| ':' expr
	{ $$ = list2(BIT_FIELD_DECL,NULL,$2); }
	;

/*
 * class, structure and union declaration
 */
struct_or_union_dcl:
	STRUCT '{' struct_decl_list '}'
	{ $$ = elist3($1,STRUCT_TYPE, NULL, $3, NULL); }
	| STRUCT tag_name base_class_opt '{' struct_decl_list '}'
	{ $$ = elist3($1,STRUCT_TYPE, $2, $5, $3); }
	| STRUCT tag_name base_class_opt
	{ $$ = elist3($1,STRUCT_TYPE, $2, NULL, $3); }

	| UNION '{' struct_decl_list '}'
	{ $$ = elist3($1,UNION_TYPE, NULL, $3, NULL); }
	| UNION tag_name base_class_opt '{' struct_decl_list '}'
	{ $$ = elist3($1,UNION_TYPE, $2, $5, $3); }
	| UNION tag_name base_class_opt
	{ $$ = elist3($1,UNION_TYPE, $2, NULL, $3); }

	| KW_CLASS '{' struct_decl_list '}'
	{ $$ = elist3($1,CLASS_TYPE, NULL, $3, NULL); }
	| KW_CLASS tag_name base_class_opt '{' struct_decl_list '}'
	{ $$ = elist3($1,CLASS_TYPE, $2, $5, $3); }
	| KW_CLASS tag_name base_class_opt
	{ $$ = elist3($1,CLASS_TYPE, $2, NULL,$3); }
	;

base_class_opt:
	 { $$ = NULL; }
	| ':' base_class_list
	 { $$ = $2; }
	;

base_class_list:
	  base_class_spec
	 { $$ = list1(LIST,$1); }
	| base_class_list ',' base_class_spec
	 { $$ = list_put_last($1,$3); }
	;

base_class_spec:
	 IDENTIFIER /* class name */
	 { $$ = $1; }
	| KW_PUBLIC tag_name
	 { $$ = list2(LIST,make_enode(CXX_ATTR_DECL,(void *)CXX_ATTR_PUBLIC),
		      $2); }
	| KW_PRIVATE tag_name
	 { $$ = list2(LIST,make_enode(CXX_ATTR_DECL,(void *)CXX_ATTR_PRIVATE),
		      $2); }
	| KW_PROTECTED tag_name
	 { $$ = list2(LIST,make_enode(CXX_ATTR_DECL,(void *)CXX_ATTR_PROTECTED),
		      $2); }
	;

struct_decl_list:
	struct_declaration
	{ $$ = list1(LIST, $1); }
	| struct_decl_list struct_declaration
	{ $$ = list_put_last($1, $2); }
	;

struct_declaration:
	  declaration
	| function_definition
	| KW_PUBLIC ':'
        { $$ = make_enode(CXX_ATTR_DECL,(void *)CXX_ATTR_PUBLIC); }
	| KW_PRIVATE ':'
        { $$ = make_enode(CXX_ATTR_DECL,(void *)CXX_ATTR_PRIVATE); }
	| KW_PROTECTED ':'
        { $$ = make_enode(CXX_ATTR_DECL,(void *)CXX_ATTR_PROTECTED); }
	| error ';'
	{ $$ = NULL; }
	;

/*
 * enum type declaration
 */
enum_dcl:
	ENUM '{' enumerator_list comma_or_null '}'
	{ $$ = elist2($1,ENUM_TYPE, NULL, $3); }
	| ENUM tag_name '{' enumerator_list comma_or_null '}'
	{ $$ = elist2($1,ENUM_TYPE, $2, $4); }
	|ENUM tag_name
	{ $$ = elist2($1,ENUM_TYPE, $2, NULL); }
	;

enumerator_list:
	enumerator
	{ $$ = list1(LIST, $1); }
	| enumerator_list ',' enumerator
	{ $$ = list_put_last($1, $3); }
	;

enumerator:
	IDENTIFIER
	{ $$ = list2(LIST, $1, NULL); }
	| IDENTIFIER '=' expr		%prec ','
	{ $$ = list2(LIST, $1, $3); }
	;

/* name,...,name */
identifier_list:
	IDENTIFIER
	{ $$ = list1(LIST, $1); }
	| identifier_list ',' IDENTIFIER
	{ $$ = list_put_last($1, $3); }
	| error
	{ $$ = NULL; }
	;

/* for ANSI-C parameter. */
parameter_list:
	parameter
	{ $$ = list1(LIST,$1); }
	| parameter_list ',' parameter
	{ $$ = list_put_last($1, $3); }
	;

parameter:
	type_specifier
	{ $$ = list2(LIST, $1, NULL); }
	| type_specifier declarator
	{ $$ = list2(LIST, $1, $2); }
	| type_specifier declarator '=' initializer
	{ $$ = list2(LIST, $1, $2); } /* xxx */
	| type_specifier abstract_declarator
	{ $$ = list2(LIST, $1, $2); }
	| ELLIPSIS
	{ $$ = NULL; }
	;

tag_name:
	IDENTIFIER { mark_type_ident($1); $$ = $1; }
        | TYPENAME 	/* use different name space! */
	;


type_name:
	type_specifier
	{ $$ = list2(LIST, $1, NULL); }
	| type_specifier abstract_declarator
	{ $$ = list2(LIST, $1, $2); }
	;

abstract_declarator:
	'(' abstract_declarator ')'
	{ $$ = $2; }
	| abstract_declarator '[' expr_or_null ']'
	{ $$ = list2(ARRAY_DECL, $1, $3); }
	| '[' expr_or_null ']'
	{ $$ = list2(ARRAY_DECL, NULL, $2); }
	| abstract_declarator '(' ')'
	{ $$ = list2(FUNCTION_DECL, $1, NULL); }
	| '(' ')'
	{ $$ = list2(FUNCTION_DECL, NULL, NULL); }
	| abstract_declarator '(' parameter_list ')'
	{ $$ = list2(FUNCTION_PROTO_DECL, $1, $3); }
	| '(' parameter_list ')'
	{ $$ = list2(FUNCTION_PROTO_DECL, NULL, $2); }
	| '*' abstract_declarator
	{ $$ = list1(POINTER_DECL, $2); }
	| '*' type_qualifier_list abstract_declarator
	{ expr ex = list2(LIST, $3, $2);
	  $$ = list1(POINTER_DECL, ex); }
	| '*'
	{ $$ = list1(POINTER_DECL, NULL); }
	| '*' type_qualifier_list
	{ expr ex = list2(LIST, NULL, $2);
	  $$ = list1(POINTER_DECL, ex); }
	| '&'
	{ $$ = list1(REF_DECL, NULL); }
	;

/* for new operator */
type_name1:
	type_specifier
	{ $$ = list2(LIST, $1, NULL); }
	| type_specifier abstract_declarator1
	{ $$ = list2(LIST, $1, $2); }
	| '(' type_name ')'
	{ $$ = $2; }	/* xxx */
	| '(' type_name ')' '[' expr ']'
	{ $$ = $2; }	/* xxx */
	;

/* abstract_declarator without followed by '(' ')'.
   this is for removing ambigourity constructor arguments and 
   cast operator overload */
abstract_declarator1:
	 abstract_declarator1 '[' expr_or_null ']'
	{ $$ = list2(ARRAY_DECL, $1, $3); }
	| '[' expr_or_null ']'
	{ $$ = list2(ARRAY_DECL, NULL, $2); }
	| '*' abstract_declarator1
	{ $$ = list1(POINTER_DECL, $2); }
	| '*' type_qualifier_list abstract_declarator1
	{ expr ex = list2(LIST, $3, $2);
	  $$ = list1(POINTER_DECL, ex); }
	| '*'
	{ $$ = list1(POINTER_DECL, NULL); }
	| '*' type_qualifier_list
	{ expr ex = list2(LIST, NULL, $2);
	  $$ = list1(POINTER_DECL, ex); }
	;

initializer:
	expr		%prec ','
	| '{' initializer_list comma_or_null '}'
	{ $$ = $2; }
	;

initializer_list:
	initializer	%prec ','
	{ $$ = elist1(EXPR_LINE($1),LIST,$1); }
	| initializer_list ',' initializer
	{ $$ = list_put_last($1, $3); }
	| error
	{ $$ = NULL; }
	;

comma_or_null:
	/* VOID */
	| ','
	;

/*
 * Statements
 */
compound_statement:
	 begin_compound_statement statement_list '}'
	{ expr ex = restore_statement_list();
	  $$ = elist1($1,COMPOUND_STATEMENT, ex); }
	;

begin_compound_statement:
	'{'
	{ save_statement_list(); $$ = $1; }
	;

statement_list:
	/* empty */
	| statement_list statement
	{ put_statement_list($2); }
	| statement_list declaration
	{ put_statement_list(list1(CXX_DECL,$2)); }
	| statement_list PRAGMA_EXEC
	{ put_statement_list($2); }
	| statement_list label PRAGMA_EXEC
	{ put_statement_list($2); put_statement_list($3); }
	;

statement:
	expr ';'
	{ $$ = $1; }
	| compound_statement
	| IF '(' expr ')' statement 
	{ $$ = elist3($1,IF_STATEMENT, $3, $5, NULL); }
	| IF '(' expr ')' statement ELSE statement
	{ $$ = elist3($1,IF_STATEMENT, $3, $5, $7); }
	| WHILE '(' expr ')' statement
	{ $$ = elist2($1,WHILE_STATEMENT, $3, $5); }
	| DO statement WHILE '(' expr ')' ';'
	{ $$ = elist2($1,DO_STATEMENT, $2, $5); }
	| FOR '(' expr_or_null ';' expr_or_null ';' expr_or_null ')' statement
	{ $$ = elist4($1,FOR_STATEMENT, $3, $5, $7, $9); }
	| FOR '(' type_specifier declarator '=' initializer ';' expr_or_null ';' expr_or_null ')' statement
	{ $$ = elist4($1,FOR_STATEMENT, list3(LIST,$3,$4,$6), $8, $10, $12); } /*xxx*//* C++ style */
	| SWITCH '(' expr ')' statement
	{ $$ = elist2($1,SWITCH_STATEMENT, $3, $5); }
	| BREAK	';'
	{ $$ = elist0($1,BREAK_STATEMENT); }
	| CONTINUE ';'
	{ $$ = elist0($1,CONTINUE_STATEMENT); }
	| RETURN ';'
	{ $$ = elist1($1,RETURN_STATEMENT, NULL); }
	| RETURN expr ';'
	{ $$ = elist1($1,RETURN_STATEMENT, $2); }
	| GOTO IDENTIFIER ';'
	{ $$ = elist1($1,GOTO_STATEMENT, $2); }
	| ';'
	{ $$ = NULL; }
	| error	';'
	{ $$ = NULL; }
	| error ')'
	{ $$ = NULL; }
	| label statement
	{ $$ = list2(LIST, $1, $2); }
/*	| PRAGMA_PREFIX statement PRAGMA_POSTFIX
	{ $$ = list3(LIST, $1, $2, $3); } *//* postfix is not used */
	| PRAGMA_PREFIX statement
	{ $$ = list_put_last($1, $2); }
	;

label:
	IDENTIFIER ':'
	{ $$ = elist1(EXPR_LINE($1),STATEMENT_LABEL, $1); }
	| CASE expr ':'
	{ $$ = elist1($1,CASE_LABEL, $2); }
	| DEFAULT ':'
	{ $$ = elist0($1,DEFAULT_LABEL); }
	;

/*
 * EXPRESSIONS
 */
expr_or_null:
	expr
	|	/* null */
	{ $$ = NULL; }
	;

expr_list:
	expr		%prec ','
	{ $$ = list1(LIST, $1); }
	| expr_list ','	expr
	{ $$ = list_put_last($1, $3); }
	;

expr:
	binary_expr
	| assign_expr
	| expr '?' expr ':' expr
	 { $$ = elist3($2,CONDITIONAL_EXPR, $1, $3, $5); }
	| unary_expr
	;

binary_expr:
	 expr ',' expr
	{ $$ = elist2(EXPR_LINE($1),COMMA_EXPR, $1, $3); }
	| expr LE expr
	{ $$ = elist2($2,LOG_LE_EXPR, $1, $3); }
	| expr LT expr
	{ $$ = elist2($2,LOG_LT_EXPR, $1, $3); }
	| expr GE expr
	{ $$ = elist2($2,LOG_GE_EXPR, $1, $3); }
	| expr GT expr
	{ $$ = elist2($2,LOG_GT_EXPR, $1, $3); }
	| expr '/' expr
	{ $$ = elist2($2,DIV_EXPR, $1, $3); }
	| expr '%' expr
	{ $$ = elist2($2,MOD_EXPR, $1, $3); }
	| expr '+' expr
	{ $$ = elist2($2,PLUS_EXPR, $1, $3); }
	| expr '-' expr
	{ $$ = elist2($2,MINUS_EXPR, $1, $3); }
	| expr LSHIFT expr
	{ $$ = elist2($2,LSHIFT_EXPR, $1, $3); }
	| expr RSHIFT expr
	{ $$ = elist2($2,RSHIFT_EXPR, $1, $3); }
	| expr '*' expr
	{ $$ = elist2($2,MUL_EXPR, $1, $3); }
	| expr EQEQ expr
	{ $$ = elist2($2,LOG_EQ_EXPR, $1, $3); }
	| expr NOTEQ expr
	{ $$ = elist2($2,LOG_NEQ_EXPR, $1, $3); }
	| expr '&' expr
	{ $$ = elist2($2,BIT_AND_EXPR, $1, $3); }
	| expr '|' expr
	{ $$ = elist2($2,BIT_OR_EXPR, $1, $3); }
	| expr '^' expr
	{ $$ = elist2($2,BIT_XOR_EXPR, $1, $3); }
	| expr ANDAND expr
	{ $$ = elist2($2,LOG_AND_EXPR, $1, $3); }
	| expr OROR expr
	{ $$ = elist2($2,LOG_OR_EXPR, $1, $3); }
	;

assign_expr:
	expr '=' expr
	{ $$ = elist2($2,ASSIGN_EXPR, $1, $3); }
	| expr '*' '=' expr
	{ $$ = elist2($2,ASG_MUL_EXPR, $1, $4); }
	| expr '/' '=' expr
	{ $$ = elist2($2,ASG_DIV_EXPR, $1, $4); }
	| expr '%' '=' expr
	{ $$ = elist2($2,ASG_MOD_EXPR, $1, $4); }
	| expr '+' '=' expr
	{ $$ = elist2($2,ASG_PLUS_EXPR, $1, $4); }
	| expr '-' '=' expr
	{ $$ = elist2($2,ASG_MINUS_EXPR, $1, $4); }
	| expr LSHIFT '=' expr
	{ $$ = elist2($2,ASG_LSHIFT_EXPR, $1, $4); }
	| expr RSHIFT '=' expr
	{ $$ = elist2($2,ASG_RSHIFT_EXPR, $1, $4); }
	| expr '&' '=' expr
	{ $$ = elist2($2,ASG_BIT_AND_EXPR, $1, $4); }
	| expr '|' '=' expr
	{ $$ = elist2($2,ASG_BIT_OR_EXPR, $1, $4); }
	| expr '^' '=' expr
	{ $$ = elist2($2,ASG_BIT_XOR_EXPR, $1, $4); }
	;

unary_expr:
	postfix_expr
	| '*' unary_expr		%prec UNARY	/* pointer reference */
  	{ $$ = elist1($1,POINTER_REF, $2); }
	| '&' unary_expr		%prec UNARY	/* address */
	{ $$ = elist1($1,ADDR_OF, $2); }
	| '-' unary_expr		%prec UNARY	/* unary minus */
	{ $$ = elist1($1,UNARY_MINUS_EXPR, $2); }
	| '+' unary_expr		%prec UNARY	/* unary plus */
	{ $$ = $2; }
	| '!' unary_expr		%prec UNARY	/* unary ! */
	{ $$ = elist1($1,LOG_NOT_EXPR, $2); }
	| '~' unary_expr		%prec UNARY	/* unary ~ */
	{ $$ = elist1($1,BIT_NOT_EXPR, $2); }
	| PLUSPLUS unary_expr		%prec UNARY	/* preincrement ++ */
	{ $$ = elist2($1,ASG_PLUS_EXPR, $2, constant_1); }
	| MINUSMINUS unary_expr		%prec UNARY	/* preincrement -- */
	{ $$ = elist2($1,ASG_MINUS_EXPR, $2, constant_1); }
	| '(' type_name ')' unary_expr	%prec UNARY
	{ $$ = elist2(EXPR_LINE($4),CAST_EXPR, $2, $4); }
	| SIZEOF unary_expr		%prec UNARY	/* sizeof */
	{ $$ = elist1($1,SIZE_OF_EXPR, $2); }
	| SIZEOF '(' type_name ')'	%prec UNARY_HIGH_PRIORITY
	{ $$ = elist1($1,SIZE_OF_EXPR, $3); }
	| KW_NEW type_name1              %prec UNARY
	{ $$ = elist2($1,NEW_EXPR,$2,NULL); }
	| KW_NEW type_name1 '(' ')'             %prec UNARY
	{ $$ = elist2($1,NEW_EXPR,$2,NULL); }
	| KW_NEW type_name1 '(' expr_list ')'   %prec UNARY
	{ $$ = elist2($1,NEW_EXPR,$2,$4); }
	| KW_DELETE expr               %prec UNARY
	{ $$ = elist1($1,DELETE_EXPR,$2); }
	| KW_DELETE '[' ']' expr              %prec UNARY
	{ $$ = elist1($1,DELETE_EXPR,$4); }
	;

postfix_expr:
	primary_expr
	| postfix_expr '[' expr ']'
	{ $$ = elist2(EXPR_LINE($1),ARRAY_REF, $1, $3); }
	| postfix_expr '(' expr_list ')'
	{ $$ = elist2(EXPR_LINE($1),FUNCTION_CALL, $1, $3); }
	| postfix_expr '(' ')'
	{ $$ = elist2(EXPR_LINE($1),FUNCTION_CALL, $1, NULL); }
	| postfix_expr STREF IDENTIFIER
	{ expr ex = list1(POINTER_REF, $1);	/* reference->tag_name? */
	  $$ = elist2(EXPR_LINE($1),STRUCT_REF, ex, $3); }
	| postfix_expr '.' IDENTIFIER	/* member refence . */
	{ $$ = elist2(EXPR_LINE($1),STRUCT_REF, $1, $3); }
	| postfix_expr PLUSPLUS		/* postincrement '++' */ 
	{ $$ = elist1(EXPR_LINE($1),POST_INCR_EXPR, $1); }
	| postfix_expr MINUSMINUS		/* postdecrement '--' */ 
	{ $$ = elist1(EXPR_LINE($1),POST_DECR_EXPR, $1); }
	;

primary_expr:
	IDENTIFIER
	| TYPENAME COL2 IDENTIFIER
	{ $$ = $3; } /* XXX */
	| CONSTANT
	| '(' expr ')'
	{ $$ = $2; }
	;

operators:
	  '+'{ $$ = make_enode(INT_CONSTANT, (void *)PLUS_EXPR); }
	| '-' { $$ = make_enode(INT_CONSTANT, (void *)MINUS_EXPR); }
	| '*' { $$ = make_enode(INT_CONSTANT, (void *)MUL_EXPR); }
	| '/' { $$ = make_enode(INT_CONSTANT, (void *)DIV_EXPR); }
	| '%' { $$ = make_enode(INT_CONSTANT, (void *)MOD_EXPR); }
	| '=' { $$ = make_enode(INT_CONSTANT, (void *)ASSIGN_EXPR); }
	| LE { $$ = make_enode(INT_CONSTANT, (void *)LOG_LE_EXPR); }
	| LT { $$ = make_enode(INT_CONSTANT, (void *)LOG_LT_EXPR); }
	| GT { $$ = make_enode(INT_CONSTANT, (void *)LOG_GT_EXPR); }
	| GE { $$ = make_enode(INT_CONSTANT, (void *)LOG_GE_EXPR); }
	| LSHIFT { $$ = make_enode(INT_CONSTANT, (void *)LSHIFT_EXPR); }
	| RSHIFT { $$ = make_enode(INT_CONSTANT, (void *)RSHIFT_EXPR); }
	| EQEQ { $$ = make_enode(INT_CONSTANT, (void *)LOG_EQ_EXPR); }
	|  NOTEQ { $$ = make_enode(INT_CONSTANT, (void *)LOG_NEQ_EXPR); }
	| '&' { $$ = make_enode(INT_CONSTANT, (void *)BIT_AND_EXPR); }
	| '|'{ $$ = make_enode(INT_CONSTANT, (void *)BIT_OR_EXPR); }
	| '^' { $$ = make_enode(INT_CONSTANT, (void *)BIT_XOR_EXPR); }
	| ANDAND { $$ = make_enode(INT_CONSTANT, (void *)LOG_AND_EXPR); }
	| OROR { $$ = make_enode(INT_CONSTANT, (void *)LOG_OR_EXPR); }
	| '!' { $$ = make_enode(INT_CONSTANT, (void *)LOG_NOT_EXPR); }
	| '~' { $$ = make_enode(INT_CONSTANT, (void *)BIT_NOT_EXPR); }
	| type_name1
	;

%%

#include "Cxx-lex.c"




