static char rcsid[] = "$Id: machine-dep.c,v 1.1 2002/02/06 16:05:00 msato Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* machine dependent byte size and align information */

#include "C-front.h"

#ifndef SIZEOF_UNSIGNED_LONG_LONG
#define SIZEOF_UNSIGNED_LONG_LONG (SIZEOF_UNSIGNED_INT * 2)
#endif /* !SIZEOF_UNSIGNED_LONG_LONG */

#ifndef LONGLONG_ALIGN
#define LONGLONG_ALIGN (LONG_ALIGN * 2)
#endif /* !LONGLONG_ALIGN */

/* routine for machine depedent part */
int     enum_type_size = SIZEOF_UNSIGNED_LONG/*?*/;
int     enum_type_align = SIZEOF_UNSIGNED_LONG/*?*/;
int     pointer_type_size = SIZEOF_VOID_P;
int     pointer_type_align = SIZEOF_VOID_P;
int	alignment_double = FALSE;

/* byte size information for only basic type(NOT included 'enum') */
int basic_type_size(BASIC_DATA_TYPE type)
{
    switch (type) {
    case UNDEF:
    case VOID:
	return (0);
    case CHAR:
    case UNSIGNED_CHAR:
	return (1);
    case SHORT:
    case UNSIGNED_SHORT:
	return SIZEOF_UNSIGNED_SHORT;
    case INT:
    case UNSIGNED:
    case SIGNED:
	return SIZEOF_UNSIGNED_INT;
    case LONG:
    case UNSIGNED_LONG:
	return SIZEOF_UNSIGNED_LONG;
    case LONGLONG:
    case UNSIGNED_LONGLONG:
	return SIZEOF_UNSIGNED_LONG_LONG;
    case FLOAT:
	return SIZEOF_FLOAT;
    case DOUBLE:
	return SIZEOF_DOUBLE;
    case LONG_DOUBLE:
#if defined(SIZEOF_LONG_DOUBLE)
	return SIZEOF_LONG_DOUBLE;
#else
	return sizeof(long double);
#endif /* SIZEOF_LONG_DOUBLE */
    default:
	fatal("basic_type_size");
	return 0;
    }
}

int basic_type_align(BASIC_DATA_TYPE type)
{
    switch (type) {
    case UNDEF:
    case VOID:
    case CHAR:
    case UNSIGNED_CHAR:
	/* nothing */
	return CHAR_ALIGN;
    case SHORT:
    case UNSIGNED_SHORT:
	return SHORT_ALIGN;
    case INT:
    case SIGNED:
    case UNSIGNED:
	return INT_ALIGN;
    case LONG:
    case UNSIGNED_LONG:
	return LONG_ALIGN;
    case LONGLONG:
    case UNSIGNED_LONGLONG:
#ifdef OMNI_CPU_I386
	if (alignment_double) {
# ifdef I386_LONGLONG_ALIGN2
	    return I386_LONGLONG_ALIGN2;
# else
	    return LONGLONG_ALIGN;
# endif /* I386_LONGLONG_ALIGN2 */
	} else {
	    return LONGLONG_ALIGN;
	}
#else
	return LONGLONG_ALIGN;
#endif /* OMNI_CPU_I386 */
    case FLOAT:
	return FLOAT_ALIGN;
    case DOUBLE:
#ifdef OMNI_CPU_I386
	if (alignment_double) {
# ifdef I386_DOUBLE_ALIGN2
	    return I386_DOUBLE_ALIGN2;
# else
	    return LONGLONG_ALIGN;
# endif /* I386_DOUBLE_ALIGN2 */
	} else {
	    return DOUBLE_ALIGN;
	}
#else
	return DOUBLE_ALIGN;
#endif /* OMNI_CPU_I386 */
    case LONG_DOUBLE:
#if defined(LONGDOUBLE_ALIGN)
	return LONGDOUBLE_ALIGN;
#else
	return DOUBLE_ALIGN *2;
#endif /* LONGDOUBLE_ALIGN */
    default:
	fatal("basic_type_align");
	return 0;
    }
}

