static char rcsid[] = "$Id: C-expr-misc.c,v 1.11 2000/12/15 06:07:53 m-hirano Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
#include "F-front.h"

static FILE *print_fp;

static void	expr_print_rec _ANSI_ARGS_((expr x, int l));
/* 
 * FOR DEBUG:
 */
void
expr_print(x,fp)
     expr x;
     FILE *fp;
{
    print_fp = fp;
    expr_print_rec(x,0);
    fprintf(print_fp,"\n");
}

/* tree print routine */
static void
expr_print_rec(x,l)
     expr x;
     int l;
{
    int i;
    struct list_node *lp;
    
    /* indent */
    for(i = 0; i < l; i++) fprintf(print_fp,"    ");
    
    if(x == NULL)
      {
	  /* special case */
	  fprintf(print_fp,"<NULL>");
	  return;
      }
    
    fprintf(print_fp,"(%s",EXPR_CODE_NAME(EXPR_CODE(x)));

    fprintf(print_fp,":%d",
	    (EXPR_LINE(x) != NULL) ? EXPR_LINE_NO(x) : 0);

    if(EXPR_CODE_IS_TERMINAL(EXPR_CODE(x))){
	switch(EXPR_CODE(x)){
	case IDENT:
	case TYPENAME_IDENT:
	    fprintf(print_fp," \"%s\")",SYM_NAME(EXPR_SYM(x)));
	    break;
	case STRING_CONSTANT:
	    fprintf(print_fp," \"%s\")",EXPR_STR(x));
	    return;
	case INT_CONSTANT:
	    fprintf(print_fp," %d)",EXPR_INT(x));
	    return;
	case FLOAT_CONSTANT:
	    fprintf(print_fp," %g)",EXPR_FLOAT(x));
	    return;
	case LONGLONG_CONSTANT:
	    fprintf(print_fp," 0x%x 0x%x)",
		    EXPR_LLINT_HIGH(x),EXPR_LLINT_LOW(x));
	    return;
#ifdef ENABLE_QREAL
	case QREAL_CONSTANT:
	    fprintf(print_fp, " '%s')",
		    EXPV_STR(((expv)EXPV_QREAL_CONST(x))));
	    return;
	case F_QREAL_CONSTANT:
	    fprintf(print_fp, " '%s')",
		    (char *)EXPR_GEN(x));
	    return;
#endif /* ENABLE_QREAL */
#ifdef not
	case BASIC_TYPE_NODE:
	    fprintf(print_fp," <%s>)",basic_type_name(EXPR_TYPE(x)));
	    return;
	case STORAGE_CLASS_NODE:
	    fprintf(print_fp," <%s>)",storage_class_name(EXPR_SCLASS(x)));
	    return;
	case TYPE_QUAL_NODE:
	    fprintf(print_fp," <%s>)",type_qual_name(EXPR_TYPE_QUAL(x)));
	    return;
#endif
	case ID_LIST:
	    fprintf(print_fp, " \"%s\" '%s')",
		    ID_NAME(EXPV_ANY(ID, x)),
		    storage_class_names[(int)ID_STORAGE(EXPV_ANY(ID, x))]);
	    return;
	default:
	    fprintf(print_fp," %d)",EXPR_INT(x));
	}
	return;
    }

    /* list */
    if((lp = EXPR_LIST(x)) == NULL){
	fprintf(print_fp,")");
	return;
    }
    for(/* */; lp != NULL; lp = LIST_NEXT(lp)){
	fprintf(print_fp,"\n");
	expr_print_rec(LIST_ITEM(lp),l+1);
    }
    fprintf(print_fp,")");
}

