/* 
 * $Id: F-front.h,v 1.98 2003/07/01 15:34:53 msato Exp $
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* Fortran language front-end for Omni */

#ifndef __FUNCTION_REF__
#define OMNI_FORTRAN_ENTRY_POINT      	"__Omni_FortranEntryPoint"

#include "exc_platform.h"
#ifdef ENABLE_QREAL
#include "gmp.h"
#include "omniQReal.h"
#endif /* ENABLE_QREAL */

#if !defined(SIZEOF_UNSIGNED_LONG_LONG)
#define SIZEOF_UNSIGNED_LONG_LONG	(SIZEOF_UNSIGNED_LONG * 2)
#endif /* !SIZEOF_UNSIGNED_LONG_LONG */

#define INT_BITS	(SIZEOF_UNSIGNED_INT * CHAR_BIT)
#if (SIZEOF_UNSIGNED_INT == SIZEOF_UNSIGNED_LONG)
#define LONG_AS_INT
#define INT_MASK (unsigned int)(~0)
#else
#ifdef HAS_INT64
#define INT_MASK	(((_omInt64_t)(~0)) >> INT_BITS)
#else
#define INT_MASK	((1 << INT_BITS) - 1)
#endif /* HAS_INT64 */
#endif /* SIZEOF_UNSIGNED_INT == SIZEOF_UNSIGNED_LONG */

#define TRUE	1
#define FALSE 	0

#include "C-expr.h"
#include "F-datatype.h"
#include "F-ident.h"

#include "C-OMP.h"
#include "C-TEA.h"

typedef struct {
    double r;
    double i;
} doublecomplex;

extern int lineno;
extern int need_keyword;
extern int need_type_len;

extern int doNaNCheck;
extern int doCoreDumpWhenNaN;

extern int doPedanticEquiv;
extern int doPedanticDataType;
extern int doPedanticCommon;
extern int doubleAlign;
extern int saveArray;
extern int doQCZFolding;
extern int doQRealOpt;

extern BASIC_DATA_TYPE defaultSingleRealType;
extern BASIC_DATA_TYPE defaultDoubleRealType;
extern BASIC_DATA_TYPE defaultIntType;
#ifdef ENABLE_QREAL
extern int qRealPrec;
extern int gmpLimbSize;
#endif /* ENABLE_QREAL */

extern int doImplicitUndef;

/* max nam length */
#define MAX_NAME_LEN 	30
#define MAX_DIM  7

extern unsigned long int maxStackSize;
extern int debug_flag;
extern FILE *debug_fp;
extern FILE *diag_file;

#define FILE_NAME_LEN 	125
#define MAX_N_FILES 50
#define N_NESTED_FILE 10
extern int n_files;
extern char *file_names[];
#define FILE_NAME(id) file_names[id]

extern lineno_info *current_line;
extern lineno_info *new_line_info(int f_id,int ln);
extern int get_file_id(char *name);

extern char *source_file_name,*output_file_name;
extern FILE *source_file,*output_file;

extern int	OMP_atomic_required;

/* parser states */
enum prog_state { OUTSIDE, INSIDE, INDCL, INDATA, INEXEC  };
extern enum prog_state current_state;

/* macro for parser state */
#define NOT_INDATA_YET	((int)current_state < (int)INDATA)
#define INDCL_OVER	((int)current_state >= (int)INDATA)

/* control stack codes */
enum control_type {
    CTL_NONE = 0,
    CTL_DO,
    CTL_IF,
    CTL_ELSE,
    CTL_OMP
};

/* control */
typedef struct control
{
    enum control_type ctltype;
    expv save;
    expv v1,v2;
    ID dolabel;
    SYMBOL dovar;
} CTL;

#define CTL_TYPE(l)	((l)->ctltype)
#define CTL_SAVE(l)	((l)->save)
#define CTL_BLOCK(l)	((l)->v1)

#define CTL_IF_STATEMENT(l)	((l)->v2)
#define CTL_IF_THEN(l)	(EXPR_ARG2((l)->v2))
#define CTL_IF_ELSE(l)	(EXPR_ARG3((l)->v2))

#define CTL_DO_END(l)	(EXPR_ARG2((l)->v1))
#define CTL_DO_INCR(l)	(EXPR_ARG3((l)->v1))
#define CTL_DO_BODY(l)	(EXPR_ARG4((l)->v1))
#define CTL_DO_LABEL(l)	((l)->dolabel)
#define CTL_DO_VAR(l)	((l)->dovar)

#define CTL_OMP_ARG(l)	((l)->v2)
#define CTL_OMP_ARG_DIR(l) (EXPR_INT(EXPR_ARG1((l)->v2)))
#define CTL_OMP_ARG_PCLAUSE(l) (EXPR_ARG2((l)->v2))
#define CTL_OMP_ARG_DCLAUSE(l) (EXPR_ARG3((l)->v2))

/* control stack and it pointer */
#define MAX_CTL 50
extern CTL ctls[];
extern CTL *ctl_top;

#define MAX_REPLACE_ITEMS	100

extern struct replace_item {
    ID id;
    expv v;
} replace_stack[],*replace_sp;

extern expr equiv_lists;

struct eqv_set {
    struct eqv_list *next,*parent;
    ID id;
    int high,bottom,offset;
};

#define EQV_NEXT(ep)	((ep)->next)
#define EQV_PARENT(ep)	((ep)->parent)
#define EQV_LIST(ep)	((ep)->parent)

#define EQV_ID(ep)	((ep)->id)
#define EQV_HIGH(ep)	((ep)->high)
#define EQV_LOW(ep)	((ep)->low)
#define EQV_OFFSET(ep)	((ep)->offset)

extern expr current_statements;
extern expr current_directives;

extern enum storage_class implicit_stg[26];
extern TYPE_DESC implicit_types[26];

extern ID this_label;

extern TYPE_DESC type_REAL, type_INT, type_SUBR, type_CHAR, type_LOGICAL;
extern TYPE_DESC type_DREAL, type_COMPLEX, type_DCOMPLEX, type_CHAR_POINTER;
extern TYPE_DESC type_LONGLONG;
#ifdef ENABLE_QREAL
extern TYPE_DESC type_QREAL;
#endif /* ENABLE_QREAL */
extern expv expv_constant_1,expv_constant_0,expv_constant_m1;
extern expv expv_float_0,expv_double_0;
extern SYMBOL complex_real_name,complex_img_name;

#define IS_CONSTANT(v)	\
(EXPV_CODE(v) == INT_CONSTANT || EXPV_CODE(v) == FLOAT_CONSTANT || \
 EXPV_CODE(v) == STRING_CONSTANT || EXPV_CODE(v) == LONGLONG_CONSTANT || \
 EXPV_CODE(v) == QREAL_CONSTANT)

/* current procedure */
extern int current_proc_no;
extern SYMBOL current_proc_name;
extern enum name_class current_proc_class;
extern ID current_procedure;
extern int current_blk_level;
extern expv current_return_value;
extern EXT_ID current_ext_id;

extern ID local_symbols;
extern ID local_labels;
extern expr equive_lists;

/* externl symbol */
extern EXT_ID external_symbols;

extern TYPE_DESC type_list,type_list_tail;

extern int OMP_flag;

#define EMPTY_LIST list0(LIST)


/*
 * I/O information specifiers
 */

#define IO_SPEC_UNIT	0
#define IO_SPEC_FMT	1
#define IO_SPEC_REC	2
#define IO_SPEC_IOSTAT	3
#define IO_SPEC_ERR	4
#define IO_SPEC_END	5

#define IO_SPEC_FILE	6
#define IO_SPEC_STATUS	7
#define IO_SPEC_ACCESS	8
#define IO_SPEC_FORM	9
#define IO_SPEC_RECL	10
#define IO_SPEC_BLANK	11

#define IO_SPEC_EXIST	12
#define IO_SPEC_OPENED	13
#define IO_SPEC_NUMBER	14
#define IO_SPEC_NAMED	15
#define IO_SPEC_NAME	16
#define IO_SPEC_SEQUENTIAL	17
#define IO_SPEC_DIRECT	18
#define IO_SPEC_FORMATTED	19
#define IO_SPEC_UNFORMATTED	20
#define IO_SPEC_NEXTREC	21
#define IO_SPEC_NML	22

#define IO_SPEC_UNKNOWN	23

#else
#define _ANSI_ARGS_(x) x
#   define EXC_VARARGS(type, name) (type name, ...)
#   define EXC_VARARGS_DEF(type, name) (type name, ...)
#   define EXC_VARARGS_START(type, name, list) (va_start(list, name), name)
#endif /* !__FUNCTION_REF__ */

/* 
 * prototype 
 */
extern char *	xmalloc _ANSI_ARGS_((int size));

extern void	error EXC_VARARGS(char *, fmt);
extern void	fatal EXC_VARARGS(char *, fmt);
extern void	warning EXC_VARARGS(char *, fmt);
extern void	error_at_node EXC_VARARGS(expr, x);
extern void	warning_at_node EXC_VARARGS(expr, x);

extern void	initialize_lex _ANSI_ARGS_((void));
extern void	initialize_compile _ANSI_ARGS_((void));
extern void	finalize_compile _ANSI_ARGS_((void));
extern void	initialize_compile_procedure _ANSI_ARGS_((void));

extern int	output_X_file _ANSI_ARGS_((void));

extern void	expr_print _ANSI_ARGS_((expr x, FILE *fp));

extern void	compile_statement _ANSI_ARGS_((int st_no, expr x));
extern void	output_statement _ANSI_ARGS_((expr v));
extern void	push_ctl _ANSI_ARGS_((enum control_type ctl));
extern void	pop_ctl _ANSI_ARGS_((void));
extern void	check_INDATA _ANSI_ARGS_((void));
extern void	check_INDCL _ANSI_ARGS_((void));
extern void	check_INEXEC _ANSI_ARGS_((void));
extern void 	include_file(char *name);

extern void	set_implicit_type _ANSI_ARGS_((TYPE_DESC tp, int c1, int c2));
extern void	set_implicit_storage _ANSI_ARGS_((enum storage_class stg, int c1, int c2));
extern void	output_expr_statement _ANSI_ARGS_((expr v));

extern ID	declare_label _ANSI_ARGS_((int st_no, LABEL_TYPE type, int def_flag));
extern ID	declare_variable _ANSI_ARGS_((ID id));
extern void	declare_procedure _ANSI_ARGS_((enum name_class class, expr name, TYPE_DESC type, expr args));

extern void	compile_type_decl _ANSI_ARGS_((expr type, expr decl_list));
extern void	compile_COMMON_decl _ANSI_ARGS_((expr com_list));
extern void	compile_IMPLICIT_decl _ANSI_ARGS_((expr v1,expr v2));
extern void	compile_PARAM_decl _ANSI_ARGS_((expr const_list));

extern expv	compile_logical_expression _ANSI_ARGS_((expr x));
extern void	declare_statement_function _ANSI_ARGS_((ID id, expr args, expr body));
extern expv	compile_lhs_expression _ANSI_ARGS_((expr x));
extern int	expv_is_lvalue _ANSI_ARGS_((expv v));
extern int	expv_is_str_lvalue _ANSI_ARGS_((expv v));

extern expv	compile_terminal_node _ANSI_ARGS_((expr x));
extern expv	compile_expression _ANSI_ARGS_((expr x));
extern expv	expv_assignment _ANSI_ARGS_((expv v1, expv v2));
extern expv	compile_function_call _ANSI_ARGS_((ID f_id, expr args));
extern expv	compile_args _ANSI_ARGS_((expr args, int flag));
extern expv	compile_data_args _ANSI_ARGS_((expr args));
extern expv	statement_function_call _ANSI_ARGS_((ID f_id, expv arglist));
extern TYPE_DESC	compile_dimensions _ANSI_ARGS_((TYPE_DESC tp, expr dims));
extern void 	fix_array_dimensions _ANSI_ARGS_((TYPE_DESC tp));

extern void	declare_common_variables _ANSI_ARGS_((void));
extern void	finalize_common_storage _ANSI_ARGS_((void));

extern void	print_IDs _ANSI_ARGS_((ID ip, FILE *fp));
extern void	expv_output _ANSI_ARGS_((expv x, FILE *fp));
extern expv	allocate_temp _ANSI_ARGS_((TYPE_DESC tp));
extern expv	allocate_ctemp _ANSI_ARGS_((TYPE_DESC tp));
extern expv	allocate_temp2 _ANSI_ARGS_((TYPE_DESC tp, ID *idPtr));
extern expv	allocate_auto _ANSI_ARGS_((TYPE_DESC tp));
extern expv	allocate_temp_str _ANSI_ARGS_((expv tp));
extern expv	allocate_temporary_variable _ANSI_ARGS_((TYPE_DESC tp, ID *idPtr,enum storage_class c));
extern expv	expv_char_len _ANSI_ARGS_((expv v));
extern expv	convertSubstrRefToPointerRef _ANSI_ARGS_((expv org, expv *lenVPtr));

extern ID	declare_function _ANSI_ARGS_((ID id,int is_arg));
extern ID	declare_ident _ANSI_ARGS_((SYMBOL s, enum name_class class));
extern ID	find_ident _ANSI_ARGS_((SYMBOL s));
extern SYMBOL	char_len_param_name _ANSI_ARGS_((SYMBOL s));
extern int      is_char_type _ANSI_ARGS_((TYPE_DESC tp));

extern void     initialize_intrinsic _ANSI_ARGS_((void));
extern int	is_intrinsic_function _ANSI_ARGS_((ID id));
extern expv	compile_intrinsic_call _ANSI_ARGS_((ID id,expv args));

extern EXT_ID	declare_external_proc_id _ANSI_ARGS_((SYMBOL s, TYPE_DESC tp, int def_flag));
extern EXT_ID	declare_external_id _ANSI_ARGS_((SYMBOL s, enum storage_class tag, int def_flag));
extern void	declare_storage _ANSI_ARGS_((ID id, enum storage_class stg));

extern TYPE_DESC	compile_type _ANSI_ARGS_((expr x));

extern expv	compile_int_constant _ANSI_ARGS_((expr x));

extern int	type_is_compatible _ANSI_ARGS_((TYPE_DESC tp, TYPE_DESC tq));

extern expv	expv_str_assignment _ANSI_ARGS_((expv left, expv right));
/* extern expv	expv_str_concat _ANSI_ARGS_((expv left, expv right)); */
extern expv	expv_power_expr _ANSI_ARGS_((expv left, expv right));

extern expv     expv_call_runtime _ANSI_ARGS_((char *, TYPE_DESC, expv right));

extern TYPE_DESC	max_type _ANSI_ARGS_((TYPE_DESC tp1, TYPE_DESC tp2));
extern TYPE_DESC	pointer_type _ANSI_ARGS_((TYPE_DESC tp));
extern TYPE_DESC	function_type _ANSI_ARGS_((TYPE_DESC tp));
extern TYPE_DESC	type_char _ANSI_ARGS_((int len));
extern TYPE_DESC	type_equiv _ANSI_ARGS_((void));
extern TYPE_DESC	array_element_type _ANSI_ARGS_((TYPE_DESC tp));
extern expv	array_total_size _ANSI_ARGS_((TYPE_DESC tp));

extern expv	compile_array_ref _ANSI_ARGS_((ID id, expr args));
extern expv	expv_type_conversion _ANSI_ARGS_((TYPE_DESC tp, expv v));

extern expv	expv_complex_op _ANSI_ARGS_((enum expr_code op, TYPE_DESC tp, expv left, expv right));
extern expv	expv_complex_real _ANSI_ARGS_((TYPE_DESC tp,expv v));
extern expv	expv_complex_img _ANSI_ARGS_((TYPE_DESC tp,expv v));
extern expv	expv_c_cons _ANSI_ARGS_((expv left, expv right, int doInline));
extern expv	expv_z_cons _ANSI_ARGS_((expv left, expv right, int doInline));
extern expv	expv_complex_node_to_variable _ANSI_ARGS_((expv v, TYPE_DESC tp));
extern expv	expv_complex_const_reduce _ANSI_ARGS_((expv v, TYPE_DESC tp));

extern expv	expv_reduce _ANSI_ARGS_((expv v));
extern expv	expv_float_reduce _ANSI_ARGS_((expv v));
extern expv 	expv_reduce_conv_const _ANSI_ARGS_((TYPE_DESC tp, expv v));
extern expv 	expv_inline_function _ANSI_ARGS_((expv left, expv right));
extern double	power_di _ANSI_ARGS_((double x,int n));
extern int	power_ii _ANSI_ARGS_((int x, int n));
extern void	power_zi _ANSI_ARGS_((doublecomplex *p, doublecomplex *a, int b));
extern void	power_zz _ANSI_ARGS_((doublecomplex *p, doublecomplex *a, doublecomplex *b));

extern int	basic_type_size _ANSI_ARGS_((BASIC_DATA_TYPE t));
extern int	basic_type_align _ANSI_ARGS_((BASIC_DATA_TYPE t));
extern int	type_align _ANSI_ARGS_((TYPE_DESC tp));
extern int	type_length _ANSI_ARGS_((TYPE_DESC tp));

extern char *	basic_type_name _ANSI_ARGS_((BASIC_DATA_TYPE t));
extern char *	name_class_name _ANSI_ARGS_((enum name_class c));
extern char *	proc_class_name _ANSI_ARGS_((enum proc_class c));
extern char *	storage_class_name _ANSI_ARGS_((enum storage_class c));

extern expv	expv_cons _ANSI_ARGS_((enum expr_code code, TYPE_DESC tp, expv left, expv right));
extern expv	expv_sym_term _ANSI_ARGS_((enum expr_code code, TYPE_DESC tp, SYMBOL name));
extern expv	expv_str_term _ANSI_ARGS_((enum expr_code code, TYPE_DESC tp, char *str));
extern expv	expv_int_term _ANSI_ARGS_((enum expr_code code, TYPE_DESC tp, int i));
extern expv	expv_any_term _ANSI_ARGS_((enum expr_code code, void *p));
extern expv	expv_float_term _ANSI_ARGS_((enum expr_code code, TYPE_DESC tp, double d));
#ifdef ENABLE_QREAL
extern expv	expv_qreal_term _ANSI_ARGS_((enum expr_code code, TYPE_DESC tp, expv strV));
#endif /* ENABLE_QREAL */
extern expv	expv_longlong_term _ANSI_ARGS_((enum expr_code code, TYPE_DESC tp, int h, int l));
extern expv	expv_retype _ANSI_ARGS_((TYPE_DESC tp, expv v));

extern expr	list0 _ANSI_ARGS_((enum expr_code code));
extern expr	list1 _ANSI_ARGS_((enum expr_code code, expr x1));
extern expr	list2 _ANSI_ARGS_((enum expr_code code, expr x1, expr x2));
extern expr	list3 _ANSI_ARGS_((enum expr_code code, expr x1, expr x2, expr x3));
extern expr	list4 _ANSI_ARGS_((enum expr_code code, expr x1, expr x2, expr x3, expr x4));

extern expr	expr_list_get_n _ANSI_ARGS_((expr x, int n));
extern int	expr_list_set_n _ANSI_ARGS_((expr x, int n, expr val, int doOverride));

extern expr	list_cons _ANSI_ARGS_((expr v, expr w));
extern expr	list_put_last _ANSI_ARGS_((expr lx, expr x));
extern expr	list_delete_item _ANSI_ARGS_((expr lx, expr x));

extern expr	make_enode _ANSI_ARGS_((enum expr_code code, void *v));
extern expr	make_float_enode _ANSI_ARGS_((enum expr_code code, double d));
#ifdef ENABLE_QREAL
extern expr	make_qreal_enode _ANSI_ARGS_((enum expr_code code, char *p));
#endif /* ENABLE_QREAL */
extern expr	make_longlong_enode _ANSI_ARGS_((int l, int h));

extern ID	new_ident_desc _ANSI_ARGS_((SYMBOL sp));
extern EXT_ID	new_external_id _ANSI_ARGS_((SYMBOL sp));
extern TYPE_DESC	new_type_desc _ANSI_ARGS_((void));

extern void	declare_id_type _ANSI_ARGS_((ID id, TYPE_DESC tp));

extern void	compile_FORMAT_decl _ANSI_ARGS_((int st_no, expr x));
extern void	FinalizeFormat _ANSI_ARGS_((void));

extern void	compile_DATA_decl _ANSI_ARGS_((expr x));
extern void	compile_EXTERNAL_decl _ANSI_ARGS_((expr x));

extern void	compile_IO_statement _ANSI_ARGS_((expr x));
extern void	compile_OPEN_statement _ANSI_ARGS_((expr x));
extern void	compile_CLOSE_statement _ANSI_ARGS_((expr x));
extern void	compile_FPOS_statement _ANSI_ARGS_((expr x));
extern void	compile_INQUIRE_statement _ANSI_ARGS_((expr x));
extern void	compile_NAMELIST_decl _ANSI_ARGS_((expr x));

extern void	compile_INTRINSIC_decl _ANSI_ARGS_((expr id_list));
extern void	compile_SAVE_decl _ANSI_ARGS_((expr id_list));
extern void	FinalizeCrayPointer _ANSI_ARGS_((void));
extern void	compile_cray_POINTER_decl _ANSI_ARGS_((expr x));

extern void	implicit_declaration _ANSI_ARGS_((ID id));

extern int	OMP_reduction_op _ANSI_ARGS_((expr v));
extern void	compile_OMP_directive _ANSI_ARGS_((expr x));
extern void	init_for_OMP_pragma _ANSI_ARGS_((void));
extern void	check_for_OMP_pragma _ANSI_ARGS_((expr x));
extern expv	OMP_atomic_statement _ANSI_ARGS_((expv v));
extern void	check_OMP_runtime_function _ANSI_ARGS_((ID id));
extern void	check_OMP_loop_var _ANSI_ARGS_((SYMBOL do_var_sym));

extern expv	NormalizeIoSpecifier _ANSI_ARGS_((expr x));
extern int	CheckIoSpecifierSanity _ANSI_ARGS_((expv ioList, int *ids, int n));
extern expr	GetIoSpecifierValue _ANSI_ARGS_((expv v, int id, int *specifiedPtr));
extern expv	Get_IOSTAT_Variable _ANSI_ARGS_((expv ioSpec, ID *vIdPtr));
extern ID	Get_ERRorEND_Label _ANSI_ARGS_((expv ioSpec, int type));
extern expv	GetIoSpecifierValueAsInteger _ANSI_ARGS_((expv ioSpec, int id, int doAddr,
							  int *haveItPtr));
extern expv	GetIoSpecifierValueAsIntegerVariable _ANSI_ARGS_((expv ioSpec, int id, int doAddr,
								  int *haveItPtr, ID *vIdPtr));
extern expv	GetIoSpecifierValueAsLogicalVariable _ANSI_ARGS_((expv ioSpec, int id, int doAddr,
								  int *haveItPtr, ID *vIdPtr));
extern expv	GetIoSpecifierValueAsString _ANSI_ARGS_((expv ioSpec, int id, int *haveItPtr,
							 expv *lenVPtr));
extern expv	GetIoSpecifierValueAsStringVariable _ANSI_ARGS_((expv ioSpec, int id, int *haveItPtr,
								 expv *lenVPtr, ID *vIdPtr));

extern BASIC_DATA_TYPE	getBasicType _ANSI_ARGS_((TYPE_DESC tp));
extern TYPE_DESC	getBaseType _ANSI_ARGS_((TYPE_DESC tp));

extern expv	expv_get_address _ANSI_ARGS_((expv v));

extern EXT_ID 	findCommon _ANSI_ARGS_((expr ident));
extern EXT_ID	findRuntimeExternalId _ANSI_ARGS_((SYMBOL sym));

extern int	expr_is_param _ANSI_ARGS_((expr x));
extern expv	expr_param_value _ANSI_ARGS_((expr x));
extern int	expr_is_constant _ANSI_ARGS_((expr v));
extern int	expr_is_constant_zero _ANSI_ARGS_((expr v));
extern expv	expr_constant_value _ANSI_ARGS_((expr x, int forceInt));
extern TYPE_DESC	expr_constant_type _ANSI_ARGS_((expr x));
extern int	expr_is_variable _ANSI_ARGS_((expr x, int force, ID *idPtr));
extern int	expr_is_array _ANSI_ARGS_((expr x, int force, ID *idPtr));

extern expv	id_array_dimension_list _ANSI_ARGS_((ID id));
extern expv	id_array_spec_list _ANSI_ARGS_((ID id));

extern expv	expr_array_spec_list _ANSI_ARGS_((expr x, ID *idPtr));

extern int	compute_element_offset _ANSI_ARGS_((expv aSpec, expv idxV));
extern expv	expr_array_index _ANSI_ARGS_((expr x));

extern void	InitializeEquivalence _ANSI_ARGS_((void));
extern void	FinalizeEquivalence _ANSI_ARGS_((void));
extern void	compile_EQUIVALENCE_decl _ANSI_ARGS_((expr x, int byDATAstate));

extern int	getIdOffsetInCommon _ANSI_ARGS_((EXT_ID commonId, ID id));
extern int	getProcNoFromStructRefId _ANSI_ARGS_((int refId));

extern char *	adjustString _ANSI_ARGS_((char *str, int strLen, int maxLen));

extern char *	getCommonNameFromExtId _ANSI_ARGS_((EXT_ID eid));

extern expv	ExpandImpliedDoInDATA _ANSI_ARGS_((expv spec, expv new));

extern void	compile_OMN_directive _ANSI_ARGS_((expr x));

#define BASIC_IS_INT(x) (((x) == TYPE_SHORT) || ((x) == TYPE_INT) || \
			 ((x) == TYPE_LONGLONG) || ((x) == TYPE_LOGICAL))
#define BASIC_IS_CHAR(x) ((x) == TYPE_CHAR)

#ifdef ENABLE_QREAL
#define BASIC_IS_REAL(x) (((x) == TYPE_REAL) || ((x) == TYPE_DREAL) || \
			  ((x) == TYPE_QREAL))
#else
#define BASIC_IS_REAL(x) (((x) == TYPE_REAL) || ((x) == TYPE_DREAL))
#endif /* ENABLE_QREAL */

#define BASIC_IS_COMPLEX(x) (((x) == TYPE_COMPLEX) || ((x) = TYPE_DCOMPLEX))

#define BASIC_IS_NUMERIC(x) ((BASIC_IS_INT(x)) || (BASIC_IS_REAL(x)) || \
			     (BASIC_IS_COMPLEX(x)))

#define EQUIV_NODE_ID(x)	EXPV_ANY(ID, EXPR_ARG1(x))
#define EQUIV_NODE_NAME(x)	ID_NAME(EQUIV_NODE_ID(x))
#define __Eq_Node_OffV(x)	EXPR_ARG2(x)
#define EQUIV_NODE_OFFSET(x)	EXPV_INT_VALUE(__Eq_Node_OffV(x))
#define __Eq_Node_SzV(x)	EXPR_ARG3(x)
#define EQUIV_NODE_SIZE(x)	EXPV_INT_VALUE(__Eq_Node_SzV(x))

extern void	define_entry _ANSI_ARGS_((ID id));
extern SYMBOL	gen_symbol _ANSI_ARGS_((char leader));

#ifdef HAS_INT64
extern _omInt64_t	expr_int64_value _ANSI_ARGS_((expr x));
extern void		expr_int64_save _ANSI_ARGS_((expr x, _omInt64_t i64));
#endif /* HAS_INT64 */

#ifdef ENABLE_QREAL
extern void	mpf2QR _ANSI_ARGS_((mpf_t *src, _omQReal_t *dst));
extern void	QR2mpf _ANSI_ARGS_((_omQReal_t *src, mpf_t *dst));
extern void	str2QR _ANSI_ARGS_((char *str, _omQReal_t *dst));
extern char *	mpf2str _ANSI_ARGS_((mpf_t val));
extern void	QRinit _ANSI_ARGS_ ((_omQReal_t *qPtr));
extern void	QRclean _ANSI_ARGS_ ((_omQReal_t *qPtr));
extern expv	expv_qreal_assignment _ANSI_ARGS_((expv v1, expv v2));
extern expv	expv_qreal_type_conversion _ANSI_ARGS_((TYPE_DESC tp, expv v));
extern expv	expv_qreal_const_to_qreal _ANSI_ARGS_((expv v));
extern expv	expv_qreal_const_type_conversion _ANSI_ARGS_((TYPE_DESC tp, expv v));
extern expv	expv_qreal_const_reduce _ANSI_ARGS_((expv v));

extern int	expv_const_convert_to_qreal _ANSI_ARGS_((expv v, _omQReal_t *valPtr));
extern int	expv_const_convert_to_mpf _ANSI_ARGS_((expv v, mpf_t mpV));

extern expv	expv_reduce_convTo_qreal_const _ANSI_ARGS_((TYPE_DESC tp, expv v));
extern expv	expv_reduce_convFrom_qreal_const _ANSI_ARGS_((TYPE_DESC tp, expv v));

extern expv	expv_qreal_const_DATA_initialize _ANSI_ARGS_((expv v));
#endif /* ENABLE_QREAL */
