/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* F77 parser */

%token EOS 		/* end of statement */
%token CONSTANT		/* any constant */
%token IDENTIFIER	/* name */
%token UNKNOWN
%token STATEMENT_LABEL_NO
%token TRUE_CONSTANT
%token FALSE_CONSTANT
%token KW_INTEGER
%token KW_REAL
%token KW_COMPLEX
%token KW_DOUBLE
%token KW_DCOMPLEX
%token KW_MULTI
%token KW_LOGICAL
%token KW_CHARACTER
%token KW_UNDEFINED
/* %token KW_STATIC */

/* keyword */
%token PARAMETER
/* %token PUNCH */
%token INCLUDE 
%token LET 		/* dummy */
%token ARITHIF
%token LOGIF
%token ASSIGN 
%token BLOCK
%token CALL
%token CLOSE
%token COMMON
%token CONTINUE
%token DATA
%token DIMENSION
%token DO
%token ENDDO
%token DOWHILE
%token ELSE
%token ELSEIF
%token END
%token ENDFILE
%token ENDFILE_P
%token ENDIF
%token ENTRY
%token EQUIV
%token EXTERNAL
%token FORMAT
%token FUNCTION
%token GOTO
%token ASGOTO
%token COMPGOTO
%token IMPLICIT
%token INTRINSIC
/* %token LOGICAL */
%token NAMELIST
%token PAUSE
%token PRINT
%token PROGRAM
%token READ
%token READ_P
%token RETURN
%token SAVE
%token STOP
%token SUBROUTINE
%token THEN
%token TO
%token WRITE
%token WRITE_P
%token OPEN
%token INQUIRE
%token BACKSPACE
%token BACKSPACE_P
%token REWIND
%token REWIND_P
%token POINTER

%token POWER 	/* ** */
%token CONCAT  	/* // */
%token AND 	/* .and. */
%token OR 	/* .or. */
%token NEQV 	/* .neqv. */
%token EQV 	/* .eqv. */
%token NOT	/* .not. */
%token EQ 	/* .eq. */
%token LT 	/* .lt. */
%token GT 	/* .gt. */
%token LE 	/* .le. */
%token GE 	/* .ge. */
%token NE 	/* .ne. */

/* Specify precedences and associativities. */
%left ','
%nonassoc ':'
%right '='
%left EQV NEQV
%left OR
%left AND
%left NOT
%nonassoc LT GT LE GE EQ NE
%left CONCAT
%left '+' '-'
%left '*' '/'
%right POWER

/* OpenMP directives */
%token OMPKW_LINE
%token OMPKW_PARALLEL
%token OMPKW_END
%token OMPKW_PRIVATE
%token OMPKW_SHARED
%token OMPKW_DEFAULT
%token OMPKW_NONE
%token OMPKW_FIRSTPRIVATE
%token OMPKW_REDUCTION
%token OMPKW_IF
%token OMPKW_COPYIN
%token OMPKW_DO
%token OMPKW_LASTPRIVATE
%token OMPKW_SCHEDULE
%token OMPKW_STATIC
%token OMPKW_DYNAMIC
%token OMPKW_GUIDED
%token OMPKW_ORDERED
%token OMPKW_RUNTIME
%token OMPKW_AFFINITY
%token OMPKW_SECTIONS
%token OMPKW_SECTION
%token OMPKW_NOWAIT
%token OMPKW_SINGLE
%token OMPKW_MASTER
%token OMPKW_CRITICAL
%token OMPKW_BARRIER
%token OMPKW_ATOMIC
%token OMPKW_FLUSH
%token OMPKW_THREADPRIVATE

/* omni extensions */
%token OMNKW_MAPPING
%token OMNKW_BLOCK
%token OMNKW_CYCLIC

%{
#include "F-front.h"
static int st_no;

static char *formatString = NULL;

typedef union {
    expr val;
    int code;
} yyStackType;

#define YYSTYPE yyStackType

extern void	yyerror _ANSI_ARGS_((char *s));
extern int	yylex _ANSI_ARGS_((void));
static int	yylex0 _ANSI_ARGS_((void));
static void	flush_line _ANSI_ARGS_((void));

#define GEN_NODE(TYPE, VALUE) make_enode((TYPE), ((void *)((_omAddrInt_t)(VALUE))))
#define OMP_LIST(op, args) list2(LIST, GEN_NODE(INT_CONSTANT, op), args)

%}

%type <val> statement label 
%type <val> expr /*expr1*/ lhs substring expr_or_null complex_const
%type <val> program_name dummy_arg_list dummy_args dummy_arg file_name
%type <val> declaration_statement executable_statement executable_statement1
%type <val> declaration_list type typename length_spec common_decl
%type <val> common_block external_decl intrinsic_decl equivalence_decl
%type <val> pointer_decl pointer_pair pointer_var
%type <val> equiv_list data data_list data_val_list data_val value simple_value save_list save_item const_list const_item common_var data_var data_var_list dims dim_list dim ubound label_list implicit_decl imp_list letter_group letter_groups namelist_decl namelist_entry namelist_list imp_type
%type<val>  do_spec arg arg_list
%type<val> io_statement format_spec ctl_list io_clause io_list io_item
%type <val> IDENTIFIER CONSTANT const

%type <val> omp_directive omp_nowait_option omp_clause_option omp_clause_list omp_clause omp_list omp_common_list omp_default_attr omp_copyin_list omp_schedule_arg
%type <code> omp_schedule_attr omp_reduction_op

%type <val> omni_directive map_item_list map_item map_sub_list map_sub

%start program
%%

program: /* empty */
	| program one_statement EOS
	;

one_statement:
	  STATEMENT_LABEL_NO statement
	{ compile_statement(st_no,$2);}
	| OMPKW_LINE omp_directive
	{ compile_OMP_directive($2); }
	| OMPKW_LINE omni_directive
	{ compile_OMN_directive($2); }
        | error
	{ flush_line(); yyerrok; yyclearin; }
	;

statement:	/* entry */
	  PROGRAM program_name
	  { $$ = list1(F_PROGRAM_STATEMENT,$2); }
	| BLOCK program_name
	  { $$ = list1(F_BLOCK_STATEMENT,$2); }
	| SUBROUTINE IDENTIFIER dummy_arg_list
	  { $$ = list2(F_SUBROUNTINE_STATEMENT,$2,$3); }
	| FUNCTION IDENTIFIER dummy_arg_list
	  { $$ = list3(F_FUNCTION_STATEMENT,$2,$3,NULL); }
	| type FUNCTION IDENTIFIER dummy_arg_list
	  { $$ = list3(F_FUNCTION_STATEMENT,$3,$4,$1); }
	| ENTRY IDENTIFIER dummy_arg_list
	  { $$ = list2(F_ENTRY_STATEMENT,$2,$3); }
  	| declaration_statement
  	| executable_statement
	| INCLUDE file_name
	  { $$ = list1(F_INCLUDE_STATEMENT,$2); }
	| END
	  { $$ = list0(F_END_STATEMENT); }
	| UNKNOWN
	  { error("unclassifiable statement"); flush_line(); $$ = NULL; }

label:	  CONSTANT	/* must be interger constant */
	;

program_name:	/* null */
	 { $$ = NULL; }
	| IDENTIFIER
	;

dummy_arg_list:
	{ $$ = NULL; }
	| '(' ')'
	{ $$ = NULL; }
	| '(' dummy_args ')'
	{ $$ = $2; }
	;

dummy_args:	  
	dummy_arg
	{ $$ = list1(LIST,$1); }  
	| dummy_args ',' dummy_arg
	{ $$ = list_put_last($1,$3); }
	;

dummy_arg:	  
	 IDENTIFIER
	| '*'
	{ $$ = NULL; }
	;

file_name:   
	 CONSTANT	/* must be hollerith? */
	;

declaration_statement:
	 type comma_or_null declaration_list
	{ $$ = list2(F_TYPE_DECL,$1,$3); }
	| COMMON common_decl
	{ $$ = list1(F_COMMON_DECL,$2); }
	| EXTERNAL external_decl
	{ $$ = list1(F_EXTERNAL_DECL,$2); }
	| INTRINSIC intrinsic_decl
	{ $$ = list1(F_INTRINSIC_DECL,$2); }
	| EQUIV equivalence_decl
	{ $$ = list1(F_EQUIV_DECL,$2); }
	| DATA data
	{ $$ = list1(F_DATA_DECL,$2); }
	| IMPLICIT implicit_decl
	{ $$ = list1(F_IMPLICIT_DECL,$2); }
	| NAMELIST namelist_decl
	{ $$ = list1(F_NAMELIST_DECL,$2); }
	| SAVE
	{ $$ = list1(F_SAVE_DECL,NULL); }
	| SAVE save_list
	{ $$ = list1(F_SAVE_DECL,$2); }
	| PARAMETER  '(' const_list ')'
	{ $$ = list1(F_PARAM_DECL,$3); }	
	| POINTER pointer_decl
	{ $$ = list1(F_POINTER_DECL, $2); }
	| FORMAT
	{
	    if (formatString == NULL) {
		fatal("can't get format statement as string.");
	    }
	    $$ = list1(F_FORMAT_DECL, GEN_NODE(STRING_CONSTANT, formatString));
	    formatString = NULL;
	}
  	;

declaration_list:	 
	 IDENTIFIER  dims length_spec
	{ $$ = list1(LIST,list3(LIST,$1,$2,$3)); }
	| declaration_list ',' IDENTIFIER dims length_spec
	{ $$ = list_put_last($1,list3(LIST,$3,$4,$5)); }
	;

type:	  typename length_spec
	{ $$ = list2(LIST,$1,$2); }
	;

typename:    
	  KW_INTEGER	{ $$ = GEN_NODE(F_TYPE_NODE,TYPE_INT); }
	| KW_REAL  	{ $$ = GEN_NODE(F_TYPE_NODE,TYPE_REAL); }	
	| KW_COMPLEX 	{ $$ = GEN_NODE(F_TYPE_NODE,TYPE_COMPLEX); }
	| KW_DOUBLE 	{ $$ = GEN_NODE(F_TYPE_NODE,TYPE_DREAL); }
	| KW_DCOMPLEX 	{ $$ = GEN_NODE(F_TYPE_NODE,TYPE_DCOMPLEX); }
	| KW_MULTI	{ $$ = GEN_NODE(F_TYPE_NODE,TYPE_QREAL); }
	| KW_LOGICAL 	{ $$ = GEN_NODE(F_TYPE_NODE,TYPE_LOGICAL); }
	| KW_CHARACTER 	{ $$ = GEN_NODE(F_TYPE_NODE,TYPE_CHAR); }
	| KW_UNDEFINED	{ $$ = GEN_NODE(F_TYPE_NODE,TYPE_UNKNOWN); }
	| DIMENSION	{ $$ = NULL; }
	;

length_spec:	/* nothing */
	{ $$ = NULL; }
	| length_spec_mark  expr
	{ $$ = $2; }
	| length_spec_mark '(' '*' ')' 
	{ $$ = list0(LIST); }
	;

length_spec_mark:
	'*' { need_type_len = TRUE; }
  	;

common_decl:	  
  	  common_var
	{ $$ = list2(LIST, NULL, $1); } 
	| common_block common_var
	{ $$ = list2(LIST,$1,$2); } 
	| common_decl comma_or_null common_block comma_or_null common_var
	{ $$ = list_put_last(list_put_last($1,$3),$5); }
	| common_decl ',' common_var
	{ $$ = list_put_last($1,$3); }
	;

common_block:  CONCAT /* // */
	{ $$ = NULL; }
	| '/' IDENTIFIER '/'
	{ $$ = $2; }
	;

common_var:  IDENTIFIER dims
	{ $$ = list2(LIST,$1,$2); }
	;

external_decl: IDENTIFIER
	{ $$ = list1(LIST,$1); }
	| external_decl ',' IDENTIFIER
	{ $$ = list_put_last($1,$3); }
	;

intrinsic_decl:  IDENTIFIER
	{ $$ = list1(LIST,$1); }
	| intrinsic_decl ',' IDENTIFIER
	{ $$ = list_put_last($1,$3); }
	;

equivalence_decl:    
	  '(' equiv_list ')'
	{ $$ = list1(LIST,$2); }
	| equivalence_decl ',' '(' equiv_list ')'
	{ $$ = list_put_last($1,$4); }
	;

equiv_list:  
	  lhs
	{ $$ = list1(LIST,$1); }
	| equiv_list ',' lhs
	{ $$ = list_put_last($1,$3); }
	;

pointer_decl:
	pointer_pair
	{ $$ = list1(LIST, $1); }
	| pointer_decl ',' pointer_pair
	{ $$ = list_put_last($1, $3); }
	;

pointer_pair:
	'(' lhs ',' pointer_var ')'
	{ $$ = list2(LIST, $2, $4); }
	;

pointer_var:
	IDENTIFIER
	{ $$ = $1; }
	| common_var
	{ $$ = list2(F_ARRAY_REF, EXPR_ARG1($1), EXPR_ARG2($1)); }
	;

data:	  data_list
	{ $$ = list1(LIST,$1); }
	| data comma_or_null data_list
	{ $$ = list_put_last($1,$3); }
	;

data_list:  data_var_list '/' data_val_list '/'
	{ $$ = list2(LIST,$1,$3); }
	;

data_val_list:  data_val
	{ $$ = list1(LIST,$1); }
	| data_val_list ',' data_val
	{ $$ = list_put_last($1,$3); }
	;

data_val: value
  	| simple_value '*' value
	{ $$ = list2(F_DUP_DECL,$1,$3); }
	;

value: simple_value
	| '+' simple_value
	{ $$ = $2;}
	| '-' simple_value
	{ $$ = list1(F_UNARY_MINUS_EXPR,$2); }
	;

simple_value: 
	IDENTIFIER
	| const
	| complex_const
	;

save_list: save_item
	{ $$ = list1(LIST,$1); }
	| save_list ',' save_item
	{ $$ = list_put_last($1,$3); }
	;

save_item: IDENTIFIER
	| common_block
	{ $$ = list1(LIST,$1); } /* for identify common block name */
	;

const_list:  const_item
	{ $$ = list1(LIST,$1); }
	| const_list ',' const_item
	{ $$ = list_put_last($1,$3); }
	;

const_item:  IDENTIFIER '=' expr
	{ $$ = list2(LIST,$1,$3); }
	;


data_var_list: data_var
	{ $$ = list1(LIST,$1); }
	| data_var_list ',' data_var
	{ $$ = list_put_last($1,$3); }
	;

data_var:	  lhs
	| '(' data_var_list ',' do_spec ')'
	{ $$ = list2(F_IMPLIED_DO, $4, $2); }
	;

dims:
	{ $$ = NULL; }
	| '(' dim_list ')'
	{ $$ = $2; }
	;

dim_list:  dim
	{ $$ = list1(LIST,$1); }
	| dim_list ',' dim
	{ $$ = list_put_last($1,$3); }
	;

dim:	  ubound
	| expr ':' ubound
	{ $$ = list2(LIST,$1,$3); }
	;

ubound:	  '*'
	{ $$ = NULL; }
	| expr
	;

label_list: label
	{ $$ = list1(LIST,$1); }
	| label_list ',' label
	{ $$ = list_put_last($1,$3); }
	;

implicit_decl:    imp_list
	{ $$ = list1(LIST,$1); }
	| implicit_decl ',' imp_list
	{ $$ = list_put_last($1,$3); }
	;

imp_list:  imp_type '(' letter_groups ')'
	{ $$ = list2(LIST,$1,$3); }
	|  imp_type
	{ $$ = list2(LIST,$1,NULL); }
	;

imp_type: { need_keyword = TRUE; } type
	{ $$ = $2; }
	;

letter_groups: letter_group
	{ $$ = list1(LIST,$1); }
	| letter_groups ',' letter_group
	{ $$ = list_put_last($1,$3); }
	;

letter_group:  IDENTIFIER
	| IDENTIFIER '-' IDENTIFIER
	{ $$ = list2(LIST,$1,$3); }
	;

namelist_decl:        namelist_entry
	{ $$ = list1(LIST,$1); }
	| namelist_decl namelist_entry
	{ $$ = list_put_last($1,$2); }
	;

namelist_entry:  '/' IDENTIFIER '/' namelist_list
	{ $$ = list2(LIST,$2,$4); }
	;

namelist_list:  IDENTIFIER
	{ $$ = list1(LIST, $1); }
	| namelist_list ',' IDENTIFIER
	{ $$ = list_put_last($1,$3); }
	;

/*
 * executable statement
 */

executable_statement:	  
  	  executable_statement1
	| DO label do_spec
	{ $$ = list2(F_DO_STATEMENT,$2,$3); }
        | DO label ',' do_spec  /* for dusty deck */
	{ $$ = list2(F_DO_STATEMENT,$2,$4); }
	| DO do_spec
	{ $$ = list2(F_DO_STATEMENT,NULL,$2); }
	| ENDDO
	{ $$ = list0(F_ENDDO_STATEMENT); }
	| LOGIF '(' expr ')' executable_statement1
	{ $$ = list2(F_IF_STATEMENT,$3,$5); }
	| LOGIF '(' expr ')' THEN
	{ $$ = list2(F_IF_STATEMENT,$3,NULL); }
	| ELSEIF  '(' expr ')' THEN
	{ $$ = list1(F_ELSEIF_STATEMENT,$3); }
	| ELSE 
	{ $$ = list0(F_ELSE_STATEMENT); }
	| ENDIF 
	{ $$ = list0(F_ENDIF_STATEMENT); }
        | DOWHILE '(' expr ')'
        { $$ = list1(F_DOWHILE_STATEMENT,$3); }
  	;

do_spec:
	  IDENTIFIER '=' expr ',' expr
	{ $$ = list4(LIST,$1,$3,$5,NULL); }
	|  IDENTIFIER '=' expr ',' expr ',' expr
	{ $$ = list4(LIST,$1,$3,$5,$7); }
	;

/* 'ifable' statement */
executable_statement1:
  	  LET lhs '=' expr
	{ $$ = list2(F_LET_STATEMENT,$2,$4); }
	| ASSIGN  label TO IDENTIFIER
	{ $$ = list2(F_ASSIGN_STATEMENT,$2,$4); }
	| CONTINUE 
	{ $$ = list0(F_CONTINUE_STATEMENT); }
  	| GOTO  label
	{ $$ = list1(F_GOTO_STATEMENT,$2); } 
	| ASGOTO  IDENTIFIER
	{ $$ = list2(F_ASGOTO_STATEMENT,$2,NULL); }
	| ASGOTO  IDENTIFIER comma_or_null '(' label_list ')'
	{ $$ = list2(F_ASGOTO_STATEMENT,$2,$5); }
	| COMPGOTO  '(' label_list ')' comma_or_null expr
	{ $$ = list2(F_COMPGOTO_STATEMENT,$3,$6); }
	| ARITHIF  '(' expr ')' label ',' label ',' label
	{ $$ = list4(F_ARITHIF_STATEMENT,$3,$5,$7,$9); }
	| CALL IDENTIFIER
	{ $$ = list2(F_CALL_STATEMENT,$2,NULL); }
	| CALL IDENTIFIER '(' ')'
	{ $$ = list2(F_CALL_STATEMENT,$2,NULL); }
	| CALL IDENTIFIER '(' arg_list ')'
	{ $$ = list2(F_CALL_STATEMENT,$2,$4); }
	| RETURN  expr_or_null
	{ $$ = list1(F_RETURN_STATEMENT,$2); }
	| PAUSE  expr_or_null
	{ $$ = list1(F_PAUSE_STATEMENT,$2); }
	| STOP  expr_or_null
	{ $$ = list1(F_STOP_STATEMENT,$2); }
	| io_statement
	;

comma_or_null:
	| ','
	;

/* actual argument */
arg_list:  
	{  $$ = NULL; }	
	| arg
	{ $$ = list1(LIST,$1); }
	| arg_list ',' arg
	{ $$ = list_put_last($1,$3); }
	;

arg:
	 expr
	| '*' label
	 { $$ = list1(F_LABEL_REF,$2); }
	;

/*
 * Input/Output Statements 
 */
io_statement:
	  PRINT format_spec
	{ $$ = list2(F_PRINT_STATEMENT,$2,NULL); }
	| PRINT format_spec ',' io_list
	{ $$ = list2(F_PRINT_STATEMENT,$2,$4); }
	| WRITE_P ctl_list ')'
	{ $$ = list2(F_WRITE_STATEMENT,$2,NULL); }
	| WRITE_P ctl_list ')' io_list
	{ $$ = list2(F_WRITE_STATEMENT,$2,$4); }
	| READ_P ctl_list ')'
	{ $$ = list2(F_READ_STATEMENT,$2,NULL); }
	| READ_P ctl_list ')' io_list
	{ $$ = list2(F_READ_STATEMENT,$2,$4); }
	| READ format_spec
	{ $$ = list2(F_READ1_STATEMENT,$2,NULL); }
	| READ format_spec ',' io_list
	{ $$ = list2(F_READ1_STATEMENT,$2,$4); }
	| OPEN '(' ctl_list ')'
	{ $$ = list1(F_OPEN_STATEMENT,$3); }
	| CLOSE '(' ctl_list ')'
	{ $$ = list1(F_CLOSE_STATEMENT,$3); }
	| BACKSPACE_P ctl_list ')'
	{ $$ = list1(F_BACKSPACE_STATEMENT,$2); }
	| BACKSPACE format_spec
	{ $$ = list1(F_BACKSPACE_STATEMENT,$2); }
	| ENDFILE_P ctl_list ')'
	{ $$ = list1(F_ENDFILE_STATEMENT,$2); }
	| ENDFILE format_spec
	{ $$ = list1(F_ENDFILE_STATEMENT,$2); }
	| REWIND_P ctl_list ')'
	{ $$ = list1(F_REWIND_STATEMENT,$2); }
	| REWIND format_spec
	{ $$ = list1(F_REWIND_STATEMENT,$2); }
	| INQUIRE '(' ctl_list ')'
	{ $$ = list1(F_INQUIRE_STATEMENT,$3); }
	;

ctl_list: io_clause
	{ $$ = list1(LIST,$1); }
	| ctl_list ',' io_clause 
	{ $$ = list_put_last($1,$3); }
	;

io_clause: 
	 expr
	|  '*'
	{ $$ = NULL; }
	| POWER /* ** */
	{ $$ = list0(F_STARSTAR); }
	| IDENTIFIER '=' expr
	{ $$ = list2(F_SET_EXPR,$1,$3); }
	| IDENTIFIER '=' '*'
	{ $$ = list2(F_SET_EXPR,$1,NULL); }
	| IDENTIFIER '=' POWER
	{ $$ = list2(F_SET_EXPR,$1,list0(F_STARSTAR)); }
	;

format_spec:
	  '*'
	{ $$ = NULL; }
	| expr
	;

io_list: io_item
	{ $$ = list1(LIST,$1); }
	| io_list ',' io_item
	{ $$ = list_put_last($1,$3); }
	;

io_item:  
	  expr
	| '(' expr ',' io_list ')'
	{ $$ = list_cons($2,$4); }
	| '(' expr ',' do_spec ')'
	{ $$ = list2(F_IMPLIED_DO,$4,list1(LIST,$2)); }
	| '(' expr ',' io_list ',' do_spec ')'
	{ $$ = list2(F_IMPLIED_DO,$6,list_cons($2,$4)); }
	| '(' io_list ',' do_spec ')'
	{ $$ = list2(F_IMPLIED_DO,$4,$2); }
	;

expr:	  lhs
	| '(' expr ')'	
	{ $$ = $2; }
	| complex_const
        | const
	| expr '+' expr   %prec '+'
	{ $$ = list2(F_PLUS_EXPR,$1,$3); }
	| expr '-' expr   %prec '+'
	{ $$ = list2(F_MINUS_EXPR,$1,$3); }
	| expr '*' expr
	{ $$ = list2(F_MUL_EXPR,$1,$3); }
	| expr '/' expr
	{ $$ = list2(F_DIV_EXPR,$1,$3); }
	| expr POWER expr
	{ $$ = list2(F_POWER_EXPR,$1,$3); }
	| '+' expr  %prec '*'
	{ $$ = $2; }
	| '-' expr  %prec '*'
	{ $$ = list1(F_UNARY_MINUS_EXPR,$2); }
	| expr EQ expr  %prec EQ
	{ $$ = list2(F_EQ_EXPR,$1,$3); }
	| expr GT expr  %prec EQ
	{ $$ = list2(F_GT_EXPR,$1,$3); }
	| expr LT expr  %prec EQ
	{ $$ = list2(F_LT_EXPR,$1,$3); }
	| expr GE expr  %prec EQ
	{ $$ = list2(F_GE_EXPR,$1,$3); }
	| expr LE expr  %prec EQ
	{ $$ = list2(F_LE_EXPR,$1,$3); }
	| expr NE expr  %prec EQ
	{ $$ = list2(F_NE_EXPR,$1,$3); }
	| expr EQV expr
	{ $$ = list2(F_EQV_EXPR,$1,$3); }
	| expr NEQV expr
	{ $$ = list2(F_NEQV_EXPR,$1,$3); }
	| expr OR expr
	{ $$ = list2(F_OR_EXPR,$1,$3); }
	| expr AND expr
	{ $$ = list2(F_AND_EXPR,$1,$3); }
	| NOT expr
	{ $$ = list1(F_NOT_EXPR,$2); }
	| expr CONCAT expr
	{ $$ = list2(F_CONCAT_EXPR,$1,$3); }
	;

lhs:	 
	 IDENTIFIER
	| IDENTIFIER substring
	{ $$ = list2(F_SUBSTR_REF,$1,$2); }
	| IDENTIFIER '(' arg_list ')'
	{ $$ = list2(F_ARRAY_REF,$1,$3); }
	| IDENTIFIER '(' arg_list ')' substring
	{ $$ = list2(F_SUBSTR_REF,list2(F_ARRAY_REF,$1,$3),$5); }
	;

substring:  '(' expr_or_null ':' expr_or_null ')'
	{ $$ = list2(LIST,$2,$4); }
	;

expr_or_null:
	{ $$ = NULL; }
	| expr
	;

const:	  CONSTANT
	| TRUE_CONSTANT
	{ $$ = list0(F_TRUE_CONSTANT); }
	| FALSE_CONSTANT
	{ $$ = list0(F_FALSE_CONSTANT); }
	;

complex_const:  '(' expr ',' expr ')'
	{ $$ = list2(F_COMPLEX_CONSTANT,$2,$4); }
	| '(' '*' ',' expr ')'
	{ $$ = list2(F_COMPLEX_CONSTANT,NULL,$4); }
	| '(' expr ',' '*' ')'
	{ $$ = list2(F_COMPLEX_CONSTANT,$2,NULL); }
	;

/* 
 * OpenMP directives 
 */
omp_directive:
	  OMPKW_PARALLEL omp_clause_option
	  { $$ = OMP_LIST(OMP_F_PARALLEL,$2); }
	| OMPKW_END OMPKW_PARALLEL
	  { $$ = OMP_LIST(OMP_F_END_PARALLEL,NULL); }
	| OMPKW_DO omp_clause_option
	  { $$ = OMP_LIST(OMP_F_DO,$2); }
	| OMPKW_END OMPKW_DO omp_nowait_option
	  { $$ = OMP_LIST(OMP_F_END_DO,$3); }
	| OMPKW_PARALLEL OMPKW_DO omp_clause_option
	  { $$ = OMP_LIST(OMP_F_PARALLEL_DO,$3); }
	| OMPKW_END OMPKW_PARALLEL OMPKW_DO omp_nowait_option
	  { $$ = OMP_LIST(OMP_F_END_PARALLEL_DO,$4); }
	| OMPKW_SECTIONS omp_clause_option
	  { $$ = OMP_LIST(OMP_F_SECTIONS,$2); }
	| OMPKW_END OMPKW_SECTIONS omp_nowait_option
	  { $$ = OMP_LIST(OMP_F_END_SECTIONS,$3); }
	| OMPKW_PARALLEL OMPKW_SECTIONS omp_clause_option
	  { $$ = OMP_LIST(OMP_F_PARALLEL_SECTIONS,$3); }
	| OMPKW_END OMPKW_PARALLEL OMPKW_SECTIONS omp_nowait_option
	  { $$ = OMP_LIST(OMP_F_END_PARALLEL_SECTIONS,$4); }
	| OMPKW_SECTION
	  { $$ = OMP_LIST(OMP_F_SECTION,NULL); }
	| OMPKW_SINGLE omp_clause_option
	  { $$ = OMP_LIST(OMP_F_SINGLE,$2); }
	| OMPKW_END OMPKW_SINGLE omp_nowait_option
	  { $$ = OMP_LIST(OMP_F_END_SINGLE,$3); }
	| OMPKW_MASTER
	  { $$ = OMP_LIST(OMP_F_MASTER,NULL); }
	| OMPKW_END OMPKW_MASTER
	  { $$ = OMP_LIST(OMP_F_END_MASTER,NULL); }
	| OMPKW_CRITICAL
	  { $$ = OMP_LIST(OMP_F_CRITICAL,NULL); }
	| OMPKW_END OMPKW_CRITICAL
	  { $$ = OMP_LIST(OMP_F_END_CRITICAL,NULL); }
	| OMPKW_CRITICAL '(' IDENTIFIER ')'
	  { $$ = OMP_LIST(OMP_F_CRITICAL,list1(LIST,$3)); }
	| OMPKW_END OMPKW_CRITICAL '(' IDENTIFIER ')'
	  { $$ = OMP_LIST(OMP_F_END_CRITICAL,list1(LIST,$4)); }
	| OMPKW_BARRIER
	  { $$ = OMP_LIST(OMP_F_BARRIER,NULL); }
	| OMPKW_ATOMIC
	  { $$ = OMP_LIST(OMP_F_ATOMIC,NULL); }
	| OMPKW_FLUSH
	  { $$ = OMP_LIST(OMP_F_FLUSH,NULL); }
	| OMPKW_FLUSH '(' omp_list ')'
	  { $$ = OMP_LIST(OMP_F_FLUSH,$3); }
	| OMPKW_ORDERED
	  { $$ = OMP_LIST(OMP_F_ORDERED,NULL); }
	| OMPKW_END OMPKW_ORDERED
	  { $$ = OMP_LIST(OMP_F_END_ORDERED,NULL); }
	| OMPKW_THREADPRIVATE '(' omp_common_list ')'
	  { $$ = OMP_LIST(OMP_F_THREADPRIVATE,$3); }
	;

omp_nowait_option:
	{ $$ = NULL; }
	| OMPKW_NOWAIT
	{ $$ = OMP_LIST(OMP_DIR_NOWAIT,NULL); }
	;

omp_clause_option:
	{ $$ = NULL; }
	| omp_clause_list
	;

omp_clause_list:
	  omp_clause
	 { $$ = list1(LIST,$1); }
	| omp_clause_list ',' omp_clause
	 { $$ = list_put_last($1,$3); }
	| omp_clause_list omp_clause
	 { $$ = list_put_last($1,$2); }
	;

omp_clause: 
	  OMPKW_PRIVATE '(' omp_list ')'
	  { $$ = OMP_LIST(OMP_DATA_PRIVATE,$3); }
	| OMPKW_SHARED '(' omp_list ')'
	  { $$ = OMP_LIST(OMP_DATA_SHARED,$3); }
	| OMPKW_DEFAULT '(' { need_keyword = TRUE; } omp_default_attr ')'
	  { $$ = OMP_LIST(OMP_DATA_DEFAULT,$4); }
	| OMPKW_FIRSTPRIVATE '(' omp_list ')'
	  { $$ = OMP_LIST(OMP_DATA_FIRSTPRIVATE,$3); }
	| OMPKW_LASTPRIVATE '(' omp_list ')'
	  { $$ = OMP_LIST(OMP_DATA_LASTPRIVATE,$3); }
	| OMPKW_COPYIN '(' omp_copyin_list ')'
	  { $$ = OMP_LIST(OMP_DATA_COPYIN,$3); }
	| OMPKW_REDUCTION '(' omp_reduction_op ':' omp_list ')'
	  { $$ = OMP_LIST($3,$5); }
	| OMPKW_IF '(' expr ')'
	  { $$ = OMP_LIST(OMP_DIR_IF,$3); }
	| OMPKW_SCHEDULE '(' { need_keyword = TRUE; } omp_schedule_arg ')'
	  { $$ = $4; }
	| OMPKW_ORDERED
	  { $$ = OMP_LIST(OMP_DIR_ORDERED,NULL); }
	;

omp_reduction_op:
	  '+' { $$ = (int) OMP_DATA_REDUCTION_PLUS; }
	| '-' { $$ = (int) OMP_DATA_REDUCTION_MINUS; }
	| '*' { $$ = (int) OMP_DATA_REDUCTION_MUL; }
	| AND { $$ = (int) OMP_DATA_REDUCTION_LOGAND; }
	| OR  { $$ = (int) OMP_DATA_REDUCTION_LOGOR; }
	| EQV { $$ = (int) OMP_DATA_REDUCTION_EQV; }
	| NEQV { $$ = (int) OMP_DATA_REDUCTION_NEQV; }
	| IDENTIFIER { $$ = OMP_reduction_op($1); }
	;

omp_list:
	  IDENTIFIER
	  { $$ = list1(LIST,$1); }
	| omp_list ',' IDENTIFIER
	  { $$ = list_put_last($1,$3); }
	;

omp_common_list:
	  '/' IDENTIFIER '/'
	 { $$ = list1(LIST,list1(LIST,$2)); }
	| omp_common_list ',' '/' IDENTIFIER '/'
	 { $$ = list_put_last($1,list1(LIST,$4)); }
	;

omp_copyin_list:
	  IDENTIFIER
	  { $$ = list1(LIST,$1); }
	| omp_copyin_list ',' IDENTIFIER
	  { $$ = list_put_last($1,$3); }
	| '/' IDENTIFIER '/'
	 { $$ = list1(LIST,list1(LIST,$2)); }
	| omp_copyin_list ',' '/' IDENTIFIER '/'
	 { $$ = list_put_last($1,list1(LIST,$4)); }
	;

omp_schedule_arg:
	  omp_schedule_attr 
	  { $$ = OMP_LIST(OMP_DIR_SCHEDULE,OMP_LIST($1,NULL)); }
	| omp_schedule_attr ',' expr 
	  { $$ = OMP_LIST(OMP_DIR_SCHEDULE,OMP_LIST($1,$3)); }
	| OMPKW_AFFINITY ',' map_item
	  { $$ = OMP_LIST(OMP_DIR_SCHEDULE,
			  OMP_LIST((int) OMP_SCHED_AFFINITY,$3)); }
	;

omp_schedule_attr:
	  OMPKW_STATIC { $$ = (int) OMP_SCHED_STATIC; }
	| OMPKW_DYNAMIC { $$ = (int) OMP_SCHED_DYNAMIC; }
	| OMPKW_GUIDED  { $$ = (int) OMP_SCHED_GUIDED; }
	| OMPKW_RUNTIME { $$ = (int) OMP_SCHED_RUNTIME; }
	;

omp_default_attr:
	  OMPKW_SHARED { $$ = OMP_LIST(OMP_DEFAULT_SHARED,NULL); }
	| OMPKW_PRIVATE { $$ = OMP_LIST(OMP_DEFAULT_PRIVATE,NULL); }
	| OMPKW_NONE { $$ = $$ = OMP_LIST(OMP_DEFAULT_NONE,NULL); }
	;

/* 
 * OMNI/TEA extensions 
 */
omni_directive:
	  OMNKW_MAPPING '(' map_item_list ')'
         { $$ = OMP_LIST(TEA_DATAMAP,list2(LIST,$3,NULL)); }
	| OMNKW_MAPPING '(' map_item_list ':' map_item ')'
	 { $$ = OMP_LIST(TEA_DATAMAP,list2(LIST,$3,$5)); }
	;

map_item_list:
	  map_item
	  { $$ = list1(LIST,$1); }  
	| map_item_list ',' map_item
	  { $$ = list_put_last($1,$3); }
	; 
map_item:
	  IDENTIFIER
	 { $$ = list2(LIST,$1,NULL); }
	| IDENTIFIER '(' map_sub_list ')'
	 { $$ = list2(LIST,$1,$3); }
	;

map_sub_list:
	  { need_keyword = TRUE; } map_sub
	  { $$ = list1(LIST,$2); }  
	| map_sub_list ',' { need_keyword = TRUE; } map_sub
	  { $$ = list_cons($4,$1); /* reverse order */ }
	;

map_sub: 
	  '*'
	  { $$ = NULL; }
	| OMNKW_BLOCK 
	  { $$ = OMP_LIST(TEA_MAP_BLOCK,NULL); }
	| OMNKW_BLOCK '(' expr ')'
	  { $$ = OMP_LIST(TEA_MAP_BLOCK,$3); }
	| OMNKW_CYCLIC
	  { $$ = OMP_LIST(TEA_MAP_CYCLIC,NULL); }
	| OMNKW_CYCLIC '(' expr ')'
	  { $$ = OMP_LIST(TEA_MAP_CYCLIC,$3); }
	|  expr
	  { $$ = OMP_LIST(TEA_MAP_EXPR,$1); }
	;

%%
#include "F-lex.c"

/* EOF */
