// $Id: BasicBlockIterator.java,v 1.5 2000/04/10 04:10:21 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.block;

import exc.object.*;
import java.util.Vector;

//
// BasicBlock iterator, traverse in toplogical sort order
//
public class BasicBlockIterator implements BasicBlockVisitor {
  Vector bblocks;
  BasicBlock currentBlock;
  int index;

  public BasicBlockIterator(Block b){
    init(b);
  }

  public BasicBlockIterator(BlockList body){
    init(body);
  }

  public void init() { 
    index = 0; 
    if(bblocks.size() > 0)
      currentBlock = (BasicBlock)bblocks.elementAt(0);
  }

  public void init(Block b){
    bblocks = new Vector();
    visit(b);
    index = 0; 
    if(bblocks.size() > 0) 
      currentBlock = (BasicBlock)bblocks.elementAt(0);
  }

  public void init(BlockList body){
    bblocks = new Vector();
    visit(body);
    index = 0; 
    if(bblocks.size() > 0) 
      currentBlock = (BasicBlock)bblocks.elementAt(0);
  }

  public void visit(Block b){
    BasicBlock bb;
    if(b == null) return;
    b.visitBasicBlock(this);
    b.visitBody(this);
  }

  public void visit(BasicBlock bb){
    if(bb != null) bblocks.addElement((Object)bb);
  }

  public void visit(BlockList b_list){
    if(b_list == null) return;
    for(Block b = b_list.getHead(); b != null; b = b.getNext()){
      visit(b);
    }
  }

  public void next(){ 
    if(++index >= bblocks.size()) currentBlock = null;
    else currentBlock =(BasicBlock)bblocks.elementAt(index); 
  }
  public boolean end(){ return index == bblocks.size(); }
  public int size() { return bblocks.size(); }

  // return current block
  public BasicBlock getBasicBlock(){  return currentBlock; }
}

