// $Id: BlockIterator.java,v 1.3 2000/04/10 04:10:22 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.block;

import exc.object.*;

//
// super class for Block iterator 
//
public abstract class BlockIterator {
  Block currentBlock;

  public BlockIterator(Block b){
    currentBlock = b;	// set defaults
  }
  
  public BlockIterator(BlockList body){
    // nothing
  }

  public abstract void init();
  public abstract void init(Block b);
  public abstract void next();
  public abstract boolean end();
  public abstract int size();
    
  // return current block
  public Block getBlock(){  return currentBlock; }

  // replace block 
  public void setBlock(Block b){ currentBlock.replace(b); }
}

