// $Id: CompoundBlock.java,v 1.6 2000/04/10 04:10:22 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.block;
import exc.object.*;

//
// compound block, COMPOUND_STATEMENT
// 
public class CompoundBlock extends Block {
  BlockList body;

  public CompoundBlock(BlockList body){
    super(Xcode.COMPOUND_STATEMENT,null);
    this.body = body;
    if(body != null) body.parent = this;
  }

  public CompoundBlock(int code, BlockList body){
    super(code,null);
    this.body = body;
    if(body != null) body.parent = this;
  }

  public CompoundBlock(CompoundBlock b){
    super(b);
    if(b.body != null) this.body = b.body.copy();
  }

  public Block copy() { return new CompoundBlock(this); }

  public BlockList getBody() { return body; }
  public void setBody(BlockList s){
    body = s;
    s.parent = this;
  }

  public Xobject toXobject(){
    if(body == null) return null;
    Xobject x = body.toXobject();
    if(x != null) x.setLineNo(getLineNo());
    return x;
  }
}



