// $Id: CondBlock.java,v 1.4 2000/04/10 04:10:22 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.block;
import exc.object.*;

//
// Block, which has one condition and body
//   WHIILE_STATEMENT, DO_STATEMENT, SWITCH_STATEMENT
//
public class CondBlock extends Block {
  BlockList body;

  public CondBlock(int code,BasicBlock cond, BlockList body){
    super(code,cond);
    this.body = body;
    body.parent = this;
  }

  public CondBlock(CondBlock b){
    super(b);
    body = b.body.copy();
    body.parent = this;
  }
  
  public Block copy() { return new CondBlock(this); }
  
  public BlockList getBody() { return body; }
  public void setBody(BlockList s){
    body = s;
    s.parent = this;
  }

  public BasicBlock getCondBBlock() { return bblock; }
  public void setCondBBlock(BasicBlock bb) { 
    bblock = bb; 
    bb.parent = this;
  }

  public Xobject toXobject(){
    Xobject x;
    Xobject cond_x = null;
    if(bblock != null) cond_x = bblock.toXobject();
    if(code == Xcode.DO_STATEMENT)
      x = new XobjList(code,body.toXobject(),cond_x);
    else
      x = new XobjList(code,cond_x,body.toXobject());
    x.setLineNo(getLineNo());
    return x;
  }
}


