// $Id: IfBlock.java,v 1.5 2000/04/10 04:10:22 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.block;

import exc.object.*;

public class IfBlock extends Block {
  BlockList then_part;
  BlockList else_part;

  public IfBlock(BasicBlock cond,
		 BlockList then_part,BlockList else_part){
    super(Xcode.IF_STATEMENT,cond);
    this.then_part = then_part;
    if(then_part != null) then_part.parent = this;
    this.else_part = else_part;
    if(else_part != null) else_part.parent = this;
  }

  public IfBlock(IfBlock b){
    super(b);
    if(b.then_part != null) this.then_part = b.then_part.copy();
    if(b.else_part != null) this.else_part = b.else_part.copy();
  }

  public Block copy() { return new IfBlock(this); }

  public BasicBlock getCondBBlock() { return bblock; }

  public void setCondBBlock(BasicBlock bb) { 
    bblock = bb; 
    bb.parent = this;
  }

  public BlockList getThenBody(){ return then_part; }
  public BlockList getElseBody(){ return else_part; }
  public void setThenBody(BlockList s){
    then_part = s;
    s.parent = this;
  }
  public void setElseBody(BlockList s) {
    else_part = s;
    s.parent = this;
  }

  public void visitBody(BasicBlockVisitor v){ 
    v.visit(then_part); 
    v.visit(else_part); 
  }

  public Xobject toXobject(){
    Xobject then_x = null;
    Xobject else_x = null;
    if(getThenBody() != null) then_x = getThenBody().toXobject();
    if(getElseBody() != null) else_x = getElseBody().toXobject();
    Xobject x = new XobjList(Opcode(),getCondBBlock().toXobject(),
			     then_x,else_x);
    x.setLineNo(getLineNo());
    return x;
  }
}

