// $Id: PragmaBlock.java,v 1.4 1999/09/17 03:36:48 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.block;
import exc.object.*;

//
// for pragma
//
public class PragmaBlock extends CompoundBlock {
  int pragma;
  Xobject args;

  // statement block with null BasicBlock
  public PragmaBlock(int code, int pragma, Xobject args,BlockList body){
    super(code,body);
    this.code = code;
    this.pragma = pragma;
    this.args = args;
  }

  public int getPragma() { return pragma; }
  public Xobject getClauses() { return args; }

  public Xobject toXobject() {
    Xobject x = new XobjList(Opcode(),
			     new XobjInt(Xcode.INT_CONSTANT,pragma),
			     args,super.toXobject());
    x.setLineNo(getLineNo());
    return x;
  }
}

