// $Id: topdownBlockIterator.java,v 1.3 2000/04/10 04:10:22 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.block;
import exc.object.*;
import java.util.Vector;

public class topdownBlockIterator extends BlockIterator {
  Vector blocks;
  int index;

  public topdownBlockIterator(Block b){
    super(b);
    init(b);
  }

  public topdownBlockIterator(BlockList body){
    super(body);
    init(body);
  }

  public void init() { index = 0; currentBlock = (Block)blocks.elementAt(0);}

  public void init(Block b){
    blocks = new Vector();
    topdownTraverse(b);
    index = 0; 
    currentBlock = (Block)blocks.elementAt(0);
  }

  public void init(BlockList body){
    blocks = new Vector();
    topdownTraverse(body);
    index = 0; 
    currentBlock = (Block)blocks.elementAt(0);
  }

  void topdownTraverse(Block b){
    if(b == null) return;
    blocks.addElement((Object)b);
    if(b instanceof IfBlock){
      topdownTraverse(b.getThenBody());
      topdownTraverse(b.getElseBody());
    } else {
      topdownTraverse(b.getBody());
    }
  }

  void topdownTraverse(BlockList b_list){
    if(b_list == null) return;
    for(Block b = b_list.getHead(); b != null; b = b.getNext()){
      topdownTraverse(b);
    }
  }

  public void next(){ 
    if(++index >= blocks.size()) currentBlock = null;
    else currentBlock = (Block)blocks.elementAt(index); 
  }

  public boolean end(){ return index >= blocks.size(); }
  public int size() { return blocks.size(); }
}


