// $Id: forallInfo.java,v 1.4 2001/01/11 10:12:45 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.flow;

import exc.object.*;
import exc.block.*;
import exc.openmp.*;
import exc.util.XobjectSet;

public class forallInfo extends loopInfo {
  OMPforallBlock forall_b;
  public forallInfo(optBodyEnv env, OMPforallBlock b){
    super(env,
	  b.beginBasicBlock().getCflowOut(0),
	  b.endBasicBlock().getCflowIn(0),
	  b.beginBasicBlock(),
	  b.endBasicBlock());
    forall_b = b;
  }
  
  public void analyzeLoop(XobjectSet readOnlySet){
    this.readOnlySet = readOnlySet;

    chkOp = forall_b.getCheckOpcode();
    incOp = Xcode.PLUS_EXPR;
    step = forall_b.getStep();
    ub = forall_b.getUpperBound();
    lb = forall_b.getLowerBound();

    // don't need find loop variable!
    loop_var = forall_b.getLoopVar();

    collectLoopInvariant();
  }

  public rangeExpr rangeExpr(Xobject e){
    return rangeExpr.ForAll(lb,ub,step,incOp,chkOp,
			    Xcons.List(stepExpr(e,Xcons.IntConstant(1)),
				       inductionExpr(e,Xcons.IntConstant(0))),
			    forall_b.getSched(),
			    forall_b.getChunk());
  }

  public rangeExpr rangeExprWithExpr(Xobject e){
    return rangeExpr.ForAll(lb,ub,step,incOp,chkOp,e,
			    forall_b.getSched(),
			    forall_b.getChunk());
  }
}



