// $Id: liveVariableAnalyzer.java,v 1.6 2000/12/12 03:19:31 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.flow;

import exc.object.*;
import exc.block.*;
import exc.util.*;

public class liveVariableAnalyzer implements DataFlowSets,liveVariableInfo {
  static String propUse = "liveVariable:use";
  static String propDef = "liveVariable:def";
  static String propIn = "liveVariable:in";
  static String propOut = "liveVariable:out";

  ControlFlowGraph cfg;

  Statement current_statement;
  XobjectSet current_use_set;
  XobjectSet current_def_set;
  XobjectSet side_effect_set;

  public void run(optBodyEnv env){
    run(env.getCFG());
  }

  public void run(ControlFlowGraph cfg){
    this.cfg = cfg;
    setupDefUse();
    cfg.solveReverseUnionFlow(this);
  }

  // compute DEF/USE set
  void setupDefUse(){
    side_effect_set = new XobjectSet();
    for(BasicBlock bb = cfg.getHead(); bb != null; bb = bb.topNext()){
      current_def_set = new XobjectSet();
      current_use_set = new XobjectSet();
      defuseExpr(bb.getExpr());
      for(current_statement = bb.getTail(); current_statement != null; 
	  current_statement = current_statement.getPrev()){
	defuseExpr(current_statement.getExpr());
      }
      bb.setProp(propUse,current_use_set);
      bb.setProp(propDef,current_def_set);
      bb.setProp(propIn,new XobjectSet());
      bb.setProp(propOut,new XobjectSet());
    }

    // remove variable which may be modified by side effect.
    if(!side_effect_set.isEmpty()){
      for(BasicBlock bb = cfg.getHead(); bb != null; bb = bb.topNext()){
	((Set)bb.getProp(propUse)).remove(side_effect_set);
	((Set)bb.getProp(propDef)).remove(side_effect_set);
      }
    }
  }

  void defuseExpr(Xobject e){
    if(e == null) return;
    if(e.isSet() && e.left().isLocalVar()){
      Xobject x = e.left();
      current_def_set.add(x);
      current_use_set.remove(x); // kill prevous use
      e = e.right();
    }
    XobjectIterator i = new bottomupXobjectIterator(e);
    for(i.init(); !i.end(); i.next()){
      Xobject x = i.getXobject();
      if(x == null) continue;
      if(x.isLocalVar()){
	if(i.getParent() != null &&
	   i.getParent().Opcode() == Xcode.ADDR_OF){
	  side_effect_set.add(x);
	  continue;
	}
	current_use_set.add(x);
      } else if(x.isLocalVarAddr())
	side_effect_set.add(Xcons.PointerRef(x));
    }
  }

  /* interface to DataFlowSet */
  public void initSet(BasicBlock bb){ InSet(bb).copy(GenSet(bb)); }
  public Set emptySet(){ return new XobjectSet();   }
  public Set KillSet(BasicBlock bb){return (XobjectSet)bb.getProp(propDef); }
  public Set GenSet(BasicBlock bb){ return (XobjectSet)bb.getProp(propUse); }
  public Set InSet(BasicBlock bb){ return (XobjectSet)bb.getProp(propIn); }
  public Set OutSet(BasicBlock bb){ return (XobjectSet)bb.getProp(propOut); }

  /*
   * liveVariableInfo interface
   */
  public XobjectSet getLiveInVars(BasicBlock bb){
    return (XobjectSet)bb.getProp(propIn);
  }
  public XobjectSet getLiveOutVars(BasicBlock bb){
    return (XobjectSet)bb.getProp(propOut);
  }
  public XobjectSet getDefVars(BasicBlock bb){
    return (XobjectSet)bb.getProp(propDef);
  }
  public XobjectSet getUseVars(BasicBlock bb){
    return (XobjectSet)bb.getProp(propUse);
  }
}


