// $Id: ArrayType.java,v 1.6 2000/09/01 10:04:26 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.object;

public class ArrayType extends Xtype {
  Xtype ref;
  int dim;
  Xobject asize;

  public ArrayType(int id,Xtype ref,int dim,int size,byte align,
		   boolean ic,boolean iv,Xobject asize){
      super(Xtype.ARRAY,id,size,align,ic,iv);
      this.ref = ref;
      this.dim = dim;
      this.asize = asize;
  }

  public ArrayType(Xtype ref,int dim){
    super(Xtype.ARRAY,0,ref.getSize(),ref.getAlign(),false,false);
    this.ref = ref;
    this.dim = dim;
  }

  public Xtype getRef() { return ref; }
  public int getArrayDim() { return dim; }
  public Xobject getArrayAdjSize() { return asize; }

  public int getNumDimensions() {  return ref.getNumDimensions()+1;  }

  public Xtype getArrayElementType() { 
    if(ref.isArray()) return ref.getArrayElementType();
    else return ref;
  }

  public Xtype copy() { 
    return new ArrayType(0,ref,dim,size,align,is_const,is_volatile,asize);
  }

  public String toString(){
      return "A"+ Integer.toHexString(type_id);
  }
}

