// $Id: BasicType.java,v 1.6 2000/08/01 05:22:19 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.object;

public class BasicType extends Xtype {
  public final static int UNDEF = 0;	/* undefined */
  public final static int VOID = 1;
  public final static int CHAR = 2;
  public final static int UNSIGNED_CHAR = 3;
  public final static int SHORT = 4;
  public final static int UNSIGNED_SHORT = 5;
  public final static int SIGNED = 6;
  public final static int INT = 7;
  public final static int UNSIGNED_INT = 8;
  public final static int LONG = 9;
  public final static int UNSIGNED_LONG = 10;
  public final static int LONGLONG = 11;
  public final static int UNSIGNED_LONGLONG = 12;
  public final static int FLOAT = 13;
  public final static int DOUBLE = 14;
  public final static int LONG_DOUBLE =15;
  public final static int N_BASIC_TYPE = 16;

  /* extended for Fortran */
  public final static int FCOMPLEX_FLOAT = 16;
  public final static int FCOMPLEX_DOUBLE = 17;

  int basic_type;	// member variable

  // constructor
  public BasicType(int basic_type,int size,byte align){
    super(Xtype.BASIC,0,size,align,false,false);
    this.basic_type = basic_type;
  }

  // constructor
  public BasicType(int basic_type,int size,byte align,boolean ic, boolean iv){
    super(Xtype.BASIC,0,size,align,ic,iv);
    this.basic_type = basic_type;
  }

  public int getBasicType() { return basic_type; }

  public final static String getName(int i){
    return Xtype.basic_type_names[i];
  }
  
  public final static BasicType getType(int i){
    return Xtype.basic_types[i];
  }
 
  public boolean isUnsigned(){
      switch(basic_type){
      case UNSIGNED_CHAR:
      case UNSIGNED_SHORT:
      case UNSIGNED_INT:
      case UNSIGNED_LONG:
      case UNSIGNED_LONGLONG:
	  return true;
      }
      return false;
  }

  public boolean isIntegral(){
      return (basic_type >= CHAR) && (basic_type <= UNSIGNED_LONGLONG);
  }

  public boolean isFloating(){
      return (basic_type >= FLOAT) && (basic_type <= LONG_DOUBLE);
  }

  public static Xtype Conversion(Xtype lt,Xtype rt){
      int b1 = lt.getBasicType();
      int b2 = rt.getBasicType();
      if(b1 > b2) return getType(b1);
      else return getType(b2);
  }

  public Xtype copy(){
    return new BasicType(basic_type,size,align,is_const,is_volatile);
  }

  public String toString(){
    return Xtype.basic_type_names[basic_type];
  }
}



