// $Id: FunctionType.java,v 1.5 2002/02/27 16:05:03 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.object;

public class FunctionType extends Xtype {
  Xtype ref;		// return type
  Xobject param_list;
  boolean is_function_proto;

  public FunctionType(int id,Xtype ref,Xobject param_list,int size,
		      byte align,boolean ic,boolean iv,boolean is_func_proto){
      super(Xtype.FUNCTION,id,size,align,ic,iv);
      this.ref = ref;
      this.param_list = param_list;
      this.is_function_proto = is_func_proto;
  }
  
  public FunctionType(Xtype ref){
      super(Xtype.FUNCTION,0,0,(byte)0,false,false);
      this.ref = ref;
  }

  public Xtype getRef() { return ref; }
  public Xobject getFuncParam() { return param_list; }
  public boolean isFuncProto() { return is_function_proto; }

  public void setFuncParam(Xobject param_list){
    this.param_list = param_list;
    this.is_function_proto = true;
  }

  public void setFuncParamIdList(Xobject id_list){
    Xobject param_list = Xcons.emptyList();
    for(XobjArgs a = id_list.getArgs(); a != null; a = a.nextArgs()){
      Ident id = (Ident)a.getArg();
      param_list.add(Xcons.Symbol(Xcode.IDENT,id.Type(),id.getName()));
    }
    setFuncParam(param_list);
  }

  public Xtype copy() { 
    return new FunctionType(0,ref,param_list,size,align,
			    is_const,is_volatile,is_function_proto);
  }

  public String toString(){
      return "F"+ Integer.toHexString(type_id);
  }
}

