// $Id: PointerType.java,v 1.4 1999/11/05 04:36:00 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.object;

public class PointerType extends Xtype {
  Xtype ref;
  
  public PointerType(int id, Xtype ref,int size,byte align,
		     boolean ic, boolean iv){
      super(Xtype.POINTER,id,size,align,ic,iv);
      this.ref = ref;
  }

  public PointerType(Xtype ref){
    super(Xtype.POINTER,0,Machine.pointerSize,Machine.pointerAlign,
	  false,false);
    if(ref.isArray()) this.ref = ref.getRef();
    else this.ref = ref;
  }
       
  public Xtype getRef() { return ref; }

  public Xtype copy() { 
    return new PointerType(0,ref,size,align,is_const,is_volatile);
  }

  public String toString(){
      return "P"+Integer.toHexString(type_id);
  }
}

