// $Id: PropObject.java,v 1.3 2000/07/28 04:06:21 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.object;
import java.util.Vector;

/**
 * Super class of objects which has a property list.
 *   The property list is implmented by a Vector
 */
public class PropObject {
  Vector props;
  
  public void setProp(Object key,Object value){
    if(props == null) props = new Vector();
    int index = props.indexOf(key);
    if(index == -1){
      props.addElement(key);
      props.addElement(value);
    } else {
      props.setElementAt(value,index+1);
    }
  }

  public Object getProp(Object key){
    if(props == null) return null;
    int index = props.indexOf(key);
    if(index == -1) return null;
    else return props.elementAt(index+1);
  }

  public void remProp(Object key){
    if(props == null) return;
    int index = props.indexOf(key);
    if(index == -1) return;
    else {
      props.removeElementAt(index);
      props.removeElementAt(index);
    }
  }

  public void remProperties(){
    props = null;
  }

  public Vector getProperties(){
    return props;
  }
  
  public void setProperties(Vector props){
    this.props = props;
  }
}

