// $Id: StorageClass.java,v 1.6 2002/02/16 20:55:31 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.object;
import java.io.*;

public class StorageClass {
  public final static int SNULL = 0;	/* undefined */
  public final static int AUTO = 1;	/* auto variable */
  public final static int PARAM = 2;	/* paramter */
  public final static int EXTERN = 3;	/* extern variable */
  public final static int EXTDEF = 4;	/* external defition */
  public final static int STATIC = 5;	/* static variable */
  public final static int REGISTER = 6;	/* register variable */
  public final static int LABEL = 7;	/* label */
  public final static int ULABEL = 8;	/* undefined label, (temporary) */
  public final static int TAGNAME = 9;	/* tag name for struct/union/enum */
  public final static int MOE = 10;		/* member of enum */
  public final static int TYPEDEF_NAME = 11;
  public final static int REG = 12;	/* register, temporary variable */
  public final static int FPARAM = 13;	/* fortran paramemter */
  public final static int FCOMM = 14;	/* fortran common variable */
  public final static int TEMP = 15;	/* front-end generated temporary */
  public final static int CTEMP = 16;	/* front-end read-only temporary */
  public final static int MEMBER = 17;	/* C++ class member */
  public final static int N_STORAGE_CLASS = 18;

  static String class_name[] = {
    "*",
    "auto",
    "param",
    "extern",
    "extern_def",
    "static",
    "register",
    "label",
    "_label",
    "tagname",
    "moe",
    "typedef_name",
    "reg",
    "fparam",
    "fcomm",
    "temp",
    "ctemp",
    "member",
    ""};
  
  static void fatal(String msg){
    System.err.println("Fatal StroageClass: "+msg);
    Thread.dumpStack();
    System.exit(1);
  }

  public static String getName(int i){
    return class_name[i];
  }

  public static int findClass(String s){
    for(int i = 0; i < N_STORAGE_CLASS; i++)
      if(s.equals(class_name[i])) return i;
    fatal("unkown class '"+s+"'");
    return 0;
  }
}



