static char rcsid[] = "$Id: X-codegen.c,v 1.5 2000/02/01 09:35:27 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#define MAX_CODE 256

char line[BUFSIZ];
char code_name[MAX_CODE][30];
char code_kind[MAX_CODE];

int
main()
{
    int i,n;
    char *cp;

    n = 0;
    while(fgets(line, BUFSIZ, stdin) != NULL){
	cp = line;
	while(isspace((int)*cp)) cp++;
	if(*cp == '#' || *cp == '\0') continue;
	if(sscanf(line,"%c %s",&code_kind[n],code_name[n]) != 2){
	    fprintf(stderr,"bad line;'%s'\n",line);
	    exit(1);
	}
	n++;
    }
#ifdef not
    for(i = 0; i < n; i++){
	printf("kind=%c code='%s'\n",code_kind[i],code_name[i]);
    }
#endif
    printf("/* generated file from X-exprcode.def. Don't edit! */\n\n");
    printf("package exc.object;\n");
    printf("public class Xcode {\n");
    printf("public final static int MAX_CODE = %d;\n",n);
    for(i = 0; i < n; i++){
	printf("public final static int %s = %d;\n",code_name[i],i);
    }

    printf("final static String name[] = {\n");
    for(i = 0; i < n; i++){
	printf("\"%s\",\t/* %d */\n",code_name[i],i);
    }
    printf("\"MAX_CODE\"};\n");

    printf("final static char kind[] = {\n");
    for(i = 0; i < n; i++){
	printf("'%c',\t/* %d */\n",code_kind[i],i);
    }
    printf("'\\0'};\n");

    printf("public static String getName(int code){ return name[code]; }\n");
    printf("}\n/*EOF*/\n");

    return 0;
}

