// $Id: XobjInt.java,v 1.3 2000/05/01 02:41:36 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.object;

public class XobjInt extends Xobject {
  int value;
  public XobjInt(int code,Xtype type,int value){
    super(code,type);
    this.value = value;
  }
  public XobjInt(int code,int value){
    super(code,null);
    this.value = value;
  }
  public int getInt(){
    return value;
  }
  public Xobject copy(){
    return new XobjInt(code,type,value);
  }
  public boolean equals(Xobject x){
    return super.equals(x) && value == x.getInt();
  }
  public String getName(){
    if(code == Xcode.REG) return "_r_"+Integer.toHexString(value);
    else return Integer.toString(value);
  }
  public String toString(){
    return "("+OpcodeName()+" "+Integer.toHexString(value)+")";
  }
}


