// $Id: XobjList.java,v 1.13 2003/03/26 18:54:21 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.object;

public class XobjList extends Xobject {
  XobjArgs args;
  XobjArgs tail;	// for add
  LineNo lineno;

  public XobjList(){
    super(Xcode.LIST,null);
  }
  public XobjList(int code,Xtype type){
    super(code,type);
  }
  public XobjList(int code,Xtype type,XobjArgs a){
    super(code,type);
    args = a;
  }
  public XobjList(int code,Xtype type,Xobject a1){
    super(code,type);
    args = new XobjArgs(a1,null);
  }
  public XobjList(int code,Xtype type,Xobject a1,Xobject a2){
    super(code,type);
    args = new XobjArgs(a1,new XobjArgs(a2,null));
  }
  public XobjList(int code,Xtype type,Xobject a1,Xobject a2,Xobject a3){
    super(code,type);
    args = new XobjArgs(a1, new XobjArgs(a2,new XobjArgs(a3,null)));
  }
  public XobjList(int code,Xtype type,Xobject a1,Xobject a2,Xobject a3,
		  Xobject a4){
    super(code,type);
    args = new XobjArgs(a1,new XobjArgs(a2, new XobjArgs(a3,new XobjArgs(a4,null))));
  }
  public XobjList(int code,Xtype type,Xobject a1,Xobject a2,Xobject a3,
		  Xobject a4,Xobject a5){
    super(code,type);
    args = new XobjArgs(a1,new XobjArgs(a2, new XobjArgs(a3,new XobjArgs(a4, new XobjArgs(a5,null)))));
  }

  public XobjList(int code){
    super(code,null);
  }
  public XobjList(int code,XobjArgs a){
    super(code,null);
    args = a;
  }
  public XobjList(int code,Xobject a1){
    super(code,null);
    args = new XobjArgs(a1,null);
  }
  public XobjList(int code,Xobject a1,Xobject a2){
    super(code,null);
    args = new XobjArgs(a1,new XobjArgs(a2,null));
  }
  public XobjList(int code,Xobject a1,Xobject a2,Xobject a3){
    super(code,null);
    args = new XobjArgs(a1, new XobjArgs(a2,new XobjArgs(a3,null)));
  }
  public XobjList(int code,Xobject a1,Xobject a2,Xobject a3,Xobject a4){
    super(code,null);
    args = new XobjArgs(a1,new XobjArgs(a2, new XobjArgs(a3,new XobjArgs(a4,null))));
  }
  public XobjList(int code,Xobject a1,Xobject a2,Xobject a3,
		  Xobject a4,Xobject a5){
    super(code,null);
    args = new XobjArgs(a1,new XobjArgs(a2, new XobjArgs(a3,new XobjArgs(a4, new XobjArgs(a5,null)))));
  }
    
  public void add(Xobject a){
    if(args == null){
      args = new XobjArgs(a,null);
      return;
    }
    if(tail == null){
      for(tail = args; tail.nextArgs() != null; tail = tail.nextArgs());
    }
    tail.next = new XobjArgs(a,null);
    tail = tail.next;
  }

  public Xobject operand(){
    if(args == null) return null;
    return args.getArg();
  }
  public Xobject left(){
    if(args == null) return null;
    return args.getArg();
  }
  public Xobject right(){
    if(args == null || args.nextArgs() == null) return null;
    return args.nextArgs().getArg();

  }
  public void setOperand(Xobject x){
    args.setArg(x);
  }
  public void setLeft(Xobject x){
    args.setArg(x);
  }
  public void setRight(Xobject x){
    args.nextArgs().setArg(x);
  }
  public XobjArgs getArgs() {
    return args;
  }
  public void setArgs(XobjArgs l) {
    args = l; tail = null;
  }
  public Xobject getArg(int i){
    XobjArgs a = args;
    while(i > 0){
      a = a.nextArgs();
      i--;
    }
    return a.getArg();
  }
  public void setArg(int i,Xobject x){
    XobjArgs a = args;
    while(i > 0){
      a = a.nextArgs();
      i--;
    }
    a.setArg(x);
  }
  public int Nargs() {
    int i = 0;
    for(XobjArgs a = args; a != null; a = a.nextArgs()) i++;
    return i;
  }

  public void setLineNo(LineNo ln){ lineno = ln; }
  public LineNo getLineNo() { return lineno; }

  public Xobject copy(){
    XobjList x = new XobjList(code,type);
    for(XobjArgs a = args; a != null; a = a.nextArgs()){
      if(a.getArg() == null) x.add(null);
      else x.add(a.getArg().copy());
    }
    return x;
  }
  public boolean equals(Xobject x){
    if(x == null) return false;
    if(!super.equals(x)) return false;
    XobjArgs a1 = args;
    XobjArgs a2 = x.getArgs();
    while(a1 != null){
      if(a2 == null) return false;
      if(a1.getArg() != a2.getArg()){
	if(a1.getArg() == null) return false;
	if(!a1.getArg().equals(a2.getArg())) return false;
      }
      a1 = a1.nextArgs();
      a2 = a2.nextArgs();
    }
    if(a2 != null) return false;
    return true;
  }

  public String toString(){
    String s = "(" + OpcodeName();
    for(XobjArgs a = args; a != null; a = a.nextArgs()){
      if(a.getArg() == null)
	s = s + " ()";
      else 
	s = s + " "+a.getArg();
    }
    return s + ")";
  }
}

