// $Id: XobjLong.java,v 1.3 2000/05/01 02:41:36 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.object;

public class XobjLong extends Xobject {
    long value;
    public XobjLong(int code,Xtype type,long l){
	super(code,type);
	value = l;
    }
    public XobjLong(int code,Xtype type,int high,int low){
	super(code,type);
	value = high;
	value = value << 32;
	long l = low;
	value = value | (l & 0xFFFFFFFFL);
    }
    public XobjLong(int code,Xtype type,double d){
	super(code,type);
	value = Double.doubleToLongBits(d);
    }
    public double getFloat(){
	return Double.longBitsToDouble(value);
    }
    public int getIntHIGH(){
	return (int)(value >> 32);
    }
    public int getIntLOW(){
	return (int)value;
    }
    public long getLong() {
	return value;
    }
    public Xobject copy(){
	return new XobjLong(code,type,value);
    }
    public boolean equals(Xobject x){
	return super.equals(x) && value == x.getLong();
    }
    public String toString(){
	return "("+OpcodeName()+" "+value+")";
    }
}


