// $Id: XobjectDef.java,v 1.7 2002/02/16 20:55:31 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.object;

/**
 * Definition in Xobject File
 *	iterator for definitions in Xobject file
 */
public class XobjectDef extends PropObject {
  XobjectDefEnv parent;
  Xobject def;
  XobjectDef next;
  XobjectDef prev;
  XobjectDefEnv defs;

  public XobjectDef(Xobject def){
    this.def = def;
    if(def.Opcode() == Xcode.TYPE_DEFINITION){
      defs = new XobjectDefEnv(def.getArg(0));
      Xobject decls = def.getArg(1);
      if(decls.Opcode() == Xcode.LIST){
	for(XobjArgs a = decls.getArgs(); a != null; a = a.nextArgs())
	  defs.add(a.getArg());
      } else 
	defs.add(decls);
    }
  }

  // static constructor 
  public static XobjectDef Func(String name,Xobject id_list,
				Xobject decls, Xobject body){
    return new XobjectDef(Xcons.List(Xcode.FUNCTION_DEFINITION,
				     Xcons.Symbol(Xcode.IDENT,name),
				     id_list,decls,body));
  }

  public static XobjectDef Var(String name,Xobject initializer){
    return new XobjectDef(Xcons.List(Xcode.VAR_DECL,
				     Xcons.Symbol(Xcode.IDENT,name),
				     initializer));
  }

  public Xobject getDef(){ return def;}
  public XobjectDef getNext() { return next; }
  public XobjectDef getPrev() { return prev; }
  public XobjectDefEnv getParent() { return parent; }
  public XobjectFile getFile() { 
    XobjectDefEnv p = parent;
    while(p.parent != null) /* */;
    return (XobjectFile)p;
  }

  public void setDef(Xobject def){ this.def = def; }

  public boolean isFuncDef(){
    return def != null && def.Opcode() == Xcode.FUNCTION_DEFINITION;
  }
  public boolean isVarDecl(){	
    return def != null && def.Opcode() == Xcode.VAR_DECL; 
  }
  public boolean isExternDecl(){ 
    return def != null && def.Opcode() == Xcode.EXT_DECL; 
  }

  public String getName(){ return def.getArg(0).getSym();  }
  public void setName(String name)
  { def.setArg(0,Xcons.Symbol(Xcode.IDENT,name));  }
  public Xobject getInitializer(){  return def.getArg(1); }
  public Xobject getFuncParamIdList(){ return def.getArg(1); }
  public Xobject getFuncParamDecls(){	return def.getArg(2); }
  public Xobject getFuncBody(){ return def.getArg(3); }

  // remove itself
  public void remove(){
    if(prev == null){ // head of double linked list 
      parent.head = next;
      if(next != null) next.prev = null;
    } else 
      prev.next = next;
    if(next == null) { // tail of double linked list 
      parent.tail = prev;
      if(prev != null) prev.next = null;
    } else
      next.prev = prev;
    parent = null;
    next = null;
    prev = null;
  }

  // add s after this
  public XobjectDef add(Xobject x){
    return add(new XobjectDef(x));
  }
  public XobjectDef add(XobjectDef s){
    s.parent = parent;
    s.next = next;
    next = s;
    s.prev = this;
    if(s.next == null){ // tail of list
      parent.tail = s;
    } else {
      s.next.prev = s;
    }
    return s;
  }

  // insert s before this 
  public XobjectDef insert(Xobject x){
    return insert(new XobjectDef(x));
  }
  public XobjectDef insert(XobjectDef s){
    s.parent = parent;
    s.prev = prev;
    prev = s;
    s.next = this;
    if(s.prev == null){ // head of list
      parent.head = s;
    } else {
      s.prev.next = s;
    }
    return s;
  }
}


