// $Id: XobjectDefEnv.java,v 1.2 2002/02/06 16:59:18 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.object;

import java.io.*;
import java.util.*;

public class XobjectDefEnv extends PropObject {
  protected Xobject identList;
  protected XobjectDef head,tail;
  protected XobjectDefEnv parent;
  
  public XobjectDefEnv() { }

  public XobjectDefEnv(Xobject identList){
    this.identList = identList;
  }

  public XobjectDef getHead() { return head; }
  public XobjectDef getTail() { return tail; }
  
  public void add(XobjectDef s){
    s.parent = this;
    if(tail == null){
      head = tail = s;
      return;
    }
    tail.next = s;
    s.prev = tail;
    tail = s;
  }

  public void add(Xobject x){
    if(x.Opcode() == Xcode.LIST){
      for(XobjArgs a = x.getArgs(); a != null; a = a.nextArgs())
	add(a.getArg());
      return;
    }
    add(new XobjectDef(x));
  }

  public void insert(XobjectDef s){
    s.parent = this;
    if(tail == null){
      head = tail = s;
      return;
    }
    head.prev = s;
    s.next = head;
    head = s;
  }

  public void insert(Xobject x){
    insert(new XobjectDef(x));
  }
  
  //
  // iterator
  // 
  public void iterateDef(XobjectDefVisitor op){
    for(XobjectDef i = head; i != null; i = i.getNext()) op.doDef(i);
  }

  public void iterateFuncDef(XobjectDefVisitor op){
    for(XobjectDef i = head; i != null; i = i.getNext())
      if(i.isFuncDef()) op.doDef(i);
  }

  // search ident name in identList
  public Ident findIdent(String name){
    for(XobjArgs a = identList.getArgs(); 
	a != null; a = a.nextArgs()){
      Ident id = (Ident) a.getArg();
      if(name.equals(id.getName())) return(id);
    }
    return null;
  }

  // search ident id in identList
  public Ident findIdent(Ident id){
    for(XobjArgs a = identList.getArgs(); 
	a != null; a = a.nextArgs()){
      if(a.getArg() == (Xobject)id) return id;
    }
    return null;
  }
}




