// $Id: Xtype.java,v 1.13 2003/07/16 02:27:06 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.object;

public class Xtype {
  // type kind 
  public final static int UNDEF = 0;
  public final static int BASIC = 1;
  public final static int ENUM = 2;
  public final static int STRUCT = 3;
  public final static int UNION = 4;
  public final static int FUNCTION = 5;
  public final static int ARRAY = 6;
  public final static int POINTER = 7;
  public final static int CLASS = 8;

  Xtype link;	/* link */
  int type_id;
  int type_kind;

  boolean is_initialized;
  boolean is_const;		/* TYPE QUALIFIER */
  boolean is_volatile;
  boolean is_marked;		/* for marking */
  byte align;			/* alignment of this type */
  int size;			/* total size in bytes */

  Xtype copyed;			/* pointer to original copy */

    // constructor
  public Xtype(int kind){
    type_kind = kind;
  }
  public Xtype(int kind, int id, int size, byte align,
	       boolean ic, boolean iv){
    type_kind = kind;
    type_id = id;
    this.size = size;
    this.align = align;
    is_const = ic;
    is_volatile = iv;
  }

  //    public void Link(Xtype type){ link = type; }
  //    public Xtype getNext(){ return link; }
  public int Id() { return type_id; }  

  public int getKind(){  return type_kind; }
  public int getSize() { return size; }
  public byte getAlign() { return align; }
  public boolean isConst() { return is_const; }
  public boolean isVolatile() { return is_volatile; }

  public int getBasicType() { fatal("getBasicType",this); return 0; }
  public Xtype getRef() { fatal("getRef",this); return null; }
  public boolean isFuncProto() { fatal("isFuncProto",this); return false; }
  public Xobject getFuncParam() { fatal("getFuncProto",this); return null; }
  public int getArrayDim() { fatal("getArrayDim",this); return 0; }
  public Xobject getArrayAdjSize() { fatal("getArrayAdjSize",this); return null; }
  public int getNumDimensions() { return 0; }
  public Xtype getArrayElementType() { fatal("getArrayElementType",this); return null; }
  public Xobject getMoeList() { fatal("getMoeList",this); return null; }
  public Xobject getMemberList() { fatal("getMemberList",this); return null; }
  public String getTagName() { fatal("getTagName",this); return null; }
  public Ident getTagIdent() { fatal("getTagIdent",this); return null; }
  public void setTagIdent(Ident tag) { fatal("setTagIdent",this); }

  public Xtype copy() { 
    Xtype t = new Xtype(type_kind,type_id,size,align,is_const,is_volatile);
    return t;
  }

  public boolean isFunction() { return type_kind == FUNCTION; }
  public boolean isPointer() { return (type_kind == POINTER ||
				       type_kind == ARRAY); }
  public boolean isArray() { return type_kind == ARRAY; }
  public boolean isStruct() { return type_kind == STRUCT; }
  public boolean isUnion() { return type_kind == UNION; }
  public boolean isEnum() { return type_kind == ENUM; }

  public boolean isUnsigned() { return false; }
  public boolean isIntegral() { return false; }
  public boolean isFloating() { return false; }
  public boolean isScalar() { return isIntegral() || isFloating(); }

  public boolean equals(Xtype t){
    if(t == this) return true;
    if(type_kind != t.type_kind) return false;
    switch(type_kind){
    case BASIC:
      return this.getBasicType() == t.getBasicType();
    case ENUM:
    case STRUCT:
    case UNION:
    case CLASS:
      break;
    case ARRAY:
      if(this.getArrayDim() != t.getArrayDim()) return false;
    case FUNCTION:
    case POINTER:
      return this.getRef().equals(t.getRef());
    }
    return false;
  }

  public String toString(){
    return "?type?";
  }

  static void fatal(String msg,Xtype t){
    System.err.println("Fatal Xtype:"+msg+" at "+t);
    Thread.dumpStack();
    System.exit(1);
  }


  /*
     * static constructor
     */
  public static PointerType Pointer(Xtype ref){
    return new PointerType(ref);
  }

  public static FunctionType Function(Xtype ref){
    return new FunctionType(ref);
  }

  public static ArrayType Array(Xtype ref,int dim){
    return new ArrayType(ref,dim);
  }

  /* 
   * for Fortran Complex
   */
  public static boolean isFComplex(Xtype t){
    return t.isStruct() && 
      t.getMemberList().getArg(0).getName().equals("re") &&
      t.getMemberList().getArg(1).getName().equals("im");
  }

  public static int FComplexBasicType(Xtype t){
    if(t.getMemberList().getArg(0).Type() == Xtype.floatType)
      return BasicType.FCOMPLEX_FLOAT;
    else 
      return BasicType.FCOMPLEX_DOUBLE;
  }

  /* 
   * for pre-defined basic type
   */
  public static final BasicType voidType = 
  new BasicType(BasicType.VOID,0,(byte)0);
  public static final BasicType charType =
  new BasicType(BasicType.CHAR,Machine.charSize,Machine.charAlign);
  public static final BasicType shortType = 
  new BasicType(BasicType.SHORT,Machine.shortSize,Machine.shortAlign);
  public static final BasicType intType = 
  new BasicType(BasicType.INT,Machine.intSize,Machine.intAlign);
  public static final BasicType longType = 
  new BasicType(BasicType.LONG,Machine.longSize,Machine.longAlign);
  public static final BasicType longlongType = 
  new BasicType(BasicType.LONGLONG,Machine.longlongSize,Machine.longlongAlign);
  public static final BasicType unsignedcharType = 
  new BasicType(BasicType.UNSIGNED_CHAR,Machine.charSize,Machine.charAlign);
  public static final BasicType unsignedshortType = 
  new BasicType(BasicType.UNSIGNED_SHORT,Machine.shortSize,Machine.shortAlign);
  public static final BasicType unsignedType= 
  new BasicType(BasicType.UNSIGNED_INT,Machine.intSize,Machine.intAlign);
  public static final BasicType unsignedlongType =  
  new BasicType(BasicType.UNSIGNED_LONG,Machine.longSize,Machine.longAlign);
  public static final BasicType unsignedlonglongType = 
  new BasicType(BasicType.UNSIGNED_LONGLONG,Machine.longlongSize,Machine.longlongAlign);
  public static final BasicType floatType = 
  new BasicType(BasicType.FLOAT,Machine.floatSize,Machine.floatAlign);
  public static final BasicType doubleType = 
  new BasicType(BasicType.DOUBLE,Machine.doubleSize,Machine.doubleAlign);
  public static final BasicType longdoubleType = 
  new BasicType(BasicType.LONG_DOUBLE,Machine.longdoubleSize,Machine.longdoubleAlign);
  public static final BasicType signedType = 
  new BasicType(BasicType.SIGNED,Machine.intSize,Machine.intAlign);

  static final BasicType basic_types[] = { 
    null,
    voidType, 
    charType,
    unsignedcharType,
    shortType,
    unsignedshortType,
    signedType,
    intType,
    unsignedType,
    longType,
    unsignedlongType,
    longlongType,
    unsignedlonglongType,
    floatType,
    doubleType,
    longdoubleType
  };

  final static String basic_type_names[] = {
    "*undef*",
    "void",
    "char",
    "unsigned_char",
    "short",
    "unsigned_short",
    "signed",
    "int",
    "unsigned",
    "long",
    "unsigned_long",
    "long_long",
    "unsigned_long_long",
    "float",
    "double",
    "long_double",
    ""};

  public static final Xtype stringType = 
  new PointerType(BasicType.charType);
}



