// $Id: bottomupXobjectIterator.java,v 1.3 1999/05/20 09:32:31 m-hirano Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.object;

import java.util.Stack;

public class bottomupXobjectIterator extends XobjectIterator {
    Stack obj_stack;
    Stack arg_stack;

    public bottomupXobjectIterator(Xobject x){
	topXobject = x;
    }

    public void init(){ init(topXobject); }

    public void init(Xobject x){
	obj_stack = new Stack();
	arg_stack = new Stack();

	currentXobject = x;
	while(currentXobject != null &&
	      currentXobject.Opcode() != Xcode.ID_LIST &&
	      currentXobject instanceof XobjList &&
	      currentXobject.getArgs() != null){
	    obj_stack.push(currentXobject);
	    arg_stack.push(currentArgs);
	    currentArgs = null;
	    for(XobjArgs args = currentXobject.getArgs(); args != null;
		args = args.nextArgs()){
		arg_stack.push(currentArgs);
		currentArgs = args;
	    }
	    currentXobject = currentArgs.getArg(); // next
	}
    }

    public void next(){
	if(obj_stack.empty()){
	    currentXobject = null;
	    return;
	}
	currentArgs = (XobjArgs)arg_stack.pop();
	if(currentArgs == null){
	    currentXobject = (Xobject)obj_stack.pop();
	    currentArgs = (XobjArgs)arg_stack.pop();
	    return;
	}
	currentXobject = currentArgs.getArg();
	while(currentXobject != null &&
	      currentXobject.Opcode() != Xcode.ID_LIST &&
	      currentXobject instanceof XobjList &&
	      currentXobject.getArgs() != null){
	    obj_stack.push(currentXobject);
	    arg_stack.push(currentArgs);
	    currentArgs = null;
	    for(XobjArgs args = currentXobject.getArgs(); args != null; 
		args = args.nextArgs()){
		arg_stack.push(currentArgs);
		currentArgs = args;
	    }
	    currentXobject = currentArgs.getArg(); // next
	}
    }

    public boolean end() { 
	return currentXobject == null && obj_stack.empty();
    }

    public Xobject getParent() {
	if(obj_stack.empty()) return null;
	else return (Xobject)obj_stack.peek();
    }
}


