// $Id: OMP.java,v 1.11 2000/10/25 05:28:49 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.openmp;

import exc.object.*;

//
// for OMP, all static member defined here
//
public class OMP {
  public final static int PARALLEL = 0;         /* parallel <clause_list> */
  public final static int FOR = 1;      	   /* loop <clause_list> */
  public final static int SECTIONS = 2;         /* sections <clause_list> */
  //  final static int SECTION = 3;          /* section (not used) */
  public final static int SINGLE = 4;           /* single <clause list> */
  public final static int MASTER = 5;           /* master */
  public final static int CRITICAL = 6;         /* critical <name> */
  public final static int BARRIER = 7;          /* barrier */
  public final static int ATOMIC = 8;           /* atomic */
  public final static int FLUSH = 9;            /* flush <namelist> */
  public final static int ORDERED = 10;         /* ordered */
  public final static int THREADPRIVATE = 11;   /* threadprivate <namelist> */
  //  final static int PARALLEL_FOR = 12;     /* parallel for <clause_list>*/
  //  final static int PARALLEL_SECTIONS = 13;/* parallel sections <...> */

  public final static int FUNCTION_BODY = 20;

  public final static int DATA_DEFAULT = 0;      /* default <0,1,2> */
  public final static int DATA_NONE = 0;
  public final static int DATA_PRIVATE = 1;      /* private <namelist> */
  public final static int DATA_SHARED = 2;       /* shared <namelist> */
  public final static int DATA_FIRSTPRIVATE = 3;
  public final static int DATA_LASTPRIVATE = 4;
  public final static int DATA_COPYIN = 5;
  public final static int DATA_REDUCTION_PLUS = 6;
  public final static int DATA_REDUCTION_MINUS = 7;
  public final static int DATA_REDUCTION_MUL = 8;
  public final static int DATA_REDUCTION_BITAND = 9;
  public final static int DATA_REDUCTION_BITOR = 10;
  public final static int DATA_REDUCTION_BITXOR = 11;
  public final static int DATA_REDUCTION_LOGAND = 12;
  public final static int DATA_REDUCTION_LOGOR = 13;
  public final static int DATA_REDUCTION_MIN = 14;
  public final static int DATA_REDUCTION_MAX = 15;

  public static boolean DATA_private(int atr){
    return (atr >= DATA_PRIVATE) && (atr <= DATA_LASTPRIVATE);
  }

  static boolean DATA_reduction(int atr){
    return (atr >= DATA_REDUCTION_PLUS) && (atr <= DATA_REDUCTION_MAX);
  }

  public final static int DATA_DEFAULT_SHARED = 0;
  public final static int DATA_DEFAULT_NONE = 1;
  public final static int DATA_DEFAULT_PRIVATE = 2;

  public final static int DIR_ORDERED = 20;
  public final static int DIR_IF = 21;
  public final static int DIR_NOWAIT = 22;
  public final static int DIR_SCHEDULE = 23;

  public final static int SCHED_NONE = 0;
  public final static int SCHED_STATIC = 1;
  public final static int SCHED_DYNAMIC = 2;
  public final static int SCHED_GUIDED = 3;
  public final static int SCHED_RUNTIME = 4;
  public final static int SCHED_AFFINITY = 5;
  public final static int SCHED_AFFINITY0 = 6;	// internal

  final static String prop = "OMPprop";
  public static boolean errorFlag;
  public static boolean errorFlags;
  public static boolean debugFlag;

  // for debug
  static String dirName(int dir){
    switch(dir){
    case PARALLEL:
      return "parallel";
    case FOR:
      return "for";
    case SECTIONS:
      return "sections";
    case SINGLE:
      return "single";
    case MASTER:
      return "master";
    case CRITICAL:
      return "critical";
    case BARRIER:
      return "barrier";
    case ATOMIC:
      return "atomic";
    case FLUSH:
      return "flush";
    case ORDERED:
      return "ordered";
    case THREADPRIVATE:
      return "threadprivate";
    }
    return "??dir??";
  }

  // for debug
  static String dataAtrName(int atr){
    switch(atr){
    case  DATA_NONE: 
      return "none";
    case  DATA_PRIVATE: 
      return "private";
    case  DATA_SHARED:
      return "shared";
    case  DATA_FIRSTPRIVATE:
      return "firstprivate";
    case  DATA_LASTPRIVATE:
      return "lastprivate";
    case  DATA_COPYIN:
      return "copyin";
    case  DATA_REDUCTION_PLUS:
      return "reduction+";
    case  DATA_REDUCTION_MINUS:
      return "reduction-";
    case  DATA_REDUCTION_MUL:
      return "reduction*";
    case  DATA_REDUCTION_BITAND:
      return "reduction&";
    case  DATA_REDUCTION_BITOR:
      return "reduction|";
    case  DATA_REDUCTION_BITXOR:
      return "reduction^";
    case  DATA_REDUCTION_LOGAND:
      return "reduction&&";
    case  DATA_REDUCTION_LOGOR:
      return "reduction||";
    case  DATA_REDUCTION_MIN:
      return "reduction-min";
    case  DATA_REDUCTION_MAX:
      return "reduction-max";
    }
    return "?dataatr?";
  }

  /*
   *  mode control variables in this OMP package
   */
  static boolean leaveThreadPrivateFlag;
  static boolean moveAutoFlag;

  static public void setMoveAutoFlag(boolean f){
    moveAutoFlag = f;
  }

  static public void leaveThreadPrivate(boolean f){
    leaveThreadPrivateFlag = f;
  }

  final static String thdprv_prop = "ThreadPrivate";

  public static void setThreadPrivate(Ident id){
    id.setProp(thdprv_prop,thdprv_prop);
  }

  public static boolean isThreadPrivate(Ident id){
    if(id == null) return false;
    return (id.getProp(thdprv_prop) != null);
  }

  public static void error(LineNo l, String msg){
    String header = "";
    errorFlag = true;
    errorFlags = true;
    if(l != null) header += "\""+l.fileName()+"\", line "+l.lineNo()+":";
    System.err.println(header + " OpenMP error: "+msg);
  }

  public static void warning(LineNo l, String msg){
    String header = "";
    if(l != null) header += "\""+l.fileName()+"\", line "+l.lineNo()+":";
    System.err.println(header + " OpenMP warning: "+msg);
  }

  public static void fatal(String msg){
    System.err.println("OMP fatal error: "+msg);
    System.exit(1);
  }
}



