// $Id: OMPforallBlock.java,v 1.5 2000/09/27 04:48:33 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.openmp;

import exc.block.*;
import exc.object.*;

//
// OpenMP parallel FOR Block
//  - loop variable
//  - lower bound, upper bound, and step (variable?)
//  - loop scheduling and chunk
// store in the form (SET var (LIST lb ub step)) at BB expr

public class OMPforallBlock extends OMPBlock {
  int sched;
  int checkOp;
  boolean ordered;
  Statement iter_info;

  public OMPforallBlock(Xobject var,Xobject lb,Xobject ub, Xobject step,
			int checkOp, BlockList body,
			int sched,Xobject chunk,boolean ordered){
    super(Xcode.OMP_FORALL);

    // add leading pad and exit pad
    body.add(new BasicBlock());
    body.insert(new BasicBlock());
    setBody(body);

    this.sched = sched;
    this.ordered = ordered;
    this.checkOp = checkOp;
    Xobject args = Xcons.List(lb,ub,step); // for flow analysis.
    if(chunk != null) args.add(chunk);
    iter_info = new Statement(Xcons.Set(var,args));
    this.getBasicBlock().add(iter_info);
  }

  public Xobject getLoopVar()
  { return iter_info.getExpr().getArg(0); }
  public Xobject getLowerBound() 
  { return iter_info.getExpr().getArg(1).getArg(0); }
  public Xobject getUpperBound() 
  { return iter_info.getExpr().getArg(1).getArg(1); }
  public Xobject getStep() 
  { return iter_info.getExpr().getArg(1).getArg(2); }
  public int getCheckOpcode() { return checkOp; }

  public boolean isOrdered() { return ordered; }
  public int getSched() { return sched; }

  public Xobject getChunk() { 
    XobjArgs args = iter_info.getExpr().getArg(1).
      getArgs().nextArgs().nextArgs().nextArgs();
    if(args != null) return args.getArg();
    else return null;
  }
}

