// $Id: OMPparallelBlock.java,v 1.2 2000/04/10 04:12:30 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.openmp;

import exc.block.*;
import exc.object.*;

//
// OpenMP parallel block
//
public class OMPparallelBlock extends OMPBlock {
  public OMPparallelBlock(int narg, BasicBlock setup,
			  BlockList body, Xobject cond){
    super(Xcode.OMP_PARALLEL,setup);
    setNarg(narg);
    setup.setExpr(cond); // set cond exp at end of setup bb.
    setBody(body);
  }
  
  public BasicBlock setupBasicBlock() { return getBasicBlock(); }
  public Xobject getIfExpr() { return beginBasicBlock().getExpr(); }
}





