// $Id: OMPtranslate.java,v 1.7 2002/02/25 17:21:38 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.openmp;

import java.io.*;
import exc.object.*;
import exc.block.*;

public class OMPtranslate implements XobjectDefVisitor
{
  BlockPrintWriter debug_out;
  XobjectFile env;

  // alorithms
  OMPanalyzeDecl anaDecl;
  OMPanalyzePragma anaPragma = new OMPanalyzePragma();
  OMPrewriteExpr rewriteExpr = new OMPrewriteExpr();
  OMPtransPragma transPragma = new OMPtransPragma();

  public void init(XobjectFile env){
    this.env = env;
    anaDecl = new OMPanalyzeDecl(env);
    if(OMP.debugFlag) debug_out = new BlockPrintWriter(System.out);
  }

  // do transform takes three passes
  public void doDef(XobjectDef d){
    if(!d.isFuncDef()){
      anaDecl.analyze(d);
      return;
    }

    if(d.getName().equals("main")){
      // env.declGlobalIdent("_ompc_main",Xtype.Function(BasicType.intType));
      Ident id = env.findIdent("main");
      if(id == null) OMP.fatal("'main' not in id_list");
      id.setName("_ompc_main");
      d.setName("_ompc_main");
    }

    //    if(!haveOMPpragma(d.getDef())) return;
    OMP.errorFlag = false;

    FuncDefBlock fd = new FuncDefBlock(d);
    fd.removeDeclInit();

    anaPragma.run(fd,anaDecl);
    if(OMP.errorFlag) return;

    rewriteExpr.run(fd,anaDecl);
    if(OMP.errorFlag) return;
    
    transPragma.run(fd);

    // finally, replace body
    fd.Finalize();
  }

  // not used?
  boolean haveOMPpragma(Xobject x){
    XobjectIterator i = new topdownXobjectIterator(x);
    for(i.init(); !i.end(); i.next()){
      Xobject xx = i.getXobject();
      if(xx != null && xx.Opcode() == Xcode.OMP_PRAGMA) return true;
    }
    return false;
  }
}


