// $Id: OMPtranslateBlock.java,v 1.6 2002/02/25 17:21:38 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.openmp;

import java.io.*;
import exc.object.*;
import exc.block.*;

public class OMPtranslateBlock implements XobjectDefVisitor
{
  BlockPrintWriter debug_out;
  XobjectFile env;

  // alorithms
  OMPanalyzeDecl anaDecl;
  OMPanalyzePragma anaPragma = new OMPanalyzePragma();
  OMPrewriteExpr rewriteExpr = new OMPrewriteExpr();
  OMPtransPragmaBlock transPragma = new OMPtransPragmaBlock();
  boolean finalize_mode;

  public void init(XobjectFile env,boolean finalize_mode){
    this.env = env;
    this.finalize_mode = finalize_mode;
    if(finalize_mode) return;

    anaDecl = new OMPanalyzeDecl(env);

    if(OMP.debugFlag){
      OutputStream fout;
      fout = System.out;
      try {
	fout = new FileOutputStream("debug.OMPtranlateBlock");
      } catch(IOException e) { };
      debug_out = new BlockPrintWriter(fout);
    }
  }

  // do transform takes three passes
  public void doDef(XobjectDef d){
    if(finalize_mode){
      if(d.isFuncDef()){
	FuncDefBlock fd = new FuncDefBlock(d);
	if(OMP.debugFlag) debug_out.print(fd.getBlock());
	transPragma.transBlock(fd);
	fd.Finalize();
      }
      return;
    }

    if(!d.isFuncDef()){
      anaDecl.analyze(d);
      return;
    }

    if(d.getName().equals("main")){
      //env.declGlobalIdent("_ompc_main",Xtype.Function(BasicType.intType));
      Ident id = env.findIdent("main");
      if(id == null) OMP.fatal("'main' not in id_list");
      id.setName("_ompc_main");
      d.setName("_ompc_main");
    }

    OMP.errorFlag = false;

    FuncDefBlock fd = new FuncDefBlock(d);
    fd.removeDeclInit();

    anaPragma.run(fd,anaDecl);
    if(OMP.errorFlag) return;

    rewriteExpr.run(fd,anaDecl);
    if(OMP.errorFlag) return;
    
    transPragma.run(fd);

    // no Finialize
  }
}

