// $Id: NumberSet.java,v 1.1 2000/09/01 10:11:38 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package exc.util;

import exc.object.*;
import java.util.*;

public class NumberSet implements Set {
  boolean v[];
  int size;
  boolean isempty;
  boolean isfull;

  public NumberSet(int size){
    this.size = size;
    v = new boolean[size];
    isempty = true;
    isfull = false;
  }

  public NumberSet(int size,boolean isfull){
    this.size = size;
    v = new boolean[size];
    this.isempty = !isfull;
    this.isfull = isfull;
  }

  public boolean contain(int k){
    if(isfull) return true;
    if(isempty) return false;
    return v[k];
  }

  public static NumberSet empty(int size){ return new NumberSet(size,false); }
  public static NumberSet full(int size){ return new NumberSet(size,true); }

  public boolean isFull() {
    if(isfull) return true;
    for(int i = 0; i < size; i++)
      if(v[i] == false) return false;
    isfull = true;
    isempty = false;
    return true;
  }

  public boolean isEmpty(){
    if(isempty) return true;
    for(int i = 0; i < size; i++)
      if(v[i] == true) return false;
    isfull = false;
    isempty = true;
    return true;
  }

  public void clear(){
    isfull = false;
    isempty = true;
  }

  public void all() {
    isfull = true;
    isempty = false;
  }

  public void copy(Set set){
    if(set == null){
      clear();
      return;
    }
    NumberSet s = (NumberSet)set;
    isfull = s.isfull;
    isempty = s.isempty;
    if(isfull || isempty) return;
    for(int i = 0; i < size; i++) v[i] = s.v[i];
  }
    
  public void add(int k){
    if(isfull) return;
    if(isempty){
      for(int i = 0; i < size; i++) v[i] = false;
    }
    isempty = false;
    v[k] = true;
  }
    
  public void add(Set set){
    if(set == null) return;
    NumberSet s = (NumberSet)set;
    if(isfull) return;
    if(s.isempty) return;
    if(s.isfull){
      isfull = true;
      isempty = false;
      return;
    }
    if(isempty){
      copy(s);
      return;
    }
    for(int i = 0; i < size; i++) 
      if(s.v[i]) v[i] = true;
  }

  // for intersect
  public void dot(Set set){
    if(set == null){
      clear();
      return;
    }
    NumberSet s = (NumberSet)set;
    if(s.isfull) return;
    if(isempty) return;
    if(isfull){
      copy(set);
      return;
    }
    if(s.isempty){
      clear();
      return;
    }
    for(int i = 0; i < size; i++) 
      v[i] = v[i] && s.v[i];
  }

  public void remove(int k){
    if(isempty) return;
    if(isfull){
      for(int i = 0; i < size; i++) v[i] = true;
    }
    isfull = false;
    v[k] = false;
  }

  public void remove(Set set){
    if(set == null) return;
    NumberSet s = (NumberSet)set;
    if(s.isempty) return;
    if(isempty) return;
    if(s.isfull){
      clear();
      return;
    }
    if(isfull){
      for(int i = 0; i < size; i++) v[i] = !s.v[i];
      isfull = false;
      return;
    }
    for(int i = 0; i < size; i++) 
      if(s.v[i]) v[i] = false;
  }

  // update with s
  public boolean update(Set set){
    NumberSet s = (NumberSet)set;
    if(equals(s)) return false;
    copy(s);
    return true;
  }

  public boolean equals(Set set){
    NumberSet s = (NumberSet)set;
    if(isfull){
      if(s.isfull) return true;
      else return false;
    }
    if(isempty){
      if(s.isempty) return true;
      else return false;
    }
    if(s.isfull || s.isempty) return false;
    for(int i = 0; i < size; i++) 
      if(s.v[i] != v[i]) return false;
    return true;
  }
    
  // create union set
  public NumberSet unionSet(NumberSet s){
    NumberSet ss = new NumberSet(size);
    ss.copy(this);
    ss.add(s);
    return ss;
  }

  // create intersection set
  public NumberSet intersectSet(NumberSet s){
    NumberSet ss = new NumberSet(size);
    ss.copy(this);
    ss.dot(s);
    return ss;
  }

  public String toString(){
    if(isfull) return "[*Full*]";
    if(isempty) return "[ ]";
    StringBuffer b = new StringBuffer();
    b.append("[ ");
    for(int i = 0; i < size; i++){
      if(v[i]){
	b.append(i);
	b.append(" ");
      }
    }
    b.append("]");
    return b.toString();
  }
}



