// $Id: ogrcc.java,v 1.3 2002/02/21 07:17:12 m-hirano Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
//
// CC driver
//
package exc.util;
import exc.object.*;
import exc.openmp.*;

public class ogrcc extends exc.util.ccDriver {

    protected boolean omp_flag = true; 
    protected boolean ogr_flag = true;
    protected boolean doubleAlign = false;

    public
    ogrcc() {
	super("ompcc");
    }

    public
    ogrcc(String name) {
	super(name);
    }

    protected String backend_opts = "";
    protected String nsDir = null;

    public static void
    main(String args[]) { 
	ogrcc driver = new ogrcc();
	driver.run(args);
    }

    public boolean
    parseArg(String arg) { 
	if (arg.equals("-omp")) {
	    omp_flag = false;
	    return true;
	} else if (arg.equals("-ogr")) {
	    ogr_flag = false;
	    return true;
	} else if (arg.equals("-doubleAlign") || arg.equals("-malign-double")) {
	    doubleAlign = true;
	    return true;
	} else {
	    backend_opts += " " + arg;
	    return false;
	}
    }

    public void
    printUsage() { 
	System.err.println("options: -omp, disable OpenMP directives");
	System.err.println("options: -ogr, disable OpenGR directives");
	System.err.println("options: -doubleAlign or -malign-double, if alignment of double is NOT sizeof double, treat alignment of double is sizeof double");
    }

    public void
    init() {
	String cflags = getTemplateValue("OMPC_CFLAGS");
	if (cflags != null) {
	    cc_opts += " " + cflags;
	}

	if (omp_flag) {
	    String approvedDate = getTemplateValue("APPROVED_DATE");
	    if (approvedDate == null) {
		cpp_opts += " -D_OPENMP ";
	    } else {
		cpp_opts += " -D_OPENMP=" + approvedDate + " ";
	    }
	} else {
	    cfront_opts += " -omp ";
	}

	if (ogr_flag) {
	    nsDir = getTemplateValue("NS_DIR");
	    cpp_opts += " -D_OPENGR ";
	} else {
	    cfront_opts += " -ogr ";
	} 

	if (omp_flag || ogr_flag) {
	    ld_opts +=  " "+getTemplateValue("OMPC_MAIN");
	    ld_opts +=  " "+getTemplateValue("OMPC_LDFLAGS");
	}

	if (doubleAlign) {
	    cfront_opts += " -malign-double ";
	    cc_opts += " -malign-double ";
	}

	if (backend_opts != "") {
	    cc_opts += " " + backend_opts;
	}
    }

    public void
    run(XobjectFile f) {
	// NOTE:
	// All OpenGR pragma translation MUST BE done by frontend.

	if (ogr_flag && nsDir != null) {
	    f.addHeaderLine("#include \"" + ompc_dir + "/lib/openmp/include/ogr_runtime.h\"");
	}

	if (!omp_flag) {
	    return;	    // no OpenMP
	}
	if (verbose) {
	    System.err.println("OpenMP pass ...");
	}
	OMPtranslate op = new OMPtranslate();
	op.init(f);
	f.iterateDef(op);	// transform OMP pragma 
	if (OMP.errorFlags) {
	    System.err.println("error in OpenMP. stop.");
	    System.exit(1);
	}
    }
}
